/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.build.DefaultJob_;
import com.atlassian.bamboo.chains.ChainStageImpl;
import com.atlassian.bamboo.chains.ChainStageImpl_;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.StatelessSessionHibernateDaoSupport;
import com.atlassian.bamboo.plan.AbstractChain_;
import com.atlassian.bamboo.plan.AbstractPlan;
import com.atlassian.bamboo.plan.AbstractPlan_;
import com.atlassian.bamboo.plan.PlanDtoDao;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.ChainBranchImpl_;
import com.atlassian.bamboo.plan.branch.MutablePlanBranchMetadata;
import com.atlassian.bamboo.plan.branch.MutablePlanBranchMetadata_;
import com.atlassian.bamboo.plan.dto.ChainBranchMetadataDto;
import com.atlassian.bamboo.plan.dto.ChainBranchMetadataDtoImpl;
import com.atlassian.bamboo.plan.dto.FlatChainStageDto;
import com.atlassian.bamboo.plan.dto.FlatChainStageDtoImpl;
import com.atlassian.bamboo.plan.dto.LabelNameDto;
import com.atlassian.bamboo.plan.dto.LabelNameDtoImpl;
import com.atlassian.bamboo.plan.dto.PlanDto;
import com.atlassian.bamboo.plan.dto.PlanDtoImpl;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanDtoHibernateDao
extends StatelessSessionHibernateDaoSupport
implements PlanDtoDao {
    private static final Logger log = Logger.getLogger(PlanDtoHibernateDao.class);
    private static final String CREATION_DATE_PROPERTY_NAME = "creationDate";
    private static final String MASTER_PROPERTY_NAME = "master";
    private static final String ID_PROPERTY_NAME = "id";
    private static final String BUILD_DEFINITION_XML_PROPERTY_NAME = "buildDefinitionXml";
    private static final String XML_DATA_PROPERTY_NAME = "xmlData";
    private static final String LABEL_PROPERTY_NAME = "label";
    private static final String CHAIN_PROPERTY_NAME = "chain";
    private static final String FINAL_PROPERTY_NAME = "final";

    private CriteriaQuery<PlanDto> createPlanDtoBaseSelect(CriteriaQuery<PlanDto> q, CriteriaBuilder cb, Root<? extends AbstractPlan> entity) {
        Join joinedBuildDefinition = entity.join(BUILD_DEFINITION_XML_PROPERTY_NAME, JoinType.LEFT);
        return q.select((Selection)cb.construct(PlanDtoImpl.class, new Selection[]{entity.get(AbstractPlan_.id), entity.get(AbstractPlan_.discriminator), entity.get(CREATION_DATE_PROPERTY_NAME), entity.get(AbstractPlan_.planKey), entity.get(AbstractPlan_.buildKey), entity.get(AbstractPlan_.buildName), entity.get(AbstractPlan_.description), entity.get(AbstractPlan_.suspendedFromBuilding), entity.get(AbstractPlan_.markedForDeletion), entity.get(AbstractPlan_.oid), entity.get("project").get(ID_PROPERTY_NAME), entity.get(MASTER_PROPERTY_NAME).get(ID_PROPERTY_NAME), entity.get(AbstractChain_.storageTag), entity.get(ChainBranchImpl_.linkedJiraIssue), entity.get(ChainBranchImpl_.remoteJiraLinkRequired), entity.get(ChainBranchImpl_.divergent), entity.get(DefaultJob_.chainStageId), joinedBuildDefinition.get(XML_DATA_PROPERTY_NAME), entity.get(AbstractChain_.notificationSetId), entity.get(DefaultJob_.requirementSetId), entity.get(AbstractPlan_.version)}));
    }

    public List<PlanDto> getAllPlans() {
        log.info((Object)"Fetching all available plans.");
        return new JpaUtils.CriteriaQuery<AbstractPlan, PlanDto>(this.getSessionFactory(), AbstractPlan.class, PlanDto.class){

            @Override
            public void apply() {
                PlanDtoHibernateDao.this.createPlanDtoBaseSelect((CriteriaQuery<PlanDto>)this.q, this.cb, (Root<? extends AbstractPlan>)this.entity);
            }
        }.getResultList();
    }

    @Nullable
    public PlanDto getPlanDtoByKey(final @NotNull PlanKey planKey) {
        return (PlanDto)new JpaUtils.CriteriaQuery<AbstractPlan, PlanDto>(this.getSessionFactory(), AbstractPlan.class, PlanDto.class){

            @Override
            public void apply() {
                PlanDtoHibernateDao.this.createPlanDtoBaseSelect((CriteriaQuery<PlanDto>)this.q, this.cb, (Root<? extends AbstractPlan>)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(AbstractPlan_.planKey), (Object)planKey));
            }
        }.uniqueResult();
    }

    public List<PlanDto> getJobDtosByStageId(final long id) {
        return new JpaUtils.CriteriaQuery<AbstractPlan, PlanDto>(this.getSessionFactory(), AbstractPlan.class, PlanDto.class){

            @Override
            public void apply() {
                PlanDtoHibernateDao.this.createPlanDtoBaseSelect((CriteriaQuery<PlanDto>)this.q, this.cb, (Root<? extends AbstractPlan>)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(DefaultJob_.chainStageId), (Object)id));
            }
        }.getResultList();
    }

    public List<LabelNameDto> getAllLabelNamesAssociatedWithPlans() {
        log.info((Object)"Fetching all label names.");
        return new JpaUtils.CriteriaQuery<AbstractPlan, LabelNameDto>(this.getSessionFactory(), AbstractPlan.class, LabelNameDto.class){

            @Override
            public void apply() {
                ListJoin joinedLabelling = this.entity.join(AbstractPlan_.labellings, JoinType.INNER);
                Join joinedLabellingAndLabel = joinedLabelling.join(PlanDtoHibernateDao.LABEL_PROPERTY_NAME, JoinType.INNER);
                this.q.select((Selection)this.cb.construct(LabelNameDtoImpl.class, new Selection[]{this.entity.get(PlanDtoHibernateDao.ID_PROPERTY_NAME), joinedLabellingAndLabel.get("name")})).where(new Predicate[]{this.cb.isNull((Expression)joinedLabelling.get("buildResultsSummary")), this.cb.equal((Expression)joinedLabellingAndLabel.get("namespace"), (Object)PlanDtoHibernateDao.LABEL_PROPERTY_NAME)}).orderBy(new Order[]{this.cb.asc((Expression)joinedLabellingAndLabel.get("name"))});
            }
        }.getResultList();
    }

    public List<LabelNameDto> getAllLabelNamesAssociatedWithPlan(final long id) {
        return new JpaUtils.CriteriaQuery<AbstractPlan, LabelNameDto>(this.getSessionFactory(), AbstractPlan.class, LabelNameDto.class){

            @Override
            public void apply() {
                ListJoin joinedLabelling = this.entity.join(AbstractPlan_.labellings, JoinType.INNER);
                Join joinedLabellingAndLabel = joinedLabelling.join(PlanDtoHibernateDao.LABEL_PROPERTY_NAME, JoinType.INNER);
                this.q.select((Selection)this.cb.construct(LabelNameDtoImpl.class, new Selection[]{this.entity.get(PlanDtoHibernateDao.ID_PROPERTY_NAME), joinedLabellingAndLabel.get("name")})).where(new Predicate[]{this.cb.equal((Expression)this.entity.get(PlanDtoHibernateDao.ID_PROPERTY_NAME), (Object)id), this.cb.isNull((Expression)joinedLabelling.get("buildResultsSummary")), this.cb.equal((Expression)joinedLabellingAndLabel.get("namespace"), (Object)PlanDtoHibernateDao.LABEL_PROPERTY_NAME)}).orderBy(new Order[]{this.cb.asc((Expression)joinedLabellingAndLabel.get("name"))});
            }
        }.getResultList();
    }

    private CriteriaQuery<FlatChainStageDto> createStageDtoBaseSelect(CriteriaQuery<FlatChainStageDto> q, CriteriaBuilder cb, Root<? extends ChainStageImpl> entity) {
        return q.select((Selection)cb.construct(FlatChainStageDtoImpl.class, new Selection[]{entity.get(ChainStageImpl_.id), entity.get(ChainStageImpl_.name), entity.get(ChainStageImpl_.description), entity.get(ChainStageImpl_.manual), entity.get(FINAL_PROPERTY_NAME), entity.get(ChainStageImpl_.markedForDeletion), entity.get(CHAIN_PROPERTY_NAME).get(ID_PROPERTY_NAME), entity.get(ChainStageImpl_.oid), entity.get(ChainStageImpl_.listPosition)}));
    }

    public List<FlatChainStageDto> getAllPlanStages() {
        log.info((Object)"Fetching all plan stages.");
        return new JpaUtils.CriteriaQuery<ChainStageImpl, FlatChainStageDto>(this.getSessionFactory(), ChainStageImpl.class, FlatChainStageDto.class){

            @Override
            public void apply() {
                PlanDtoHibernateDao.this.createStageDtoBaseSelect((CriteriaQuery<FlatChainStageDto>)this.q, this.cb, (Root<? extends ChainStageImpl>)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(ChainStageImpl_.markedForDeletion), (Object)false));
            }
        }.getResultList();
    }

    public List<FlatChainStageDto> getStageDtosByChainId(final long id) {
        return new JpaUtils.CriteriaQuery<ChainStageImpl, FlatChainStageDto>(this.getSessionFactory(), ChainStageImpl.class, FlatChainStageDto.class){

            @Override
            public void apply() {
                PlanDtoHibernateDao.this.createStageDtoBaseSelect((CriteriaQuery<FlatChainStageDto>)this.q, this.cb, (Root<? extends ChainStageImpl>)this.entity).where(new Predicate[]{this.cb.equal((Expression)this.entity.get(PlanDtoHibernateDao.CHAIN_PROPERTY_NAME).get(PlanDtoHibernateDao.ID_PROPERTY_NAME), (Object)id), this.cb.equal((Expression)this.entity.get(ChainStageImpl_.markedForDeletion), (Object)false)});
            }
        }.getResultList();
    }

    private CriteriaQuery<ChainBranchMetadataDto> createChainBranchMetadataBaseQuery(CriteriaQuery<ChainBranchMetadataDto> q, CriteriaBuilder cb, Root<? extends MutablePlanBranchMetadata> entity) {
        return q.select((Selection)cb.construct(ChainBranchMetadataDtoImpl.class, new Selection[]{entity.get(MutablePlanBranchMetadata_.chainBranch).get(ID_PROPERTY_NAME), entity.get(MutablePlanBranchMetadata_.branchName), entity.get(MutablePlanBranchMetadata_.branchDisplayName), entity.get(MutablePlanBranchMetadata_.vcsRepositoryId), entity.get(MutablePlanBranchMetadata_.markedInvalid)}));
    }

    public List<ChainBranchMetadataDto> getAllPlanBranchesMetadata() {
        log.info((Object)"Fetching all plan branches metadata.");
        return new JpaUtils.CriteriaQuery<MutablePlanBranchMetadata, ChainBranchMetadataDto>(this.getSessionFactory(), MutablePlanBranchMetadata.class, ChainBranchMetadataDto.class){

            @Override
            public void apply() {
                PlanDtoHibernateDao.this.createChainBranchMetadataBaseQuery((CriteriaQuery<ChainBranchMetadataDto>)this.q, this.cb, (Root<? extends MutablePlanBranchMetadata>)this.entity);
            }
        }.getResultList();
    }

    @Nullable
    public ChainBranchMetadataDto findChainBranchMetadataByChainBranchId(final long chainBranchId) {
        return (ChainBranchMetadataDto)new JpaUtils.CriteriaQuery<MutablePlanBranchMetadata, ChainBranchMetadataDto>(this.getSessionFactory(), MutablePlanBranchMetadata.class, ChainBranchMetadataDto.class){

            @Override
            public void apply() {
                PlanDtoHibernateDao.this.createChainBranchMetadataBaseQuery((CriteriaQuery<ChainBranchMetadataDto>)this.q, this.cb, (Root<? extends MutablePlanBranchMetadata>)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(MutablePlanBranchMetadata_.chainBranch).get(PlanDtoHibernateDao.ID_PROPERTY_NAME), (Object)chainBranchId));
            }
        }.uniqueResult();
    }
}

