/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.cluster.BambooClusterSettings;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectWithOidDao;
import com.atlassian.bamboo.plan.AbstractChain;
import com.atlassian.bamboo.plan.AbstractPlan;
import com.atlassian.bamboo.plan.AbstractPlan_;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanDiscriminatorRegistry;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanIdentifierImpl;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchIdentifier;
import com.atlassian.bamboo.plan.branch.ChainBranchImpl;
import com.atlassian.bamboo.plan.branch.ChainBranchImpl_;
import com.atlassian.bamboo.plan.branch.MutablePlanBranchMetadata;
import com.atlassian.bamboo.plan.branch.MutablePlanBranchMetadata_;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.DefaultProject;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectHibernateDao;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.util.BambooCollectionUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.versioning.PlanVersioningSupplement;
import com.atlassian.bamboo.versioning.VersionedEntityComponent;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Checked;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class PlanHibernateDao<T extends Plan>
extends BambooHibernateObjectWithOidDao<Plan>
implements PlanDao {
    private static final Logger log = LogManager.getLogger(PlanHibernateDao.class);
    private static final Set<BambooEntityType> ENTITY_TYPES = EnumSet.of(BambooEntityType.CHAIN, BambooEntityType.JOB, BambooEntityType.CHAIN_BRANCH, BambooEntityType.JOB_BRANCH);
    private PlanDiscriminatorRegistry planDiscriminatorRegistry;
    private final TransactionAndHibernateTemplate transactionTemplate;
    private final PlanVersioningSupplement versioningSupplement;

    public PlanHibernateDao(TransactionAndHibernateTemplate transactionTemplate, BambooClusterSettings bambooClusterSettings) {
        this.transactionTemplate = transactionTemplate;
        this.versioningSupplement = new PlanVersioningSupplement(bambooClusterSettings);
    }

    public <T extends Plan> T getPlanByKey(@NotNull PlanKey planKey, Class<T> aClass) {
        return this.getPlanByKey(planKey.getKey(), aClass);
    }

    public <T extends Plan> T getPlanByKey(final @NotNull String planKey, final Class<T> aClass) {
        Class<T> entityClass = this.toEntity(aClass);
        Plan execute = (Plan)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = PlanHibernateDao.this.createCriteria(session, aClass).setCacheable(false).setFetchMode("project", FetchMode.JOIN).setFetchMode("buildDefinitionXml", FetchMode.JOIN).setFetchMode("buildNumbers", FetchMode.JOIN).add((Criterion)Restrictions.eq((String)"planKey", (Object)planKey));
                return criteria.uniqueResult();
            }
        });
        return (T)execute;
    }

    private <T extends Plan> Class<T> toEntity(Class<T> aClass) {
        if (aClass.isAssignableFrom(DefaultJob.class)) {
            return DefaultJob.class;
        }
        return aClass;
    }

    @Nullable
    public PlanIdentifier getPlanIdentifierForPermissionCheckingByKey(final @NotNull String planKey) {
        return (PlanIdentifier)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                String queryKey = planKey;
                PlanKey key = PlanKeys.getPlanKey((String)planKey);
                PlanKey parentKey = PlanKeys.getChainKeyIfJobKey((PlanKey)key);
                if (parentKey != null) {
                    queryKey = parentKey.getKey();
                }
                Query namedQuery = session.getNamedQuery("getPlanIdentifierByPlanKey");
                namedQuery.setParameter("planKey", (Object)queryKey);
                namedQuery.setCacheable(true);
                Object[] result = (Object[])namedQuery.uniqueResult();
                if (result != null) {
                    long id = ((Number)result[0]).longValue();
                    String discriminator = (String)result[1];
                    String description = (String)result[2];
                    String buildName = (String)result[3];
                    String buildKey = (String)result[4];
                    Boolean suspendedFromBuilding = (Boolean)result[5];
                    long projectId = ((Number)result[6]).longValue();
                    String projectKey = (String)result[7];
                    String projectName = (String)result[8];
                    String projectDescription = (String)result[9];
                    long masterId = result[10] != null ? ((Number)result[9]).longValue() : -1L;
                    return new PlanIdentifierImpl(Long.valueOf(id), discriminator, key, description, buildName, buildKey, suspendedFromBuilding.booleanValue(), projectId, projectKey, projectName, projectDescription, Long.valueOf(masterId));
                }
                return null;
            }
        });
    }

    public Class<? extends Plan> getPlanClass(final @NotNull PlanKey planKey) {
        return (Class)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query namedQuery = session.getNamedQuery("getPlanDiscriminatorByPlanKey");
                namedQuery.setParameter("planKey", (Object)planKey.getKey());
                namedQuery.setParameter("markedForDeletion", (Object)false);
                namedQuery.setCacheable(true);
                String discriminator = (String)namedQuery.uniqueResult();
                if (discriminator != null) {
                    return PlanHibernateDao.this.planDiscriminatorRegistry.getTypeForDiscriminator(discriminator);
                }
                return null;
            }
        });
    }

    @Override
    public <E extends Plan> E findById(final long id, final @NotNull Class<E> aClass) {
        return (E)((Plan)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return PlanHibernateDao.this.createCriteria(session, aClass).setCacheable(false).add((Criterion)Restrictions.eq((String)"id", (Object)id)).uniqueResult();
            }
        }));
    }

    public boolean isChainNameConflicting(@NotNull String projectKey, long idOfChainBeingVerified, @NotNull String planName) {
        List<Chain> chainsAndBranches = this.getPlanByPartialKeyAndName(projectKey, planName, Chain.class);
        for (Chain chainOrBranch : chainsAndBranches) {
            boolean isBranchOfChainBeingVerified;
            boolean isSameChain = chainOrBranch.getId() == idOfChainBeingVerified;
            boolean hasNoMaster = !chainOrBranch.hasMaster();
            Chain master = chainOrBranch.getMaster();
            boolean bl = isBranchOfChainBeingVerified = master != null && master.getId() == idOfChainBeingVerified;
            if ((!hasNoMaster || isSameChain) && !isBranchOfChainBeingVerified) continue;
            return true;
        }
        return false;
    }

    public boolean isPlanKeyConflicting(@NotNull PlanKey planKey) {
        return this.isPlanKeyConflicting(planKey, -1L);
    }

    public boolean isPlanKeyConflicting(final @NotNull PlanKey planKey, final long idOfChainBeingVerified) {
        return (Boolean)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Boolean doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("isPlanKeyConflicting").setParameter("planKey", (Object)planKey.getKey()).setParameter("id", (Object)idOfChainBeingVerified).setCacheable(true).uniqueResult() != null;
            }
        });
    }

    @Nullable
    public <T extends Plan> T getPlanByPartialKeyAndName(@NotNull PlanKey partialPlanKey, @NotNull String planName, Class<T> planType) {
        return (T)((Plan)Iterables.getOnlyElement(this.getPlanByPartialKeyAndName(partialPlanKey.toString(), planName, planType), null));
    }

    <T extends Plan> List<T> getPlanByPartialKeyAndName(final String partialPlanKey, final String planName, final Class<T> planType) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public Object doInHibernate(Session session) throws HibernateException {
                return PlanHibernateDao.this.createCriteria(session, planType).add((Criterion)Restrictions.eq((String)"buildName", (Object)planName)).add((Criterion)Restrictions.like((String)"planKey", (Object)(partialPlanKey + "-%"))).list();
            }
        });
    }

    public <T extends Plan> int getPlanCount(final Class<T> planType) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                Set<String> discriminatorValues = PlanHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(planType);
                return (Number)session.getNamedQuery("countNumberOfPlans").setParameterList("buildTypes", discriminatorValues).setParameter("markedForDeletion", (Object)false).setCacheable(true).uniqueResult();
            }
        })).intValue();
    }

    public int getPlanCount(@NotNull ProjectIdentifier projectIdentifier) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute(session -> {
            Project project = (Project)session.get(ProjectHibernateDao.PERSISTENT_CLASS, (Serializable)Long.valueOf(projectIdentifier.getId()));
            return (Number)session.getNamedQuery("countNumberOfPlansInProject").setParameter("project", (Object)project).setParameter("markedForDeletion", (Object)false).setCacheable(true).uniqueResult();
        })).intValue();
    }

    @NotNull
    public <T extends Plan> List<PlanKey> getPlanKeys(final Class<T> planType) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Set<String> discriminatorValues = PlanHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(planType);
                Preconditions.checkArgument((!discriminatorValues.isEmpty() ? 1 : 0) != 0, (Object)("No discriminators found for " + planType.getName()));
                return session.getNamedQuery("getPlanKeys").setParameterList("buildTypes", discriminatorValues).setParameter("markedForDeletion", (Object)false).setCacheable(true).list();
            }
        });
    }

    @NotNull
    public <T extends Plan> List<PlanKey> getAllPlanKeys(Class<T> planType) {
        JpaUtils.CriteriaQuery<AbstractPlan, PlanKey> criteriaQuery = new JpaUtils.CriteriaQuery<AbstractPlan, PlanKey>(this.getSessionFactory(), planType, PlanKey.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity.get(AbstractPlan_.planKey));
            }
        };
        return criteriaQuery.getResultList();
    }

    @NotNull
    public List<PlanKey> getJobKeys(final @NotNull PlanKey chainKey) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("getJobKeys").setParameter("markedForDeletion", (Object)false).setParameter("chainKey", (Object)chainKey.getKey()).setCacheable(true).list();
            }
        });
    }

    @NotNull
    public <T extends Plan> List<T> findPlansByProject(@NotNull Project project, Class<T> planType) {
        return this.findPlansByProject(project, planType, false);
    }

    @NotNull
    public <T extends Plan> List<T> findAllPlansByProject(@NotNull Project project, Class<T> planType) {
        return this.findPlansByProject(project, planType, true);
    }

    private <T extends Plan> List<T> findPlansByProject(final Project project, final Class<T> planType, final boolean includeMarkedForDeletion) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = PlanHibernateDao.this.createCriteria(session, planType).setFetchMode("project", FetchMode.JOIN).setFetchMode("buildDefinitionXml", FetchMode.JOIN).add((Criterion)Restrictions.eq((String)"project", (Object)project)).setCacheable(true);
                if (!includeMarkedForDeletion) {
                    criteria.add((Criterion)Restrictions.eq((String)"markedForDeletion", (Object)Boolean.FALSE));
                }
                List plans = criteria.list();
                return BambooCollectionUtils.removeDuplicatesAndSort((List)plans, (Comparator)Comparators.getPlanNameProviderCaseInsensitiveOrdering());
            }
        });
    }

    @NotNull
    public <T extends Plan> List<T> findAllPlans(final Class<T> planType) {
        List result = (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                return PlanHibernateDao.this.createCriteria(session, planType).setFetchMode("project", FetchMode.JOIN).setFetchMode("buildDefinitionXml", FetchMode.JOIN).add((Criterion)Restrictions.eq((String)"markedForDeletion", (Object)Boolean.FALSE)).list();
            }
        });
        return BambooCollectionUtils.removeDuplicatesAndSort((List)result, (Comparator)Comparators.getPlanNameProviderCaseInsensitiveOrdering());
    }

    @NotNull
    public <T extends Plan> List<T> findAllPlans(final Class<T> planType, final int firstResult, final int maxResults) {
        List result = (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                return PlanHibernateDao.this.createCriteria(session, planType).setFetchMode("project", FetchMode.JOIN).setFetchMode("buildDefinitionXml", FetchMode.JOIN).add((Criterion)Restrictions.eq((String)"markedForDeletion", (Object)Boolean.FALSE)).setFirstResult(firstResult).setMaxResults(maxResults).addOrder(Order.asc((String)"id")).list();
            }
        });
        return BambooCollectionUtils.removeDuplicatesAndSort((List)result, (Comparator)Comparators.getPlanNameProviderCaseInsensitiveOrdering());
    }

    private <T extends Plan> Criteria createCriteria(@NotNull Session session, @NotNull Class<T> aClass) {
        return session.createCriteria(AbstractPlan.class).setCacheable(true).add(Restrictions.in((String)"discriminator", this.planDiscriminatorRegistry.getDiscriminatorsForType(aClass)));
    }

    private <T extends Plan> CriteriaQuery<T> createCriteriaJpa(@NotNull Session session, @NotNull Class<T> aClass, String planKey) {
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(aClass);
        Root root = q.from(aClass);
        root.fetch("project", JoinType.INNER);
        root.fetch("buildDefinitionXml", JoinType.LEFT);
        if (AbstractChain.class.isAssignableFrom(aClass)) {
            root.fetch("buildNumbers", JoinType.LEFT);
        }
        Predicate discriminatorMatches = root.get("discriminator").in(this.planDiscriminatorRegistry.getDiscriminatorsForType(aClass));
        q.select((Selection)root).where(new Predicate[]{discriminatorMatches, cb.equal((Expression)root.get("planKey"), (Object)planKey)});
        return q;
    }

    public void setPlanDiscriminatorRegistry(PlanDiscriminatorRegistry planDiscriminatorRegistry) {
        this.planDiscriminatorRegistry = planDiscriminatorRegistry;
    }

    public List<ImmutableChain> filterFavouritedPlans(@NotNull Collection<? extends ImmutableChain> plans, final @NotNull User user) {
        Set favourites = (Set)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query namedQuery = session.getNamedQuery("findPlanIdsForUserWithNamespace");
                namedQuery.setParameter("username", (Object)user.getName());
                namedQuery.setParameter("favourite", (Object)":favourite");
                return new HashSet(namedQuery.list());
            }
        });
        return plans.stream().filter(plan -> favourites.contains(plan.getId())).collect(Collectors.toList());
    }

    @NotNull
    public <T extends Plan> Collection<T> getAllPlansMarkedForDeletion(Class<T> planType) {
        return (Collection)this.getCacheAwareHibernateTemplate().execute(session -> this.createCriteria(session, planType).add((Criterion)Restrictions.eq((String)"markedForDeletion", (Object)true)).setCacheable(false).list());
    }

    public <T extends Plan> long getAllPlansMarkedForDeletionCount(final Class<T> planType) {
        return (Long)new JpaUtils.CriteriaQuery<AbstractPlan, Long>(this.getSessionFactory(), AbstractPlan.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where((Expression)this.cb.and((Expression)this.entity.get(AbstractPlan_.discriminator).in(PlanHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(planType)), (Expression)this.cb.equal((Expression)this.entity.get(AbstractPlan_.markedForDeletion), (Object)true)));
            }
        }.getSingleResult();
    }

    @Override
    public void save(@NotNull Plan plan) {
        BuildDefinitionForBuild buildDefinitionXml = plan.getBuildDefinitionXml();
        if (buildDefinitionXml != null) {
            String xmlData = buildDefinitionXml.getXmlData();
            log.debug("Saving: {}", (Object)xmlData);
            Preconditions.checkArgument((!buildDefinitionXml.isMerged() ? 1 : 0) != 0, (Object)"cannot save merged build definitions");
            Preconditions.checkState((xmlData == null || !xmlData.contains("isMergedConfiguration>true</isMergedConfiguration") ? 1 : 0) != 0, (Object)"mismatch between build definition and build definition XML");
        }
        super.save(plan);
        this.incrementVersion(plan);
    }

    private void incrementVersion(@NotNull Plan plan) {
        VersionedEntityComponent versionedEntityComponent = (VersionedEntityComponent)Narrow.downTo((Object)plan, VersionedEntityComponent.class);
        this.getCacheAwareHibernateTemplate().execute(session -> {
            Stream.of(plan, versionedEntityComponent != null ? (Plan)versionedEntityComponent.getRoot() : null).forEach(p -> this.versioningSupplement.incrementVersion((Plan)p, session));
            return null;
        });
    }

    @NotNull
    public List<ChainBranch> getBranchesForChain(final ImmutableChain chain) {
        List result = (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public List<ChainBranch> doInHibernate(Session session) throws HibernateException {
                return PlanHibernateDao.this.createCriteria(session, ChainBranchImpl.class).setFetchMode("project", FetchMode.JOIN).add((Criterion)Restrictions.eq((String)"markedForDeletion", (Object)Boolean.FALSE)).add((Criterion)Restrictions.eq((String)"master.id", (Object)chain.getId())).list();
            }
        });
        return BambooCollectionUtils.removeDuplicatesAndSort((List)result, (Comparator)Comparators.getPlanNameProviderCaseInsensitiveOrdering());
    }

    public Collection<Job> getBranchesForJob(final Job job) {
        Collection result = (Collection)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public List<Job> doInHibernate(Session session) throws HibernateException {
                return PlanHibernateDao.this.createCriteria(session, DefaultJob.class).add((Criterion)Restrictions.eq((String)"markedForDeletion", (Object)Boolean.FALSE)).add((Criterion)Restrictions.eq((String)"master.id", (Object)job.getId())).list();
            }
        });
        return result;
    }

    @NotNull
    public List<ChainBranchIdentifier> getBranchIdentifiersForChain(final @NotNull PlanIdentifier plan) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("getMinimalBranchesForChain").setParameter("planId", (Object)plan.getId()).setParameter("markedForDeletion", (Object)false).list();
            }
        });
    }

    @NotNull
    public <T extends Plan> List<PlanIdentifier> getPlanIdentifiersForProject(final @NotNull ProjectIdentifier project, final @NotNull Class<T> planType, final boolean includeMarkedForDeletion) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = includeMarkedForDeletion ? session.getNamedQuery("getPlanIdentifiersForProjectWithDeleted") : session.getNamedQuery("getPlanIdentifiersForProject").setParameter("markedForDeletion", (Object)false);
                query.setParameterList("buildTypes", PlanHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(planType)).setParameter("projectKey", (Object)project.getKey());
                return query.list();
            }
        });
    }

    public int getBranchCount(final @NotNull ImmutablePlan plan) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("getBranchesCountForChain").setParameter("planId", (Object)plan.getId()).setParameter("markedForDeletion", (Object)false).uniqueResult();
            }
        })).intValue();
    }

    public List<Pair<Number, Number>> getBranchesCount() {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("getBranchesCount").setParameter("markedForDeletion", (Object)false).setParameterList("buildTypes", PlanHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(ChainBranch.class)).list();
            }
        });
    }

    public void markPlanForDeletion(final PlanKey planKey) {
        this.transactionTemplate.doWork(connection -> {
            try (PreparedStatement statement = connection.prepareStatement("update BUILD set MARKED_FOR_DELETION = ?, VERSION = VERSION + 1 where FULL_KEY = ?");){
                statement.setBoolean(1, true);
                statement.setString(2, planKey.getKey());
                statement.executeUpdate();
            }
        });
        new JpaUtils.CriteriaVersionUpdater<AbstractPlan, Plan, Plan>(this.getSessionFactory(), AbstractPlan.class, Plan.class, (VersioningSupplement)this.versioningSupplement){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(AbstractPlan_.planKey), (Object)planKey));
            }
        }.incrementRootVersion();
    }

    public void syncDeletionStatusOfPlans() {
        new JpaUtils.CriteriaUpdate<AbstractPlan>(this.getSessionFactory(), AbstractPlan.class){

            @Override
            public void apply() {
                Subquery idSubQuery = this.update.subquery(Long.class);
                Root subRoot = idSubQuery.from(DefaultProject.class);
                idSubQuery.select((Expression)subRoot.get("id")).where((Expression)this.cb.equal((Expression)subRoot.get("markedForDeletion"), (Object)true));
                Path versionPath = this.entity.get("version");
                Expression incrementVersion = this.cb.sum((Number)1L, (Expression)versionPath);
                this.update.set(this.entity.get("markedForDeletion"), (Object)true).set(versionPath, incrementVersion).where(new Predicate[]{this.cb.equal((Expression)this.entity.get("markedForDeletion"), (Object)false), this.cb.in((Expression)this.entity.get("project").get("id")).value((Expression)idSubQuery)});
            }
        }.executeUpdate();
    }

    public void syncDeletionStatusOfJobs() {
        this.getCacheAwareHibernateTemplate().execute(session -> {
            Query query = session.getNamedQuery("findJobsWithIncorrectDeletionFlags").setParameter("aTrue", (Object)true).setParameter("aFalse", (Object)false);
            List jobKeys = query.list();
            if (!jobKeys.isEmpty()) {
                log.info(jobKeys.size() + " jobs have incorrectly set deletion flags, updating them");
                for (PlanKey jobKey : jobKeys) {
                    log.info("Job: " + jobKey + " being updated.");
                    this.markPlanForDeletion(jobKey);
                }
            }
            return null;
        });
    }

    public void syncDeletionStatusOfChainBranches() {
        this.getCacheAwareHibernateTemplate().execute(session -> {
            Query query = session.getNamedQuery("findChainBranchesWithIncorrectDeletionFlags").setParameter("aTrue", (Object)true).setParameter("aFalse", (Object)false);
            List chainBranchKeys = query.list();
            if (!chainBranchKeys.isEmpty()) {
                log.info(chainBranchKeys.size() + " chain branches have incorrectly set deletion flags, updating them");
                for (PlanKey chainBranchKey : chainBranchKeys) {
                    log.info("Chain Branch: " + chainBranchKey + " being updated.");
                    this.markPlanForDeletion(chainBranchKey);
                }
            }
            return null;
        });
    }

    @Nullable
    public BambooEntityOid getMaxPlanOid(int serverKey, @NotNull BambooEntityType entityType) {
        Preconditions.checkArgument((boolean)ENTITY_TYPES.contains(entityType), (String)"Entity type not allowed: %s", (Object)entityType);
        return (BambooEntityOid)this.getHibernateTemplate().execute(session -> (BambooEntityOid)session.createCriteria(AbstractPlan.class).add(Restrictions.between((String)"oid", (Object)BambooEntityOid.minOidOfType((int)serverKey, (BambooEntityType)entityType), (Object)BambooEntityOid.maxOidOfType((int)serverKey, (BambooEntityType)entityType))).setProjection((Projection)Projections.max((String)"oid")).uniqueResult());
    }

    @NotNull
    public Set<Long> getFavouritePlansIds(final @NotNull User user) {
        return (Set)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query namedQuery = session.getNamedQuery("findPlanIdsForUserWithNamespace");
                namedQuery.setParameter("username", (Object)user.getName());
                namedQuery.setParameter("favourite", (Object)":favourite");
                return new HashSet(namedQuery.list());
            }
        });
    }

    public <T extends Plan> Map<PlanKey, Long> getPlanKeysPlanIdsMapping(final @NotNull Class<T> aClass) {
        List result = new JpaUtils.CriteriaQuery<AbstractPlan, Tuple>(this.getSessionFactory(), AbstractPlan.class, Tuple.class){

            @Override
            public void apply() {
                this.q.multiselect(new Selection[]{this.entity.get(AbstractPlan_.planKey), this.entity.get(AbstractPlan_.id)}).where((Expression)this.entity.get(AbstractPlan_.discriminator).in(PlanHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(aClass)));
            }
        }.getResultList();
        return result.stream().collect(Collectors.toMap(tuple -> (PlanKey)tuple.get(0, PlanKey.class), tuple -> (Long)tuple.get(1, Long.class)));
    }

    public void clearInvalidFlagForBranchesOfChain(final long masterId) {
        new JpaUtils.CriteriaUpdate<MutablePlanBranchMetadata>(this.getSessionFactory(), MutablePlanBranchMetadata.class){

            @Override
            public void apply() {
                Subquery idSubQuery = this.update.subquery(Long.class);
                Root subRoot = idSubQuery.from(ChainBranchImpl.class);
                idSubQuery.select((Expression)subRoot.get("id")).where((Expression)this.cb.equal((Expression)subRoot.get("master").get("id"), (Object)masterId));
                this.update.set(this.entity.get(MutablePlanBranchMetadata_.markedInvalid), (Object)false).where((Expression)this.cb.in((Expression)this.entity.get("id")).value((Expression)idSubQuery));
            }
        }.executeUpdate();
        new JpaUtils.CriteriaUpdate<AbstractPlan>(this.getSessionFactory(), AbstractPlan.class){

            @Override
            public void apply() {
                Path versionPath = this.entity.get("version");
                Expression incrementVersion = this.cb.sum((Number)1L, (Expression)versionPath);
                this.update.set(versionPath, incrementVersion).where((Expression)this.cb.equal((Expression)this.entity.get("master").get("id"), (Object)masterId));
            }
        }.executeUpdate();
    }

    @NotNull
    public List<PlanKey> getBranchKeysForChain(final @NotNull PlanKey chainKey) {
        JpaUtils.CriteriaQuery<ChainBranchImpl, PlanKey> criteriaQuery = new JpaUtils.CriteriaQuery<ChainBranchImpl, PlanKey>(this.getSessionFactory(), ChainBranchImpl.class, PlanKey.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity.get(ChainBranchImpl_.planKey));
                this.q.where(new Predicate[]{this.cb.and(new Predicate[]{this.cb.equal((Expression)this.entity.get("master").get("planKey"), (Object)chainKey)}), this.cb.equal((Expression)this.entity.get(ChainBranchImpl_.markedForDeletion), (Object)false)});
            }
        };
        return criteriaQuery.getResultList();
    }

    @Override
    public void delete(@NotNull Plan plan) {
        if (plan instanceof Job) {
            Checked.now(() -> PlanKeys.getChainKeyFromJobKey((PlanKey)plan.getPlanKey())).forEach(chainKeyFromJobKey -> this.getCacheAwareHibernateTemplate().execute(session -> {
                this.versioningSupplement.incrementVersion((PlanKey)chainKeyFromJobKey, session);
                return null;
            }));
        }
        super.delete(plan);
    }
}

