/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

public class PlanResultKeyCompositeUserType
implements CompositeUserType,
Serializable {
    private static final Logger log = Logger.getLogger(PlanResultKeyCompositeUserType.class);

    public String[] getPropertyNames() {
        return new String[]{"planKey", "buildNumber"};
    }

    public Type[] getPropertyTypes() {
        return new Type[]{StandardBasicTypes.STRING, StandardBasicTypes.INTEGER};
    }

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        if (component == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)(component instanceof PlanResultKey), (Object)"component is not an instance of PlanResultKey");
        assert (component instanceof PlanResultKey);
        PlanResultKey planResultKey = (PlanResultKey)component;
        if (property == 0) {
            return planResultKey.getPlanKey().getKey();
        }
        return planResultKey.getBuildNumber();
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
    }

    public Class returnedClass() {
        return PlanResultKey.class;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String planKey = rs.getString(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        int buildNumber = rs.getInt(names[1]);
        if (rs.wasNull()) {
            return null;
        }
        return PlanKeys.getPlanResultKey((String)planKey, (int)buildNumber);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
            st.setNull(index + 1, 4);
        } else {
            Preconditions.checkArgument((boolean)(value instanceof PlanResultKey), (Object)"value is not an instance of PlanResultKey");
            assert (value instanceof PlanResultKey);
            PlanResultKey planResultKey = (PlanResultKey)value;
            st.setString(index, planResultKey.getPlanKey().getKey());
            st.setInt(index + 1, planResultKey.getBuildNumber());
        }
    }

    public Serializable disassemble(Object value, SharedSessionContractImplementor session) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return cached;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return Objects.equal((Object)x, (Object)y);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return original;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }
}

