/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.cluster.BambooClusterSettings;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.deployments.projects.persistence.DeploymentProjectDao;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateVersionAwareObjectDao;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionDao;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl_;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.versioning.PlanVersioningSupplement;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ArtifactDefinitionHibernateDao
extends BambooHibernateVersionAwareObjectDao<ArtifactDefinition, Plan>
implements ArtifactDefinitionDao {
    private static final Logger log = Logger.getLogger(ArtifactDefinitionHibernateDao.class);
    private static final Class<? extends ArtifactDefinition> PERSISTENT_CLASS = ArtifactDefinitionImpl.class;
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PRODUCER_JOB = "producerJob";
    private static final String PRODUCER_JOB_ID = "producerJob.id";
    private static final String SHARED_ARTIFACT = "sharedArtifact";
    private static final String CHAIN_ID = "chainId";
    @Lazy
    @Inject
    private DbmsBean dbmsBean;
    @Lazy
    @Inject
    DeploymentProjectDao deploymentProjectDao;
    private final VersioningSupplement<Plan> versioningSupplement;

    @Inject
    public ArtifactDefinitionHibernateDao(@NotNull BambooClusterSettings bambooClusterSettings) {
        this.versioningSupplement = new PlanVersioningSupplement(bambooClusterSettings);
    }

    @Override
    @NotNull
    protected Optional<VersioningSupplement<Plan>> getRootVersioningSupplement() {
        return Optional.of(this.versioningSupplement);
    }

    @Nullable
    public ArtifactDefinition findById(long id) {
        return super.findById(id, PERSISTENT_CLASS);
    }

    @Nullable
    public ArtifactDefinition findByName(final @NotNull ImmutablePlan plan, final @NotNull String name) {
        return (ArtifactDefinition)new JpaUtils.CriteriaQuery<ArtifactDefinitionImpl, ArtifactDefinition>(this.getSessionFactory(), ArtifactDefinitionImpl.class, ArtifactDefinition.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where(new Predicate[]{this.cb.equal((Expression)this.entity.get(ArtifactDefinitionHibernateDao.PRODUCER_JOB).get(ArtifactDefinitionHibernateDao.ID), (Object)plan.getId()), this.cb.equal((Expression)this.entity.get(ArtifactDefinitionHibernateDao.NAME), (Object)name)});
            }
        }.uniqueResult();
    }

    @Nullable
    public ArtifactDefinition findByNameInChain(final @NotNull ImmutableChain chain, final @NotNull String name) {
        return (ArtifactDefinition)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<ArtifactDefinition>(){

            public ArtifactDefinition doInHibernate(Session session) throws HibernateException {
                return (ArtifactDefinition)session.getNamedQuery("findArtifactDefinitionByNameInChain").setParameter(ArtifactDefinitionHibernateDao.NAME, (Object)name).setParameter(ArtifactDefinitionHibernateDao.SHARED_ARTIFACT, (Object)true).setParameter(ArtifactDefinitionHibernateDao.CHAIN_ID, (Object)chain.getId()).uniqueResult();
            }
        });
    }

    @NotNull
    public List<ArtifactDefinition> findSharedArtifactsByChain(final @NotNull ImmutableChain chain) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ArtifactDefinition>>(){

            public List<ArtifactDefinition> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findArtifactDefinitionByChain").setParameter(ArtifactDefinitionHibernateDao.SHARED_ARTIFACT, (Object)true).setParameter(ArtifactDefinitionHibernateDao.CHAIN_ID, (Object)chain.getId()).list();
            }
        });
    }

    @NotNull
    public Collection<? extends ArtifactDefinition> findAll() {
        return new JpaUtils.CriteriaQuery<ArtifactDefinitionImpl, ArtifactDefinition>(this.getSessionFactory(), ArtifactDefinitionImpl.class, ArtifactDefinition.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity);
            }
        }.getResultList();
    }

    @NotNull
    public Collection<? extends ArtifactDefinition> findAll(int firstResult, int maxResults) {
        return new JpaUtils.CriteriaQuery<ArtifactDefinitionImpl, ArtifactDefinition>(this.getSessionFactory(), ArtifactDefinitionImpl.class, ArtifactDefinition.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity);
            }
        }.getResultList(firstResult, maxResults);
    }

    @NotNull
    public List<ArtifactDefinition> findByProducer(final @NotNull ImmutablePlan plan) {
        if (!plan.getDatabaseId().isPresent()) {
            return Collections.emptyList();
        }
        return new JpaUtils.CriteriaQuery<ArtifactDefinitionImpl, ArtifactDefinition>(this.getSessionFactory(), ArtifactDefinitionImpl.class, ArtifactDefinition.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(ArtifactDefinitionHibernateDao.PRODUCER_JOB).get(ArtifactDefinitionHibernateDao.ID), (Object)plan.getId()));
            }
        }.getResultList();
    }

    @Override
    public void delete(@NotNull ArtifactDefinition artifactDefinition) {
        super.delete(artifactDefinition);
    }

    @Override
    public <E extends ArtifactDefinition> void deleteAll(@NotNull Collection<E> artifactDefinitions) {
        super.deleteAll(artifactDefinitions);
    }

    public void removeByProducer(@NotNull ImmutablePlan plan) {
        List<ArtifactDefinition> producedArtifacts = this.findByProducer(plan);
        Set ids = producedArtifacts.stream().map(ImmutableArtifactDefinitionBase::getId).collect(Collectors.toSet());
        new JpaUtils.PartitionedCriteriaDelete<ArtifactDefinitionImpl, Long>(this.dbmsBean, this.getSessionFactory(), ArtifactDefinitionImpl.class){

            @Override
            public void apply(List<Long> partition) {
                this.delete.where((Expression)this.entity.get(ArtifactDefinitionImpl_.id).in(partition));
            }
        }.executeUpdates(ids);
    }

    @NotNull
    public BambooEntityOid getMaxArtifactDefinitionOid(int serverKey) {
        return (BambooEntityOid)this.getHibernateTemplate().execute(session -> (BambooEntityOid)session.createCriteria(PERSISTENT_CLASS).add(Restrictions.between((String)"oid", (Object)BambooEntityOid.minOidOfType((int)serverKey, (BambooEntityType)BambooEntityType.ARTIFACT_DEFINITION), (Object)BambooEntityOid.maxOidOfType((int)serverKey, (BambooEntityType)BambooEntityType.ARTIFACT_DEFINITION))).setProjection((Projection)Projections.max((String)"oid")).uniqueResult());
    }
}

