/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionDao;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionImpl_;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.jetbrains.annotations.NotNull;

public class ArtifactSubscriptionHibernateDao
extends BambooHibernateObjectDao<ArtifactSubscription>
implements ArtifactSubscriptionDao {
    private static final Class<? extends ArtifactSubscription> PERSISTENT_CLASS = ArtifactSubscriptionImpl.class;

    @NotNull
    public Collection<? extends ArtifactSubscription> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    @NotNull
    public List<ArtifactSubscription> findArtifactSubscriptionOfPlan(final @NotNull PlanIdentifier plan) {
        if (!plan.getDatabaseId().isPresent()) {
            return Collections.emptyList();
        }
        return new JpaUtils.CriteriaQuery<ArtifactSubscriptionImpl, ArtifactSubscription>(this.getSessionFactory(), ArtifactSubscriptionImpl.class, ArtifactSubscription.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get("consumerJob").get("id"), (Object)plan.getId()));
            }
        }.getResultList();
    }

    public void removeArtifactSubscriptions(@NotNull Collection<ArtifactSubscription> artifactSubscriptions) {
        for (ArtifactSubscription artifactSubscription : artifactSubscriptions) {
            artifactSubscription.getArtifactDefinition().getSubscriptions().remove(artifactSubscription);
        }
        this.deleteAll(artifactSubscriptions);
    }

    public void removeArtifactSubscriptionsOfPlan(final @NotNull PlanIdentifier planIdentifier) {
        if (!planIdentifier.getDatabaseId().isPresent()) {
            return;
        }
        new JpaUtils.CriteriaDelete<ArtifactSubscriptionImpl>(this.getSessionFactory(), ArtifactSubscriptionImpl.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get("consumerJob").get("id"), (Object)planIdentifier.getId()));
            }
        }.executeUpdate();
    }

    public long countSubscriptionsOfArtifact(final long artifactDefinitionId) {
        return (Long)new JpaUtils.CriteriaQuery<ArtifactSubscriptionImpl, Long>(this.getSessionFactory(), ArtifactSubscriptionImpl.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where((Expression)this.cb.equal((Expression)this.entity.get(ArtifactSubscriptionImpl_.artifactDefinition).get("id"), (Object)artifactDefinitionId));
            }
        }.getSingleResult();
    }
}

