/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.DefaultArtifactLink;
import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscription;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscriptionDao;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscriptionImpl;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ConsumedSubscriptionHibernateDao
extends BambooHibernateObjectDao<ConsumedSubscription>
implements ConsumedSubscriptionDao {
    private static final Class<? extends ConsumedSubscription> PERSISTENT_CLASS = ConsumedSubscriptionImpl.class;
    private static final String CONSUMER_RESULT_SUMMARY = "consumerResultSummary";

    @NotNull
    public Collection<? extends ConsumedSubscription> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    @NotNull
    public List<ConsumedSubscription> findConsumedSubscriptionsByResultSummary(final @NotNull ResultsSummary resultsSummary) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ConsumedSubscription>>(){

            public List<ConsumedSubscription> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)ConsumedSubscriptionHibernateDao.CONSUMER_RESULT_SUMMARY, (Object)resultsSummary)).list();
            }
        });
    }

    public long scrollConsumedSubscriptionsForExport(final @NotNull Consumer<ConsumedSubscription> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("consumedSubscriptionsForExport");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                long subscriptionId = data.getLong(0);
                String subscriptionDestinationDirectory = data.getString(1);
                long artifactLinkId = data.getLong(2);
                PlanKey crsPlanKey = (PlanKey)data.get(3);
                int crsBuildNumber = data.getInteger(4);
                ConsumedSubscriptionImpl consumedSubscription = new ConsumedSubscriptionImpl();
                consumedSubscription.setId(subscriptionId);
                consumedSubscription.setDestinationDirectory(subscriptionDestinationDirectory);
                DefaultArtifactLink artifactLink = (DefaultArtifactLink)BambooHibernateUtils.createObjectWithId(DefaultArtifactLink.class, (long)artifactLinkId);
                consumedSubscription.setArtifactLink((ArtifactLink)artifactLink);
                BuildResultsSummaryImpl consumerResultsSummary = new BuildResultsSummaryImpl();
                consumerResultsSummary.setPlanKey(crsPlanKey);
                consumerResultsSummary.setBuildNumber(crsBuildNumber);
                consumedSubscription.setConsumerResultSummary((ResultsSummary)consumerResultsSummary);
                consumer.accept(consumedSubscription);
            }
        });
    }
}

