/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.branch.BambooVcsBranch;
import com.atlassian.bamboo.plan.branch.BambooVcsBranchImpl;
import com.atlassian.bamboo.plan.branch.VcsBranchDao;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsBranchHibernateDao
extends BambooHibernateObjectDao<BambooVcsBranch>
implements VcsBranchDao {
    public List<BambooVcsBranch> findByChain(@NotNull ImmutableChain chain) {
        return this.findByAnyChain(chain);
    }

    private List<BambooVcsBranch> findByAnyChain(ImmutableChain chain) {
        List<BambooVcsBranch> vcsBranches = this.findByChainId(chain.getId());
        for (BambooVcsBranch vcsBranch : vcsBranches) {
            vcsBranch.setChain(this.asMutableChain(chain));
        }
        return vcsBranches;
    }

    private Chain asMutableChain(ImmutableChain chain) {
        Chain mutableChain = chain instanceof Chain ? (Chain)chain : new DefaultChain();
        mutableChain.setId(chain.getId());
        return mutableChain;
    }

    public List<BambooVcsBranch> findByChainId(long chainId) {
        List result = this.getHibernateTemplate().findByNamedQueryAndNamedParam("findVcsBranchesForChain", "chainId", (Object)chainId);
        return result;
    }

    @Nullable
    public BambooVcsBranch findByChainAndName(long chainId, @NotNull String branchName) {
        return (BambooVcsBranch)this.getHibernateTemplate().execute(session -> (BambooVcsBranch)session.createCriteria(BambooVcsBranchImpl.class).add((Criterion)Restrictions.eq((String)"chain.id", (Object)chainId)).add((Criterion)Restrictions.eq((String)"name", (Object)branchName)).uniqueResult());
    }

    @NotNull
    public List<BambooVcsBranch> findWithDetectedDeletionDate() {
        List result = this.getHibernateTemplate().findByNamedQuery("findWithDetectedDeletionDate", new Object[0]);
        return result;
    }

    public List<BambooVcsBranch> findNotDeletedByChain(@NotNull ImmutableChain chain) {
        List result = this.getHibernateTemplate().findByNamedQueryAndNamedParam("findVcsBranchesNotDeletedByChain", "chainId", (Object)chain.getId());
        return result;
    }

    public void deleteAll(ImmutableChain chain) {
        this.deleteAll(this.findByAnyChain(chain));
    }
}

