/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.pullrequest;

import com.atlassian.bamboo.persistence.BambooSessionFactoryUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.pullrequest.MutableVcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestDao;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestImpl;
import com.atlassian.bamboo.utils.collection.PartialList;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class VcsPullRequestHibernateDao
extends BambooHibernateObjectDao<MutableVcsPullRequest>
implements VcsPullRequestDao {
    private static final Class<? extends MutableVcsPullRequest> PERSISTENT_CLASS = VcsPullRequestImpl.class;
    @VisibleForTesting
    static final int MAX_SCROLL_RESULTS = 1000;
    @VisibleForTesting
    static final int SESSION_FLUSH_THRESHOLD = 20;
    @Lazy
    @Autowired
    private DbmsBean dbmsBean;

    public Collection<? extends MutableVcsPullRequest> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    @Nullable
    public MutableVcsPullRequest findByRepositoryAndKey(long repositoryId, @NotNull String pullRequestKey) {
        return (MutableVcsPullRequest)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"targetRepositoryId", (Object)repositoryId)).add((Criterion)Restrictions.eq((String)"key", (Object)pullRequestKey));
            BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)this.getSessionFactory());
            return (MutableVcsPullRequest)criteria.uniqueResult();
        });
    }

    @NotNull
    public List<MutableVcsPullRequest> findByRepository(long repositoryId, boolean isOpen) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"targetRepositoryId", (Object)repositoryId)).add((Criterion)Restrictions.eq((String)"open", (Object)isOpen));
            BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)this.getSessionFactory());
            return criteria.list();
        });
    }

    @NotNull
    public PartialList<MutableVcsPullRequest> closePullRequestsClosedInRepository(long targetRepositoryId, @NotNull Set<String> openPrKeys) {
        if (openPrKeys.size() < 1000) {
            return this.closePullRequestsWithinLimits(targetRepositoryId, openPrKeys);
        }
        return this.closePullRequestsWithLimits(targetRepositoryId, openPrKeys);
    }

    @Nullable
    public MutableVcsPullRequest findById(long id) {
        return this.findById(id, PERSISTENT_CLASS);
    }

    @NotNull
    public List<MutableVcsPullRequest> findByStatus(boolean isOpen, long startId, int maxLimit) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"open", (Object)isOpen)).add((Criterion)Restrictions.gt((String)"id", (Object)startId)).addOrder(Order.asc((String)"id")).setMaxResults(maxLimit);
            BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)this.getSessionFactory());
            return criteria.list();
        });
    }

    public int removeOrphanedPullRequests() {
        return (Integer)this.getCacheAwareHibernateTemplate().execute(session -> {
            Query query = this.dbmsBean.isMySql() ? session.getNamedQuery("removeOrphanedPullRequestsMySQL") : session.getNamedQuery("removeOrphanedPullRequests");
            return query.executeUpdate();
        });
    }

    @NotNull
    @VisibleForTesting
    PartialList<MutableVcsPullRequest> closePullRequestsWithinLimits(long targetRepositoryId, @NotNull Set<String> openPrKeys) {
        return (PartialList)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria openByTargetRepositoryCriteria = this.getOpenByTargetRepositoryCriteria(session, targetRepositoryId);
            if (!openPrKeys.isEmpty()) {
                openByTargetRepositoryCriteria = openByTargetRepositoryCriteria.add(Restrictions.not((Criterion)Restrictions.in((String)"key", (Collection)openPrKeys)));
            }
            try (ScrollableResults pullRequests = openByTargetRepositoryCriteria.scroll(ScrollMode.FORWARD_ONLY);){
                ArrayList<VcsPullRequestImpl> result = new ArrayList<VcsPullRequestImpl>();
                while (result.size() < 1000 && pullRequests.next()) {
                    VcsPullRequestImpl pullRequest = (VcsPullRequestImpl)pullRequests.get(0);
                    pullRequest.setOpen(false);
                    result.add(pullRequest);
                    if (result.size() % 20 != 0) continue;
                    session.flush();
                    session.clear();
                }
                if (!result.isEmpty() && result.size() % 20 != 0) {
                    session.flush();
                    session.clear();
                }
                PartialList partialList = pullRequests.next() ? PartialList.ofUnknownSize(result) : PartialList.ofKnownSize(result, (int)result.size());
                return partialList;
            }
        });
    }

    @NotNull
    @VisibleForTesting
    PartialList<MutableVcsPullRequest> closePullRequestsWithLimits(long targetRepositoryId, @NotNull Set<String> openPrKeys) {
        return (PartialList)this.getCacheAwareHibernateTemplate().execute(session -> {
            try (ScrollableResults pullRequests = this.getOpenByTargetRepositoryCriteria(session, targetRepositoryId).scroll(ScrollMode.FORWARD_ONLY);){
                ArrayList<VcsPullRequestImpl> result = new ArrayList<VcsPullRequestImpl>();
                while (result.size() < 1000 && pullRequests.next()) {
                    VcsPullRequestImpl pullRequest = (VcsPullRequestImpl)pullRequests.get(0);
                    if (openPrKeys.contains(pullRequest.getKey())) continue;
                    pullRequest.setOpen(false);
                    result.add(pullRequest);
                    if (result.size() % 20 != 0) continue;
                    session.flush();
                    session.clear();
                }
                if (!result.isEmpty() && result.size() % 20 != 0) {
                    session.flush();
                    session.clear();
                }
                PartialList partialList = pullRequests.next() ? PartialList.ofUnknownSize(result) : PartialList.ofKnownSize(result, (int)result.size());
                return partialList;
            }
        });
    }

    @VisibleForTesting
    Criteria getOpenByTargetRepositoryCriteria(@NotNull Session session, long targetRepositoryId) {
        return session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"targetRepositoryId", (Object)targetRepositoryId)).add((Criterion)Restrictions.eq((String)"open", (Object)true)).setCacheMode(CacheMode.IGNORE);
    }
}

