/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.vcsRevision;

import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeyUserType;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryDao;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryItem;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryItem_;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class PlanVcsRevisionHistoryHibernateDao
implements PlanVcsRevisionHistoryDao {
    private static final Class<PlanVcsRevisionHistoryItem> PERSISTENT_CLASS = PlanVcsRevisionHistoryItem.class;
    private static final String FIELD_PLAN_KEY = "planKey";
    private static final String FIELD_BUILD_NUMBER = "buildNumber";
    private static final String FIELD_REPOSITORY_ID = "repositoryId";
    @Autowired
    private SessionFactory sessionFactory;

    public PlanVcsRevisionHistoryItem findVcsRevisionHistoryItem(@NotNull PlanKey planKey, long repositoryId, int buildNumber) {
        Session session = this.sessionFactory.getCurrentSession();
        return (PlanVcsRevisionHistoryItem)session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)FIELD_PLAN_KEY, (Object)planKey)).add((Criterion)Restrictions.eq((String)FIELD_REPOSITORY_ID, (Object)repositoryId)).add((Criterion)Restrictions.eq((String)FIELD_BUILD_NUMBER, (Object)buildNumber)).uniqueResult();
    }

    @NotNull
    public List<PlanVcsRevisionHistoryItem> findLatestVcsRevisionHistoryItems(@NotNull PlanKey planKey) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Integer.class);
        Root entity = q.from(PERSISTENT_CLASS);
        q.select((Selection)entity.get(PlanVcsRevisionHistoryItem_.buildNumber)).where((Expression)cb.equal((Expression)entity.get(PlanVcsRevisionHistoryItem_.planKey), (Object)planKey)).orderBy(new Order[]{cb.desc((Expression)entity.get(PlanVcsRevisionHistoryItem_.buildNumber))});
        Integer maxBuildNumber = (Integer)session.createQuery(q).setMaxResults(1).uniqueResult();
        return this.getItemsWithBuildNumber(session, planKey, maxBuildNumber);
    }

    @NotNull
    public List<PlanVcsRevisionHistoryItem> findLatestVcsRevisionHistoryItemsBeforeBuildNumber(@NotNull PlanKey planKey, int buildNumber) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Integer.class);
        Root entity = q.from(PERSISTENT_CLASS);
        q.select((Selection)entity.get(PlanVcsRevisionHistoryItem_.buildNumber)).where(new Predicate[]{cb.equal((Expression)entity.get(PlanVcsRevisionHistoryItem_.planKey), (Object)planKey), cb.lt((Expression)entity.get(PlanVcsRevisionHistoryItem_.buildNumber), (Number)buildNumber)}).orderBy(new Order[]{cb.desc((Expression)entity.get(PlanVcsRevisionHistoryItem_.buildNumber))});
        Integer maxBuildNumber = (Integer)session.createQuery(q).setMaxResults(1).uniqueResult();
        return this.getItemsWithBuildNumber(session, planKey, maxBuildNumber);
    }

    private List<PlanVcsRevisionHistoryItem> getItemsWithBuildNumber(Session session, @NotNull PlanKey planKey, @Nullable Integer buildNumber) {
        if (buildNumber == null) {
            return Collections.emptyList();
        }
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(PlanVcsRevisionHistoryItem.class);
        Root entity = q.from(PERSISTENT_CLASS);
        q.select((Selection)entity).where(new Predicate[]{cb.equal((Expression)entity.get(PlanVcsRevisionHistoryItem_.planKey), (Object)planKey), cb.equal((Expression)entity.get(PlanVcsRevisionHistoryItem_.buildNumber), (Object)buildNumber)});
        return session.createQuery(q).getResultList();
    }

    public void createOrUpdateChangeDetectionHistoryItem(@NotNull PlanVcsRevisionHistoryItem planVcsRevisionHistoryItem) {
        PlanVcsRevisionHistoryItem existingEvent = this.findVcsRevisionHistoryItem(planVcsRevisionHistoryItem.getPlanKey(), planVcsRevisionHistoryItem.getRepositoryId(), planVcsRevisionHistoryItem.getBuildNumber());
        Session session = this.sessionFactory.getCurrentSession();
        if (existingEvent != null) {
            existingEvent.setVcsRevisionKey(planVcsRevisionHistoryItem.getVcsRevisionKey());
            existingEvent.setCustomXmlData(planVcsRevisionHistoryItem.getCustomXmlData());
            HibernateDaoUtils.saveOrUpdate(session, (BambooObject)existingEvent);
        } else {
            HibernateDaoUtils.saveOrUpdate(session, (BambooObject)planVcsRevisionHistoryItem);
        }
    }

    public void moveRevisionHistoryForPlan(@NotNull PlanKey oldPlanKey, @NotNull PlanKey newPlanKey) {
        Session session = this.sessionFactory.getCurrentSession();
        List allPlanHistory = session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)FIELD_PLAN_KEY, (Object)oldPlanKey)).list();
        for (PlanVcsRevisionHistoryItem historyItem : allPlanHistory) {
            historyItem.setPlanKey(newPlanKey);
        }
        HibernateDaoUtils.saveOrUpdateAll(session, allPlanHistory);
    }

    public void createChangeDetectionHistoryItem(@NotNull PlanVcsRevisionHistoryItem planVcsRevisionHistoryItem) {
        Session session = this.sessionFactory.getCurrentSession();
        HibernateDaoUtils.saveOrUpdate(session, (BambooObject)planVcsRevisionHistoryItem);
    }

    public void deleteVcsRevisionHistoryForPlan(@NotNull PlanKey planKey) {
        Session session = this.sessionFactory.getCurrentSession();
        List entities = session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)FIELD_PLAN_KEY, (Object)planKey)).list();
        HibernateDaoUtils.deleteAll(session, entities);
    }

    public void cleanupUnusedEntriesForPlan(@NotNull PlanKey planKey) {
        Session session = this.sessionFactory.getCurrentSession();
        Number lowestBuildNumberOfActiveBuild = (Number)session.getNamedQuery("selectLowestBuildNumberInLifeCycleState").setParameter(FIELD_PLAN_KEY, (Object)planKey, PlanKeyUserType.getHibernateType(session)).setParameterList("lifeCycleStates", LifeCycleState.lifeCycleStatesToStringCollection((Collection)LifeCycleState.ACTIVE_STATES)).uniqueResult();
        List<PlanVcsRevisionHistoryItem> items = lowestBuildNumberOfActiveBuild == null ? this.findLatestVcsRevisionHistoryItems(planKey) : this.findLatestVcsRevisionHistoryItemsBeforeBuildNumber(planKey, lowestBuildNumberOfActiveBuild.intValue());
        for (PlanVcsRevisionHistoryItem item : items) {
            int dummy = item.getBuildNumber();
            long repositoryId = item.getRepositoryId();
            HibernateDaoUtils.deleteAll(session, session.getNamedQuery("selectItemsWithLowerBuildNumber").setParameter(FIELD_PLAN_KEY, (Object)planKey, PlanKeyUserType.getHibernateType(session)).setParameter(FIELD_REPOSITORY_ID, (Object)repositoryId).setParameter(FIELD_BUILD_NUMBER, (Object)dummy).list());
        }
    }
}

