/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.chains.DefaultChain_;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectWithOidDao;
import com.atlassian.bamboo.project.DefaultProject;
import com.atlassian.bamboo.project.DefaultProject_;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectDao;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ProjectHibernateDao
extends BambooHibernateObjectWithOidDao<Project>
implements ProjectDao {
    private static final Logger log = Logger.getLogger(ProjectHibernateDao.class);
    public static final Class<? extends Project> PERSISTENT_CLASS = DefaultProject.class;
    private static final BambooEntityType ENTITY_TYPE = BambooEntityType.PROJECT;

    @Nullable
    public Project findById(long id) {
        return this.findById(id, PERSISTENT_CLASS);
    }

    @NotNull
    public Collection<? extends Project> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    @NotNull
    public Collection<? extends Project> findAll(int firstResult, int maxResults) {
        return (Collection)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).setFirstResult(firstResult).setMaxResults(maxResults).addOrder(org.hibernate.criterion.Order.asc((String)"id")).list());
    }

    @NotNull
    public List<Long> findAllProjectsIds() {
        return this.findAllProjectIdsQuery().getResultList();
    }

    @NotNull
    public List<Long> findAllProjectsIds(int startIndex, int maxResults) {
        return this.findAllProjectIdsQuery().getResultList(startIndex, maxResults);
    }

    @NotNull
    public Number count() {
        return this.countAll(PERSISTENT_CLASS);
    }

    @NotNull
    public Number countNonDeleted() {
        return this.countWithRestriction(PERSISTENT_CLASS, (Criterion)Restrictions.eq((String)"markedForDeletion", (Object)Boolean.FALSE));
    }

    @Override
    public void delete(final @NotNull Project project) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Project newProject = (Project)session.get(PERSISTENT_CLASS, (Serializable)Long.valueOf(project.getId()));
                Query namedQuery = session.getNamedQuery("countNumberOfPlansInProject").setParameter("project", (Object)newProject).setParameter("markedForDeletion", (Object)false);
                Preconditions.checkArgument((((Number)namedQuery.uniqueResult()).intValue() == 0 ? 1 : 0) != 0, (String)"Project %s (%s) contains plans. Delete the plans first.", (Object)project.getName(), (Object)project.getKey());
                session.delete((Object)newProject);
                return null;
            }
        });
    }

    public boolean isExistingProjectName(final @NotNull String projectName) {
        List existingProjects = (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Project>>(){

            public List<Project> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"name", (Object)projectName).ignoreCase()).list();
            }
        });
        return !existingProjects.isEmpty();
    }

    public boolean isExistingProjectKey(final @NotNull String projectKey) {
        List existingProjects = (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Project>>(){

            public List<Project> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"key", (Object)projectKey).ignoreCase()).list();
            }
        });
        return !existingProjects.isEmpty();
    }

    public Project getProjectByKey(final @NotNull String key) {
        return (Project)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Project>(){

            public Project doInHibernate(Session session) throws HibernateException {
                try {
                    return (Project)session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"key", (Object)key)).uniqueResult();
                }
                catch (HibernateException e) {
                    log.warn((Object)("Unable to get project with key " + key), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    public Project getProjectByName(final @NotNull String projectName) {
        return (Project)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Project>(){

            public Project doInHibernate(Session session) throws HibernateException {
                return (Project)session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"name", (Object)projectName).ignoreCase()).setMaxResults(1).uniqueResult();
            }
        });
    }

    @NotNull
    public List<Project> getNonEmptyProjects() {
        SessionFactory sessionFactory = this.getCacheAwareHibernateTemplate().getSessionFactory();
        return new JpaUtils.CriteriaQuery<DefaultProject, Project>(sessionFactory, DefaultProject.class, Project.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where(new Predicate[]{this.cb.equal((Expression)this.entity.get(DefaultProject_.markedForDeletion), (Object)Boolean.FALSE), this.cb.exists(ProjectHibernateDao.this.plansInProjectSubquery(this.cb, (CriteriaQuery<Project>)this.q, (Root<? extends DefaultProject>)this.entity))});
            }
        }.getResultList();
    }

    @NotNull
    public List<Project> getEmptyProjects() {
        SessionFactory sessionFactory = this.getCacheAwareHibernateTemplate().getSessionFactory();
        return new JpaUtils.CriteriaQuery<DefaultProject, Project>(sessionFactory, DefaultProject.class, Project.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where(new Predicate[]{this.cb.equal((Expression)this.entity.get(DefaultProject_.markedForDeletion), (Object)Boolean.FALSE), this.cb.not((Expression)this.cb.exists(ProjectHibernateDao.this.plansInProjectSubquery(this.cb, (CriteriaQuery<Project>)this.q, (Root<? extends DefaultProject>)this.entity)))});
            }
        }.getResultList();
    }

    @NotNull
    public List<Project> getAllProjectsMarkedForDeletion() {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Project>>(){

            public List<Project> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"markedForDeletion", (Object)Boolean.TRUE)).setFetchMode("plans", FetchMode.JOIN).list();
            }
        });
    }

    @NotNull
    private Subquery<DefaultChain> plansInProjectSubquery(@NotNull CriteriaBuilder cb, @NotNull CriteriaQuery<Project> q, @NotNull Root<? extends DefaultProject> entity) {
        Subquery subQuery = q.subquery(DefaultChain.class);
        Root subEntity = subQuery.from(DefaultChain.class);
        subQuery.select((Expression)subEntity).where(new Predicate[]{cb.equal((Expression)subEntity.get(DefaultChain_.markedForDeletion), (Object)Boolean.FALSE), cb.equal((Expression)subEntity.get(DefaultChain_.project), (Expression)entity.get(DefaultProject_.id))});
        return subQuery;
    }

    @Nullable
    public BambooEntityOid getMaxProjectOid(int serverKey) {
        return (BambooEntityOid)this.getHibernateTemplate().execute(session -> (BambooEntityOid)session.createCriteria(PERSISTENT_CLASS).add(Restrictions.between((String)"oid", (Object)BambooEntityOid.minOidOfType((int)serverKey, (BambooEntityType)ENTITY_TYPE), (Object)BambooEntityOid.maxOidOfType((int)serverKey, (BambooEntityType)ENTITY_TYPE))).setProjection((Projection)Projections.max((String)"oid")).uniqueResult());
    }

    private  @NotNull JpaUtils.CriteriaQuery<DefaultProject, Long> findAllProjectIdsQuery() {
        return new JpaUtils.CriteriaQuery<DefaultProject, Long>((SessionFactory)Preconditions.checkNotNull((Object)this.getSessionFactory()), DefaultProject.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity.get(DefaultProject_.id)).where((Expression)this.cb.equal((Expression)this.entity.get(DefaultProject_.markedForDeletion), (Object)Boolean.FALSE)).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get(DefaultProject_.id))});
            }
        };
    }
}

