/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter;

import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.QuickFilterDao;
import com.atlassian.bamboo.quickfilter.QuickFilterEntity;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

@NotThreadSafe
public class QuickFilterHibernateDao
extends BambooHibernateObjectDao<QuickFilter>
implements QuickFilterDao {
    private static final Class<? extends QuickFilter> PERSISTENT_CLASS = QuickFilterEntity.class;

    @Nullable
    public QuickFilter findById(long id) {
        return this.findById(id, PERSISTENT_CLASS);
    }

    @Nullable
    public QuickFilter findByName(@NotNull String name) {
        return (QuickFilter)this.getCacheAwareHibernateTemplate().execute(session -> (QuickFilter)session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"name", (Object)name)).uniqueResult());
    }

    @NotNull
    public List<QuickFilter> findAll() {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).addOrder(Order.asc((String)"position")).list());
    }

    @Override
    public void save(@NotNull QuickFilter quickFilter) {
        throw new UnsupportedOperationException("Direct usage of #save method is not allowed, call #create or #update instead");
    }

    @Override
    public <E extends QuickFilter> void saveAll(@NotNull Collection<E> entities) {
        throw new UnsupportedOperationException("Direct usage of #saveAll method is not allowed, call #create or #update instead");
    }

    public void create(@NotNull QuickFilter quickFilter) {
        boolean positionSpecified = quickFilter.getPosition() > 0;
        int maxPosition = (int)this.countAll(PERSISTENT_CLASS) + 1;
        if (positionSpecified) {
            quickFilter.setPosition(Math.max(1, Math.min(maxPosition, quickFilter.getPosition())));
        } else {
            quickFilter.setPosition(maxPosition);
        }
        super.save(quickFilter);
        if (positionSpecified) {
            this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("repositionQuickFiltersAfterMoveDown").setParameter("id", (Object)quickFilter.getId()).setParameter("from", (Object)Integer.MAX_VALUE).setParameter("to", (Object)quickFilter.getPosition()).executeUpdate());
        }
    }

    public void update(@NotNull QuickFilter quickFilter, int previousPosition) {
        int maxPosition = (int)this.countAll(PERSISTENT_CLASS);
        quickFilter.setPosition(Math.max(1, Math.min(maxPosition, quickFilter.getPosition())));
        QuickFilter sessionQuickFilter = this.findById(quickFilter.getId());
        Preconditions.checkNotNull((Object)sessionQuickFilter);
        sessionQuickFilter.setName(quickFilter.getName());
        sessionQuickFilter.setPosition(quickFilter.getPosition());
        super.save(sessionQuickFilter);
        if (sessionQuickFilter.getPosition() != previousPosition) {
            String repositionQuery = sessionQuickFilter.getPosition() > previousPosition ? "repositionQuickFiltersAfterMoveUp" : "repositionQuickFiltersAfterMoveDown";
            this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery(repositionQuery).setParameter("id", (Object)sessionQuickFilter.getId()).setParameter("from", (Object)previousPosition).setParameter("to", (Object)sessionQuickFilter.getPosition()).executeUpdate());
        }
    }

    public long scrollQuickFiltersForExport(final @NotNull Consumer<QuickFilter> consumer) {
        ScrollHibernateCallback callback = new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.createQuery("select t from QuickFilterEntity t");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                QuickFilterEntity token = (QuickFilterEntity)data.get(0);
                consumer.accept(token);
                session.evict((Object)token);
            }
        };
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    @Override
    public void delete(@NotNull QuickFilter quickFilter) {
        QuickFilter sessionQuickFilter = this.findById(quickFilter.getId());
        Preconditions.checkNotNull((Object)sessionQuickFilter);
        int position = sessionQuickFilter.getPosition();
        super.delete(sessionQuickFilter);
        this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("repositionQuickFiltersAfterMoveUp").setParameter("id", (Object)-1L).setParameter("from", (Object)position).setParameter("to", (Object)Integer.MAX_VALUE).executeUpdate());
    }
}

