/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.quickfilter.rule;

import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.quickfilter.QuickFilter;
import com.atlassian.bamboo.quickfilter.QuickFilterDao;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRule;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleDao;
import com.atlassian.bamboo.quickfilter.rule.QuickFilterRuleEntity;
import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class QuickFilterRuleHibernateDao
extends BambooHibernateObjectDao<QuickFilterRule>
implements QuickFilterRuleDao {
    private static final Class<? extends QuickFilterRule> PERSISTENT_CLASS = QuickFilterRuleEntity.class;
    @Autowired
    private QuickFilterDao quickFilterDao;

    @Nullable
    public QuickFilterRule findById(long id) {
        return this.findById(id, PERSISTENT_CLASS);
    }

    @Override
    public void save(@NotNull QuickFilterRule quickFilterRule) {
        QuickFilter sessionQuickFilter = this.quickFilterDao.findById(quickFilterRule.getQuickFilter().getId());
        Preconditions.checkNotNull((Object)sessionQuickFilter);
        QuickFilterRule sessionQuickFilterRule = this.findById(quickFilterRule.getId());
        if (sessionQuickFilterRule == null) {
            sessionQuickFilterRule = new QuickFilterRuleEntity(sessionQuickFilter, quickFilterRule.getPluginKey(), quickFilterRule.getName());
        }
        sessionQuickFilterRule.setQuickFilter(sessionQuickFilter);
        sessionQuickFilter.getRules().add(sessionQuickFilterRule);
        sessionQuickFilterRule.setName(quickFilterRule.getName());
        sessionQuickFilterRule.setPluginKey(quickFilterRule.getPluginKey());
        sessionQuickFilterRule.setConfiguration(quickFilterRule.getConfiguration());
        sessionQuickFilterRule.setQuickFilter(quickFilterRule.getQuickFilter());
        super.save(sessionQuickFilterRule);
        quickFilterRule.setId(sessionQuickFilterRule.getId());
    }

    @Override
    public void delete(@NotNull QuickFilterRule quickFilterRule) {
        QuickFilterRule sessionRule = this.findById(quickFilterRule.getId());
        Preconditions.checkNotNull((Object)sessionRule);
        super.delete(sessionRule);
    }
}

