/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.cluster.BambooClusterSettings;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateVersionAwareObjectDao;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDto;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDtoImpl;
import com.atlassian.bamboo.repository.PlanRepositoryLinkImpl;
import com.atlassian.bamboo.repository.PlanRepositoryLinkImpl_;
import com.atlassian.bamboo.versioning.PlanVersioningSupplement;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;

public class PlanRepositoryLinkHibernateDao
extends BambooHibernateVersionAwareObjectDao<PlanRepositoryLink, Plan>
implements PlanRepositoryLinkDao {
    private static final Logger log = Logger.getLogger(PlanRepositoryLinkHibernateDao.class);
    private static final Class<PlanRepositoryLinkImpl> PERSISTENT_CLASS = PlanRepositoryLinkImpl.class;
    private final VersioningSupplement<Plan> versioningSupplement;

    public PlanRepositoryLinkHibernateDao(@NotNull BambooClusterSettings bambooClusterSettings) {
        this.versioningSupplement = new PlanVersioningSupplement(bambooClusterSettings);
    }

    @NotNull
    public List<PlanRepositoryLink> getPlanRepositoryLinks(@NotNull ImmutablePlan plan) {
        return this.getPlanRepositoryLinks((PlanIdentifier)plan);
    }

    @Override
    @NotNull
    protected Optional<VersioningSupplement<Plan>> getRootVersioningSupplement() {
        return Optional.of(this.versioningSupplement);
    }

    @NotNull
    public List<PlanRepositoryLink> getPlanRepositoryLinks(@NotNull PlanIdentifier plan) {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery(PlanRepositoryLink.class);
            Root link = q.from(PERSISTENT_CLASS);
            q.select((Selection)link).where((Expression)cb.equal((Expression)link.get(PlanRepositoryLinkImpl_.plan), (Object)plan.getId())).orderBy(new Order[]{cb.asc((Expression)link.get(PlanRepositoryLinkImpl_.position))});
            return session.createQuery(q).getResultList();
        });
    }

    @NotNull
    public List<PlanRepositoryLinkDto> getPlanRepositoryLinkDtos(final long planId) {
        return new JpaUtils.CriteriaQuery<PlanRepositoryLinkImpl, PlanRepositoryLinkDto>(this.getSessionFactory(), PlanRepositoryLinkImpl.class, PlanRepositoryLinkDto.class){

            @Override
            public void apply() {
                PlanRepositoryLinkHibernateDao.this.constructDtoQuery((Root<? extends PlanRepositoryLinkImpl>)this.entity, (CriteriaQuery<PlanRepositoryLinkDto>)this.q, this.cb).where((Expression)this.cb.equal((Expression)this.entity.get("plan").get("id"), (Object)planId)).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get(PlanRepositoryLinkImpl_.position))});
            }
        }.getResultList();
    }

    @NotNull
    public List<PlanRepositoryLinkDto> getPlanRepositoryLinkDtos(PlanIdentifier plan) {
        return this.getPlanRepositoryLinkDtos(plan.getId());
    }

    public List<PlanRepositoryLink> getPlansUsingRepository(long repositoryId) {
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).createAlias("repositoryDataEntity", "repositoryDataEntity").add((Criterion)Restrictions.eq((String)"repositoryDataEntity.id", (Object)repositoryId)).list());
    }

    public List<PlanIdentifier> getIdentifiersOfPlansUsingRepository(long repositoryId) {
        return (List)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findIdentifiersOfPlansUsingRepository").setParameter("repositoryId", (Object)repositoryId).setParameter("markedForDeletion", (Object)false).list());
    }

    public List<PlanIdentifier> getIdentifiersOfPlansUsingRepositoryOrItsDirectChildren(long repositoryId) {
        return (List)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findIdentifiersOfPlansUsingRepositoryOrItsDirectChildren").setParameter("repositoryId", (Object)repositoryId).setParameter("markedForDeletion", (Object)false).list());
    }

    public boolean isRepositoryOrItsDirectChildrenUsedInPlans(long repositoryId) {
        PlanIdentifier planIdentifier = (PlanIdentifier)this.getHibernateTemplate().execute(session -> (PlanIdentifier)session.getNamedQuery("findIdentifiersOfPlansUsingRepositoryOrItsDirectChildren").setParameter("repositoryId", (Object)repositoryId).setParameter("markedForDeletion", (Object)false).setMaxResults(1).uniqueResult());
        return planIdentifier != null;
    }

    public PlanRepositoryLink getPlanRepositoryLink(@NotNull PlanIdentifier plan, long repositoryId) {
        return (PlanRepositoryLink)this.getHibernateTemplate().execute(session -> (PlanRepositoryLinkImpl)session.createCriteria(PERSISTENT_CLASS).createAlias("repositoryDataEntity", "repositoryDataEntity").add((Criterion)Restrictions.eq((String)"plan.id", (Object)plan.getId())).add((Criterion)Restrictions.eq((String)"repositoryDataEntity.id", (Object)repositoryId)).uniqueResult());
    }

    public PlanRepositoryLink getPlanRepositoryLinkByName(@NotNull PlanIdentifier plan, @NotNull String repositoryName) {
        return (PlanRepositoryLink)this.getHibernateTemplate().execute(session -> (PlanRepositoryLinkImpl)session.createCriteria(PERSISTENT_CLASS).createAlias("repositoryDataEntity", "repositoryDataEntity").add((Criterion)Restrictions.eq((String)"plan.id", (Object)plan.getId())).add((Criterion)Restrictions.eq((String)"repositoryDataEntity.name", (Object)repositoryName)).uniqueResult());
    }

    public void detachAllRepositoriesFromPlan(@NotNull ImmutablePlan plan) {
        this.deleteAll((Collection)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"plan.id", (Object)plan.getId())).list()));
    }

    public void removeLinksByParentRepositoryId(long parentId) {
        this.deleteAll((Collection)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).createAlias("repositoryDataEntity", "repositoryDataEntity").add((Criterion)Restrictions.eq((String)"repositoryDataEntity.parent.id", (Object)parentId)).list()));
    }

    public void removeRepositoryFromPlan(@NotNull PlanRepositoryLink planRepository) {
        this.delete(planRepository);
    }

    private CriteriaQuery<PlanRepositoryLinkDto> constructDtoQuery(Root<? extends PlanRepositoryLinkImpl> entity, CriteriaQuery<PlanRepositoryLinkDto> q, CriteriaBuilder cb) {
        Join joinedRepositoryEntity = entity.join("repositoryDataEntity");
        return q.select((Selection)cb.construct(PlanRepositoryLinkDtoImpl.class, new Selection[]{entity.get("plan").get("id"), joinedRepositoryEntity.get("id"), joinedRepositoryEntity.get("parent").get("id"), entity.get(PlanRepositoryLinkImpl_.position)}));
    }

    @NotNull
    public List<PlanRepositoryLinkDto> findAllDtos() {
        log.info((Object)"Fetching all repository links.");
        return new JpaUtils.CriteriaQuery<PlanRepositoryLinkImpl, PlanRepositoryLinkDto>(this.getSessionFactory(), PlanRepositoryLinkImpl.class, PlanRepositoryLinkDto.class){

            @Override
            public void apply() {
                PlanRepositoryLinkHibernateDao.this.constructDtoQuery((Root<? extends PlanRepositoryLinkImpl>)this.entity, (CriteriaQuery<PlanRepositoryLinkDto>)this.q, this.cb);
            }
        }.getResultList();
    }
}

