/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.cluster.BambooClusterSettings;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.hibernate.callbacks.BulkUpdate;
import com.atlassian.bamboo.hibernate.callbacks.RowCount;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence.BambooSessionFactoryUtils;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persistence3.BambooHibernateVersionAwareObjectWithOidDao;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl_;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.atlassian.bamboo.versioning.RepositoryDataEntityVersioningSupplement;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate5.HibernateCallback;

public class RepositoryDefinitionHibernateDao
extends BambooHibernateVersionAwareObjectWithOidDao<RepositoryDataEntity, Object>
implements RepositoryDefinitionDao {
    private static final Logger log = Logger.getLogger(RepositoryDefinitionHibernateDao.class);
    private static final Class<RepositoryDataEntityImpl> PERSISTENT_CLASS = RepositoryDataEntityImpl.class;
    private static final BambooEntityType ENTITY_TYPE = BambooEntityType.REPOSITORY;
    private static final String GLOBAL = "global";
    private static final String PROJECT_ID = "projectId";
    private static final String MARKED_FOR_DELETION = "markedForDeletion";
    private static final String PLUGIN_KEY = "pluginKey";
    @Lazy
    @Autowired
    private DbmsBean dbmsBeanRef;
    private final TransactionAndHibernateTemplate bambooTransactionHibernateTemplate;
    private final RepositoryDataEntityVersioningSupplement versioningSupplement;

    public RepositoryDefinitionHibernateDao(@NotNull TransactionAndHibernateTemplate bambooTransactionHibernateTemplate, @NotNull BambooClusterSettings bambooClusterSettings) {
        this.bambooTransactionHibernateTemplate = bambooTransactionHibernateTemplate;
        this.versioningSupplement = new RepositoryDataEntityVersioningSupplement(bambooClusterSettings);
    }

    @Override
    @NotNull
    protected Optional<VersioningSupplement<RepositoryDataEntity>> getMainVersioningSupplement() {
        return Optional.of(this.versioningSupplement);
    }

    @Nullable
    public RepositoryDataEntityImpl findById(long id) {
        return this.findById(id, PERSISTENT_CLASS);
    }

    @NotNull
    public Collection<? extends RepositoryDataEntity> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    @NotNull
    public Collection<? extends RepositoryDataEntity> findAll(int firstResult, int maxResults) {
        return (Collection)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).setFirstResult(firstResult).setMaxResults(maxResults).addOrder(org.hibernate.criterion.Order.asc((String)"id")).list());
    }

    @NotNull
    public Collection<? extends RepositoryDataEntity> findAllByParent(@Nullable Long parentId, int firstResult, int maxResults) {
        return (Collection)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add(this.getParentIdCriterion(parentId)).setFirstResult(firstResult).setMaxResults(maxResults).addOrder(org.hibernate.criterion.Order.asc((String)"id")).list());
    }

    public long countAll() {
        return this.countAll(PERSISTENT_CLASS);
    }

    public long countAllByParent(@Nullable Long parentId) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute(session -> (Number)session.createCriteria(PERSISTENT_CLASS).add(this.getParentIdCriterion(parentId)).setProjection(Projections.rowCount()).uniqueResult())).longValue();
    }

    public long countTopLevelGlobalRepositories() {
        return ((Number)this.getCacheAwareHibernateTemplate().execute(session -> (Number)session.createCriteria(PERSISTENT_CLASS).add(this.getParentIdCriterion(null)).add((Criterion)Restrictions.eq((String)GLOBAL, (Object)true)).add(Restrictions.isNull((String)PROJECT_ID)).add((Criterion)Restrictions.eq((String)MARKED_FOR_DELETION, (Object)false)).setProjection(Projections.rowCount()).uniqueResult())).longValue();
    }

    @NotNull
    public List<RepositoryDataEntity> getTopLevelGlobalRepositories(int firstResult, int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add(this.getParentIdCriterion(null)).add((Criterion)Restrictions.eq((String)GLOBAL, (Object)true)).add(Restrictions.isNull((String)PROJECT_ID)).add((Criterion)Restrictions.eq((String)MARKED_FOR_DELETION, (Object)false)).setFirstResult(firstResult).setMaxResults(maxResults).addOrder(org.hibernate.criterion.Order.asc((String)"id")).list());
    }

    @NotNull
    private Criterion getParentIdCriterion(@Nullable Long parentId) {
        return parentId == null ? Restrictions.isNull((String)"parent.id") : Restrictions.eq((String)"parent.id", (Object)parentId);
    }

    public long countRepositoriesByPluginKey(@NotNull String pluginKey) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute(session -> (Number)session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)PLUGIN_KEY, (Object)pluginKey)).setProjection(Projections.rowCount()).uniqueResult())).longValue();
    }

    @NotNull
    public List<RepositoryDataEntity> findRepositoriesByPluginKey(@NotNull String pluginKey) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)PLUGIN_KEY, (Object)pluginKey)).list());
    }

    @NotNull
    public List<RepositoryDataEntity> findRepositoriesByPluginKey(@NotNull String pluginKey, int firstResult, int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)PLUGIN_KEY, (Object)pluginKey)).setFirstResult(firstResult).setMaxResults(maxResults).addOrder(org.hibernate.criterion.Order.asc((String)"id")).list());
    }

    @NotNull
    public List<RepositoryDataEntity> getGlobalRepositoryDefinitions() {
        return new JpaUtils.CriteriaQuery<RepositoryDataEntityImpl, RepositoryDataEntity>(this.getSessionFactory(), RepositoryDataEntityImpl.class, RepositoryDataEntity.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.and(new Predicate[]{this.cb.equal((Expression)this.entity.get(RepositoryDefinitionHibernateDao.GLOBAL), (Object)true), this.cb.isNull((Expression)this.entity.get(RepositoryDefinitionHibernateDao.PROJECT_ID)), this.cb.equal((Expression)this.entity.get(RepositoryDefinitionHibernateDao.MARKED_FOR_DELETION), (Object)false)})).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get("name"))});
            }
        }.getResultList();
    }

    @NotNull
    public List<RepositoryDataEntity> getProjectRepositoryDefinitions(final Long projectId) {
        return new JpaUtils.CriteriaQuery<RepositoryDataEntityImpl, RepositoryDataEntity>(this.getSessionFactory(), RepositoryDataEntityImpl.class, RepositoryDataEntity.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.and((Expression)this.cb.equal((Expression)this.entity.get(RepositoryDefinitionHibernateDao.PROJECT_ID), (Object)projectId), (Expression)this.cb.equal((Expression)this.entity.get(RepositoryDefinitionHibernateDao.MARKED_FOR_DELETION), (Object)false)));
            }
        }.getResultList();
    }

    @NotNull
    public Long countAllProjectsRepositories() {
        return (Long)new JpaUtils.CriteriaQuery<RepositoryDataEntityImpl, Long>(this.getSessionFactory(), RepositoryDataEntityImpl.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where((Expression)this.cb.and((Expression)this.cb.isNotNull((Expression)this.entity.get(RepositoryDataEntityImpl_.projectId)), (Expression)this.cb.equal((Expression)this.entity.get(RepositoryDataEntityImpl_.markedForDeletion), (Object)false)));
            }
        }.getSingleResult();
    }

    @NotNull
    public List<Long> findAllProjectsIdsUsingProjectRepositories() {
        return new JpaUtils.CriteriaQuery<RepositoryDataEntityImpl, Long>(this.getSessionFactory(), RepositoryDataEntityImpl.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity.get(RepositoryDefinitionHibernateDao.PROJECT_ID)).where((Expression)this.cb.and((Expression)this.cb.isNotNull((Expression)this.entity.get(RepositoryDataEntityImpl_.projectId)), (Expression)this.cb.equal((Expression)this.entity.get(RepositoryDataEntityImpl_.markedForDeletion), (Object)false))).distinct(true);
            }
        }.getResultList();
    }

    @NotNull
    public Collection<RepositoryDataEntity> getPrivateRepositoryDefinitionsByPlan(Plan plan) {
        return (Collection)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("getPrivateRepositoryDefinitionsByPlan").setParameter("planId", (Object)plan.getId()).setParameter(GLOBAL, (Object)false).list());
    }

    public void removeRepositoryIfUnused(RepositoryDataEntity repositoryDataEntity) {
        boolean used = false;
        DetachedCriteria repositoryChangesetCriteria = DetachedCriteria.forClass(RepositoryChangesetImpl.class).add((Criterion)Property.forName((String)"repositoryData").eq((Object)repositoryDataEntity));
        DetachedCriteria deploymentVersionVcsChangesetCriteria = DetachedCriteria.forEntityName((String)"com.atlassian.bamboo.deployments.versions.persistence.commits.MutableDeploymentVersionVcsChangesetImpl").add((Criterion)Property.forName((String)"repositoryData").eq((Object)repositoryDataEntity));
        DetachedCriteria childrenCriteria = DetachedCriteria.forClass(RepositoryDataEntityImpl.class).add((Criterion)Property.forName((String)"parent").eq((Object)repositoryDataEntity));
        try {
            used = RowCount.execute(this.getCacheAwareHibernateTemplate(), childrenCriteria) > 0L || RowCount.execute(this.getCacheAwareHibernateTemplate(), repositoryChangesetCriteria) > 0L || RowCount.execute(this.getCacheAwareHibernateTemplate(), deploymentVersionVcsChangesetCriteria) > 0L;
        }
        catch (HibernateException e) {
            log.error((Object)"Error executing query ", (Throwable)e);
        }
        if (used) {
            this.detachRepositoryFromDeploymentEnvironments(repositoryDataEntity);
            repositoryDataEntity.setMarkedForDeletion(true);
            this.save(repositoryDataEntity);
        } else {
            this.getCacheAwareHibernateTemplate().execute((HibernateCallback)BulkUpdate.forNamedQuery("deletePlanVcsRevisionHistoryItemsByRepositoryId", "repositoryId", repositoryDataEntity.getId()));
            this.delete(repositoryDataEntity);
        }
    }

    @Override
    public void delete(@NotNull RepositoryDataEntity repositoryDataEntity) {
        this.detachRepositoryFromDeploymentEnvironments(repositoryDataEntity);
        this.getCacheAwareHibernateTemplate().execute(session -> {
            session.createNamedQuery("VcsTagDao.deleteAllForRepositoryDataId").setParameter("repositoryDataId", (Object)repositoryDataEntity.getId()).executeUpdate();
            RepositoryDataEntity entity = (RepositoryDataEntity)session.get(RepositoryDataEntityImpl.class, (Serializable)Long.valueOf(repositoryDataEntity.getId()));
            session.delete((Object)entity);
            return null;
        });
    }

    private void detachRepositoryFromDeploymentEnvironments(@NotNull RepositoryDataEntity repositoryDataEntity) {
        String SQL_DELETE = String.format("delete from DEPLOYMENT_ENV_VCS_LOCATION where VCS_LOCATION_ID = %s", repositoryDataEntity.getId());
        this.bambooTransactionHibernateTemplate.doWork(connection -> JdbcUtils.runDeleteQuery(connection, SQL_DELETE, "EnvironmentRepositoryLink"));
    }

    @Override
    public void save(@NotNull RepositoryDataEntity repositoryDataEntity) {
        if (repositoryDataEntity.getId() == -1L) {
            super.save(repositoryDataEntity);
        } else {
            this.getHibernateTemplate().merge((Object)repositoryDataEntity);
            this.versioningSupplement.incrementVersion(repositoryDataEntity.getId(), this.getHibernateTemplate().getSessionFactory().getCurrentSession());
        }
    }

    public void removeUnusedRepositories() {
        try {
            String markedForDeletionClause = "(select r.id from RepositoryDataEntityImpl AS r where r.markedForDeletion = :markedForDeletion)";
            String deleteFromPlanVcsLocation = "delete from PlanRepositoryLinkImpl where repositoryDataEntity.id in (select r.id from RepositoryDataEntityImpl AS r where r.markedForDeletion = :markedForDeletion)";
            String deleteFromEnvironmentVcsLocation = "delete from EnvironmentRepositoryLinkImpl where repositoryDataEntity.id in (select r.id from RepositoryDataEntityImpl AS r where r.markedForDeletion = :markedForDeletion)";
            this.getCacheAwareHibernateTemplate().execute((HibernateCallback)BulkUpdate.forQuery("delete from PlanRepositoryLinkImpl where repositoryDataEntity.id in (select r.id from RepositoryDataEntityImpl AS r where r.markedForDeletion = :markedForDeletion)", MARKED_FOR_DELETION, true));
            this.getCacheAwareHibernateTemplate().execute((HibernateCallback)BulkUpdate.forQuery("delete from EnvironmentRepositoryLinkImpl where repositoryDataEntity.id in (select r.id from RepositoryDataEntityImpl AS r where r.markedForDeletion = :markedForDeletion)", MARKED_FOR_DELETION, true));
            String notUsedRepositoryWhereClause = " where r.markedForDeletion = :markedForDeletion and not exists ( from com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl AS rc WHERE rc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.deployments.versions.persistence.commits.MutableDeploymentVersionVcsChangesetImpl AS vc WHERE vc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.repository.RepositoryDataEntityImpl AS child WHERE child.parent.id = r.id )";
            String inClause = "(select r.id from RepositoryDataEntityImpl AS r  where r.markedForDeletion = :markedForDeletion and not exists ( from com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl AS rc WHERE rc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.deployments.versions.persistence.commits.MutableDeploymentVersionVcsChangesetImpl AS vc WHERE vc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.repository.RepositoryDataEntityImpl AS child WHERE child.parent.id = r.id ))";
            this.getCacheAwareHibernateTemplate().execute((HibernateCallback)BulkUpdate.forQuery("delete from PlanVcsRevisionHistoryItem where repositoryId in (select r.id from RepositoryDataEntityImpl AS r  where r.markedForDeletion = :markedForDeletion and not exists ( from com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl AS rc WHERE rc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.deployments.versions.persistence.commits.MutableDeploymentVersionVcsChangesetImpl AS vc WHERE vc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.repository.RepositoryDataEntityImpl AS child WHERE child.parent.id = r.id ))", MARKED_FOR_DELETION, true));
            this.getCacheAwareHibernateTemplate().execute((HibernateCallback)BulkUpdate.forQuery("delete from VcsTagImpl vt where repositoryData.id in (select r.id from RepositoryDataEntityImpl AS r  where r.markedForDeletion = :markedForDeletion and not exists ( from com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl AS rc WHERE rc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.deployments.versions.persistence.commits.MutableDeploymentVersionVcsChangesetImpl AS vc WHERE vc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.repository.RepositoryDataEntityImpl AS child WHERE child.parent.id = r.id ))", MARKED_FOR_DELETION, true));
            if (!this.dbmsBeanRef.isMySql()) {
                this.getCacheAwareHibernateTemplate().execute((HibernateCallback)BulkUpdate.forQuery("delete from RepositoryDataEntityImpl AS r  where r.markedForDeletion = :markedForDeletion and not exists ( from com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl AS rc WHERE rc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.deployments.versions.persistence.commits.MutableDeploymentVersionVcsChangesetImpl AS vc WHERE vc.repositoryData.id = r.id ) and not exists ( from com.atlassian.bamboo.repository.RepositoryDataEntityImpl AS child WHERE child.parent.id = r.id )", MARKED_FOR_DELETION, true));
            } else {
                this.removeUnusedRepositoriesMysql();
            }
        }
        catch (HibernateException e) {
            log.error((Object)"Error executing repository definition cleanup", (Throwable)e);
        }
    }

    private void removeUnusedRepositoriesMysql() {
        String MYSQL_SELECT_UNUSED_REPOSITORIES_IDS = "select VCS_LOCATION_ID from VCS_LOCATION  where MARKED_FOR_DELETION is true and VCS_LOCATION_ID not in (select VCS_LOCATION_ID from REPOSITORY_CHANGESET) and VCS_LOCATION_ID not in (select VCS_LOCATION_ID from DEPLOYMENT_VERSION_CHANGESET) and VCS_LOCATION_ID not in (select PARENT_ID from VCS_LOCATION)";
        String MYSQL_DELETE_UNUSED_REPOSITORIES = "delete from VCS_LOCATION where VCS_LOCATION_ID in (";
        this.bambooTransactionHibernateTemplate.doWork(connection -> {
            List<Long> ids = JdbcUtils.getListOfLong(connection, "select VCS_LOCATION_ID from VCS_LOCATION  where MARKED_FOR_DELETION is true and VCS_LOCATION_ID not in (select VCS_LOCATION_ID from REPOSITORY_CHANGESET) and VCS_LOCATION_ID not in (select VCS_LOCATION_ID from DEPLOYMENT_VERSION_CHANGESET) and VCS_LOCATION_ID not in (select PARENT_ID from VCS_LOCATION)");
            if (!ids.isEmpty()) {
                try (Statement statement = connection.createStatement();){
                    for (List chunk : Lists.partition(ids, (int)100)) {
                        statement.executeUpdate("delete from VCS_LOCATION where VCS_LOCATION_ID in (" + Joiner.on((char)',').join((Iterable)chunk) + ")");
                    }
                }
            }
        });
    }

    @NotNull
    public Set<Long> findAllRepositoryIds() {
        return this.findAllRepositoryIds(true);
    }

    @NotNull
    public Set<Long> findAllRepositoryIds(final boolean includeMarkedForDeletion) {
        return (Set)this.bambooTransactionHibernateTemplate.execute(session -> new HashSet(new JpaUtils.CriteriaQuery<RepositoryDataEntity, Long>(this.getSessionFactory(), RepositoryDataEntityImpl.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity.get("id"));
                if (!includeMarkedForDeletion) {
                    this.q.where((Expression)this.cb.equal((Expression)this.entity.get(RepositoryDefinitionHibernateDao.MARKED_FOR_DELETION), (Object)false));
                }
            }
        }.getResultList()));
    }

    @NotNull
    public List<RepositoryDataEntity> findAll(final boolean includeMarkedForDeletion) {
        return (List)this.bambooTransactionHibernateTemplate.execute(session -> new JpaUtils.CriteriaQuery<RepositoryDataEntityImpl, RepositoryDataEntity>(this.getSessionFactory(), RepositoryDataEntityImpl.class, RepositoryDataEntity.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity);
                if (!includeMarkedForDeletion) {
                    this.q.where((Expression)this.cb.equal((Expression)this.entity.get(RepositoryDefinitionHibernateDao.MARKED_FOR_DELETION), (Object)false));
                }
            }
        }.getResultList());
    }

    @NotNull
    public Set<Long> findAllTopLevelRepositoriesIds() {
        List allIds = (List)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("findAllTopLevelIds").setParameter(MARKED_FOR_DELETION, (Object)false).list());
        return Sets.newHashSet((Iterable)allIds);
    }

    @Nullable
    public BambooEntityOid getMaxRepositoryOid(int serverKey) {
        return (BambooEntityOid)this.getHibernateTemplate().execute(session -> (BambooEntityOid)session.createCriteria(PERSISTENT_CLASS).add(Restrictions.between((String)"oid", (Object)BambooEntityOid.minOidOfType((int)serverKey, (BambooEntityType)ENTITY_TYPE), (Object)BambooEntityOid.maxOidOfType((int)serverKey, (BambooEntityType)ENTITY_TYPE))).setProjection((Projection)Projections.max((String)"oid")).uniqueResult());
    }

    @Nullable
    public RepositoryDataEntity findLinkedRepositoryByName(@NotNull String name) {
        return (RepositoryDataEntity)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(PERSISTENT_CLASS);
            criteria.setCacheable(true);
            criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
            criteria.add((Criterion)Restrictions.eq((String)GLOBAL, (Object)true));
            criteria.add(Restrictions.isNull((String)PROJECT_ID));
            criteria.add((Criterion)Restrictions.eq((String)MARKED_FOR_DELETION, (Object)false));
            BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)this.getSessionFactory());
            return (RepositoryDataEntity)criteria.uniqueResult();
        });
    }

    public void markForDeletionByParentId(long parentId) {
        String SQL_SET_MARKED_FOR_DELETION = "update VCS_LOCATION set MARKED_FOR_DELETION = ?, VERSION = VERSION + 1 where PARENT_ID = ?";
        this.bambooTransactionHibernateTemplate.doWork(connection -> {
            try (PreparedStatement statement = connection.prepareStatement("update VCS_LOCATION set MARKED_FOR_DELETION = ?, VERSION = VERSION + 1 where PARENT_ID = ?");){
                statement.setBoolean(1, true);
                statement.setLong(2, parentId);
                JdbcUtils.runUpdateQuery(statement, "update VCS_LOCATION set MARKED_FOR_DELETION = ?, VERSION = VERSION + 1 where PARENT_ID = ?", "RepositoryDataEntity");
                int n = statement.executeUpdate();
            }
        });
    }

    public void markForDeletionByProjectId(long projectId) {
        String SQL_SET_MARKED_FOR_DELETION = "update VCS_LOCATION set MARKED_FOR_DELETION = ?, VERSION = VERSION + 1 where PROJECT_ID = ?";
        this.bambooTransactionHibernateTemplate.doWork(connection -> {
            try (PreparedStatement statement = connection.prepareStatement("update VCS_LOCATION set MARKED_FOR_DELETION = ?, VERSION = VERSION + 1 where PROJECT_ID = ?");){
                statement.setBoolean(1, true);
                statement.setLong(2, projectId);
                JdbcUtils.runUpdateQuery(statement, "update VCS_LOCATION set MARKED_FOR_DELETION = ?, VERSION = VERSION + 1 where PROJECT_ID = ?", "RepositoryDataEntity");
                int n = statement.executeUpdate();
            }
        });
    }

    @Nullable
    public RepositoryDataEntity findProjectRepositoryByName(final @NotNull String name, final @NotNull Long projectId) {
        return (RepositoryDataEntity)new JpaUtils.CriteriaQuery<RepositoryDataEntityImpl, RepositoryDataEntity>(this.getSessionFactory(), RepositoryDataEntityImpl.class, RepositoryDataEntity.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.and(new Predicate[]{this.cb.equal((Expression)this.entity.get(RepositoryDefinitionHibernateDao.PROJECT_ID), (Object)projectId), this.cb.equal((Expression)this.entity.get("name"), (Object)name), this.cb.equal((Expression)this.entity.get(RepositoryDefinitionHibernateDao.MARKED_FOR_DELETION), (Object)false)}));
            }
        }.uniqueResult();
    }
}

