/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.resultsummary.AgentBuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.sql.Timestamp;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public class AgentBuildResultsSummaryHibernateDao
extends BambooHibernateObjectDao<ResultsSummary>
implements AgentBuildResultsSummaryDao {
    private static final String BUILD_AGENT_ID = "buildAgentId";

    public long calculateUtilisedAgentTime(long agentId) {
        return this.calculateBuildingTimeForAgent(agentId) + this.calculateVcsUpdateTimeForAgent(agentId);
    }

    private long calculateBuildingTimeForAgent(long agentId) {
        Number durationTime = (Number)this.getCacheAwareHibernateTemplate().execute(session -> (Number)session.getNamedQuery("calculateUtilisedAgentTime").setParameter(BUILD_AGENT_ID, (Object)agentId).uniqueResult());
        if (durationTime != null) {
            return durationTime.longValue();
        }
        return 0L;
    }

    private long calculateVcsUpdateTimeForAgent(final long agentId) {
        List results = (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Object[]>>(){

            public List<Object[]> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("getDataForVcsUpdateDurationCalculationForAgent").setParameter(AgentBuildResultsSummaryHibernateDao.BUILD_AGENT_ID, (Object)agentId).list();
            }
        });
        return this.calculateSumOfVcsDurationsFromResultSet(results);
    }

    @NotNull
    private long calculateSumOfVcsDurationsFromResultSet(@NotNull List<Object[]> results) {
        long sum = 0L;
        for (Object[] result : results) {
            long duration = ((Timestamp)result[0]).getTime() - ((Timestamp)result[1]).getTime();
            sum += Math.max(0L, duration);
        }
        return sum;
    }
}

