/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.DefaultArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainResultsSummaryImpl;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ChainStageResultImpl;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabellingImpl;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDiscriminatorRegistry;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.CacheLoadContextSupport;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.DeletionSQLAdapter;
import com.atlassian.bamboo.resultsummary.ExpiryCriteria;
import com.atlassian.bamboo.resultsummary.PlanKeyResultDeletionSQLAdapter;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultSummaryClassHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteriaConverter;
import com.atlassian.bamboo.resultsummary.ResultsSummaryDiscriminatorRegistry;
import com.atlassian.bamboo.resultsummary.search.ByJiraIssueResultSearchCriteria;
import com.atlassian.bamboo.resultsummary.search.ResultSummarySearchCriteria;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.BambooLog4j2Utils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.Range;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.variable.VariableSubstitution;
import com.atlassian.bamboo.variable.VariableSubstitutionImpl;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.baseline.VariableContextBaseline;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.Work;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.springframework.orm.hibernate5.HibernateCallback;

public class BuildResultsSummaryHibernateDao
extends BambooHibernateObjectDao<ResultsSummary>
implements BuildResultsSummaryDao {
    private static final Logger log = LogManager.getLogger(BuildResultsSummaryHibernateDao.class);
    protected static final String CREATION_DATE = "creationDate";
    protected static final String BUILD_COMPLETED_DATE = "buildCompletedDate";
    protected static final String BUILD_AGENT_ID = "buildAgentId";
    protected static final String BUILD_NUMBER = "buildNumber";
    protected static final String PLAN_KEY = "planKey";
    protected static final String BUILD_STATE = "buildState";
    protected static final String LIFE_CYCLE_STATE = "lifeCycleState";
    protected static final String DELTA_STATE = "deltaState";
    private static final String LOWER_BUILD_NUMBER = "lowerBuildNumber";
    private static final String UPPER_BUILD_NUMBER = "upperBuildNumber";
    protected static final String CONTINUABLE = "continuable";
    private static final String ONCE_OFF = "onceOff";
    private static final String DISCRIMINATOR = "discriminator";
    private static final String CHAIN_RESULTS_SUMMARY = "chainResultsSummary";
    private static final String TRIGGER_REASON_KEY = "triggerReasonKey";
    static final String MARKED_FOR_DELETION = "markedForDeletion";
    public static final int NEIGHBOURING_SUMMARIES_MAX_COUNT = 11;
    private static final String ISSUE_KEY = "issueKey";
    private final Supplier<DbmsBean> dbmsBeanRef = ComponentAccessor.DBMS_BEAN;
    private final TransactionAndHibernateTemplate bambooTransactionHibernateTemplate;
    private ResultsSummaryDiscriminatorRegistry resultsSummaryDiscriminatorRegistry;
    private PlanDiscriminatorRegistry planDiscriminatorRegistry;

    public BuildResultsSummaryHibernateDao(BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate) {
        this.bambooTransactionHibernateTemplate = bambooTransactionHibernateTemplate;
    }

    public Long getResultsSummaryId(final @NotNull PlanResultKey planResultKey) {
        return (Long)this.getCacheAwareHibernateTemplate().executeWithNativeSession((HibernateCallback)new HibernateCallback<Long>(){

            public Long doInHibernate(Session session) throws HibernateException {
                return (Long)session.getNamedQuery("getResultsSummaryId").setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planResultKey.getPlanKey().getKey()).setParameter(BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)planResultKey.getBuildNumber()).setCacheable(true).uniqueResult();
            }
        });
    }

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(@NotNull PlanResultKey planResultKey, @NotNull Class<T> aClass) {
        return this.getResultsSummary(planResultKey, aClass, ResultDataRead.LAZY);
    }

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(final @NotNull PlanResultKey planResultKey, final @NotNull Class<T> aClass, final ResultDataRead dataRead) {
        return (T)((ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public T doInHibernate(Session session) throws HibernateException {
                try {
                    ResultsSummary o = (ResultsSummary)BuildResultsSummaryHibernateDao.this.createCriteria(session, aClass).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planResultKey.getPlanKey().getKey())).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)planResultKey.getBuildNumber())).uniqueResult();
                    if (o != null) {
                        BuildResultsSummaryHibernateDao.this.initializeLazyProperties(o, dataRead);
                    }
                    return o;
                }
                catch (HibernateException e) {
                    log.error("Problems getting build result summary by key '{}'", (Object)planResultKey, (Object)e);
                    return null;
                }
            }
        }));
    }

    @Override
    public <E extends ResultsSummary> E findById(final long id, final @NotNull Class<E> aClass) {
        return (E)((ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                ResultsSummary result = (ResultsSummary)BuildResultsSummaryHibernateDao.this.createCriteria(session, aClass).add((Criterion)Restrictions.eq((String)"id", (Object)id)).uniqueResult();
                if (result != null) {
                    session.refresh((Object)result);
                }
                return result;
            }
        }));
    }

    private void evictResultSummary(@NotNull Session session, @NotNull ResultsSummary resultSummary) throws HibernateException {
        VariableContextBaseline variableContextBaseline;
        ChainResultsSummary chainResultsSummary;
        BuildResultsSummary buildResultsSummary = (BuildResultsSummary)Narrow.downTo((Object)resultSummary, BuildResultsSummary.class);
        if (buildResultsSummary != null && (chainResultsSummary = buildResultsSummary.getChainResultsSummary()) != null) {
            this.evictResultSummary(session, (ResultsSummary)chainResultsSummary);
        }
        AbstractResultsSummary abstractResultsSummary = (AbstractResultsSummary)Narrow.downTo((Object)resultSummary, AbstractResultsSummary.class);
        if (Hibernate.isInitialized((Object)resultSummary.getArtifactLinks())) {
            for (ArtifactLink artifactLink : resultSummary.getArtifactLinks()) {
                session.evict((Object)artifactLink.getArtifact());
            }
        }
        if (resultSummary instanceof ChainResultsSummary || Hibernate.isInitialized((Object)resultSummary.getRepositoryChangesets())) {
            for (RepositoryChangeset repositoryChangeset : resultSummary.getRepositoryChangesets()) {
                session.evict((Object)repositoryChangeset.getRepositoryData());
                if (!Hibernate.isInitialized((Object)repositoryChangeset.getCommits())) continue;
                for (Commit commit : repositoryChangeset.getCommits()) {
                    session.evict((Object)commit.getAuthor());
                }
            }
        }
        if ((variableContextBaseline = abstractResultsSummary.getVariableContextBaseline()) != null) {
            session.evict((Object)variableContextBaseline);
        }
        session.evict((Object)resultSummary);
    }

    private void initializeLazyProperties(@NotNull ResultsSummary resultSummary, ResultDataRead dataRead) {
        if (dataRead == ResultDataRead.EAGER || dataRead == ResultDataRead.FULL) {
            this.initializeLazyProperties(resultSummary);
            if (dataRead == ResultDataRead.FULL) {
                this.initializeCommits(resultSummary);
            }
        }
    }

    private void initializeLazyProperties(@NotNull ResultsSummary resultSummary) throws HibernateException {
        BuildResultsSummary buildResultsSummary;
        ChainResultsSummary chainResultsSummary;
        log.trace("CACHE_TRACE initializeLazyProperties");
        if (!Hibernate.isInitialized((Object)resultSummary.getRepositoryChangesets())) {
            Hibernate.initialize((Object)resultSummary.getRepositoryChangesets());
        }
        if (!Hibernate.isInitialized((Object)resultSummary.getJiraIssues())) {
            Hibernate.initialize((Object)resultSummary.getJiraIssues());
        }
        if (!Hibernate.isInitialized((Object)resultSummary.getLabellings())) {
            Hibernate.initialize((Object)resultSummary.getLabellings());
        }
        if (!Hibernate.isInitialized((Object)resultSummary.getCustomBuildData())) {
            Hibernate.initialize((Object)resultSummary.getCustomBuildData());
        }
        if (!Hibernate.isInitialized((Object)resultSummary.getArtifactLinks())) {
            Hibernate.initialize((Object)resultSummary.getArtifactLinks());
        }
        if ((chainResultsSummary = (ChainResultsSummary)Narrow.downTo((Object)resultSummary, ChainResultsSummary.class)) != null && !Hibernate.isInitialized((Object)chainResultsSummary.getStageResults())) {
            Hibernate.initialize((Object)chainResultsSummary.getStageResults());
        }
        if ((buildResultsSummary = (BuildResultsSummary)Narrow.downTo((Object)resultSummary, BuildResultsSummary.class)) != null && (chainResultsSummary = buildResultsSummary.getChainResultsSummary()) != null) {
            if (!Hibernate.isInitialized((Object)chainResultsSummary)) {
                Hibernate.initialize((Object)chainResultsSummary);
            }
            this.initializeLazyProperties((ResultsSummary)chainResultsSummary);
        }
        log.trace("CACHE_TRACE /initializeLazyProperties");
    }

    private <T extends ResultsSummary> void initializeCommits(T resultsSummary) throws HibernateException {
        for (RepositoryChangeset repositoryChangeset : resultsSummary.getRepositoryChangesets()) {
            Hibernate.initialize((Object)repositoryChangeset.getCommits());
        }
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllBuildResultSummariesInBuildState(final @NotNull BuildState state, @NotNull Class<T> aClass) {
        Class<T> entityClass = this.getEntityClassForResultType(aClass);
        return new JpaUtils.CriteriaQuery<T, T>(this.getSessionFactory(), entityClass, aClass){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where(new Predicate[]{this.cb.equal((Expression)this.entity.get(BuildResultsSummaryHibernateDao.BUILD_STATE), (Object)state), this.cb.equal((Expression)this.entity.get(BuildResultsSummaryHibernateDao.MARKED_FOR_DELETION), (Object)false)});
            }
        }.getResultList();
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllBuildResultSummariesInLifeCycleState(final @NotNull LifeCycleState state, @NotNull Class<T> aClass) {
        Class<T> entityClass = this.getEntityClassForResultType(aClass);
        return new JpaUtils.CriteriaQuery<T, T>(this.getSessionFactory(), entityClass, aClass){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where(new Predicate[]{this.cb.equal((Expression)this.entity.get(BuildResultsSummaryHibernateDao.LIFE_CYCLE_STATE), (Object)state), this.cb.equal((Expression)this.entity.get(BuildResultsSummaryHibernateDao.MARKED_FOR_DELETION), (Object)false)});
            }
        }.getResultList();
    }

    @NotNull
    private <T extends ResultsSummary> List<T> getBuildResultSummariesInLifeCycleStateForPlan(final @NotNull PlanKey planKey, final @NotNull EnumSet<LifeCycleState> states, final @NotNull Class<T> aClass, final boolean ordered, final int firstResult, final int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                Validate.notEmpty((Collection)states, (String)"Requested LifeCycleStates collection MUST not be empty", (Object[])new Object[0]);
                Criteria criteria = session.createCriteria(aClass).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey.getKey())).add(Restrictions.in((String)BuildResultsSummaryHibernateDao.LIFE_CYCLE_STATE, (Collection)states));
                if (ordered || firstResult > 0 || maxResults > 0) {
                    criteria.addOrder(org.hibernate.criterion.Order.desc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER));
                }
                if (firstResult > 0) {
                    criteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    criteria.setMaxResults(maxResults);
                }
                return criteria.list();
            }
        });
    }

    private <E extends ImmutablePlan> long countBuildResultSummariesInLifeCycleStateForPlan(final @NotNull PlanKey planKey, final @NotNull EnumSet<LifeCycleState> states, final @NotNull Class<E> aClass) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                Validate.notEmpty((Collection)states, (String)"Requested LifeCycleStates collection MUST not be empty", (Object[])new Object[0]);
                Set<String> discriminatorValues = BuildResultsSummaryHibernateDao.this.resultsSummaryDiscriminatorRegistry.getDiscriminatorsForPlanType(aClass);
                Query namedQuery = session.getNamedQuery("findNumberOfResults");
                namedQuery.setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey.getKey());
                namedQuery.setParameterList(BuildResultsSummaryHibernateDao.LIFE_CYCLE_STATE, LifeCycleState.lifeCycleStatesToStringCollection((Collection)states));
                namedQuery.setParameterList("resultTypes", discriminatorValues);
                namedQuery.setCacheable(true);
                return (Number)namedQuery.uniqueResult();
            }
        })).longValue();
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllBuildResultSummariesInUnknownState(Class<T> aClass) {
        return this.getAllBuildResultSummariesInBuildState(BuildState.UNKNOWN, aClass);
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllPendingResultSummaries(Class<T> aClass) {
        return this.getAllBuildResultSummariesInLifeCycleState(LifeCycleState.PENDING, aClass);
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllQueuedResultSummaries(Class<T> aClass) {
        return this.getAllBuildResultSummariesInLifeCycleState(LifeCycleState.QUEUED, aClass);
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllInProgressResultSummaries(Class<T> aClass) {
        return this.getAllBuildResultSummariesInLifeCycleState(LifeCycleState.IN_PROGRESS, aClass);
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllActiveResultSummariesForPlan(PlanKey planKey, Class<T> aClass) {
        return this.getBuildResultSummariesInLifeCycleStateForPlan(planKey, LifeCycleState.ACTIVE_STATES, aClass, false, 0, 0);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getFinalizedResultSummariesForPlan(PlanKey planKey, Class<T> aClass, int firstResult, int maxResults) {
        return this.getBuildResultSummariesInLifeCycleStateForPlan(planKey, LifeCycleState.FINAL_STATES, aClass, true, firstResult, maxResults);
    }

    public int getNumberOfConcurrentlyRunningBuilds(PlanKey planKey) {
        return this.getBuildResultSummariesInLifeCycleStateForPlan(planKey, LifeCycleState.ACTIVE_STATES, ResultsSummary.class, false, 0, 0).size();
    }

    @NotNull
    public Collection<BuildResultsSummary> getAllInProgressBuildResultSummaries() {
        return this.getAllBuildResultSummariesInLifeCycleState(LifeCycleState.IN_PROGRESS, BuildResultsSummary.class);
    }

    @Nullable
    public <T extends ResultsSummary> T findAnyResultSummary(@NotNull ResultsSummaryCriteria criteria, ResultDataRead dataRead) {
        return (T)((ResultsSummary)this.getCacheAwareHibernateTemplate().execute(session -> {
            try {
                ResultsSummary o = (ResultsSummary)this.createCriteria(session, criteria).setCacheable(false).setMaxResults(1).uniqueResult();
                if (o != null) {
                    this.initializeLazyProperties(o, dataRead);
                }
                return o;
            }
            catch (HibernateException e) {
                log.error("Problems getting build result summary by criteria", (Throwable)e);
                return null;
            }
        }));
    }

    @NotNull
    public <T extends ResultsSummary> List<T> findByJiraCriteria(@NotNull ByJiraIssueResultSearchCriteria jiraCriteria, @NotNull ResultSummarySearchCriteria criteria, @NotNull Class<T> resultClass, @NotNull ResultDataRead dataRead) {
        Class<T> entityClass = this.getEntityClassForResultType(resultClass);
        if (CollectionUtils.isEmpty((Collection)jiraCriteria.getIssueKeys()) && CollectionUtils.isEmpty((Collection)jiraCriteria.getProjectKeys())) {
            return Collections.emptyList();
        }
        Session session = this.getSessionFactory().getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(resultClass);
        Root entity = q.from(entityClass);
        Join join = entity.join("jiraIssues");
        List<Predicate> predicates = this.getPredicatesFromResultSearchCriteria(criteria, cb, (From<?, ? extends T>)entity, (Class<? extends T>)entityClass);
        this.addJiraIssueCriteria(jiraCriteria, cb, join, predicates);
        q.select((Selection)entity).where(predicates.toArray(new Predicate[0])).distinct(true);
        if (criteria.isOrderedByDate()) {
            q.orderBy(new Order[]{cb.desc((Expression)entity.get("buildDate"))});
        }
        Query query = session.createQuery(q);
        if (criteria.getMaxCount() > 0) {
            query.setMaxResults(criteria.getMaxCount());
        }
        List results = query.list();
        results.forEach(o -> this.initializeLazyProperties((ResultsSummary)o, dataRead));
        return results;
    }

    public <T extends ResultsSummary> Long countByJiraCriteria(@NotNull ByJiraIssueResultSearchCriteria jiraCriteria, @NotNull ResultSummarySearchCriteria criteria, @NotNull Class<T> resultClass) {
        Class<T> entityClass = this.getEntityClassForResultType(resultClass);
        if (CollectionUtils.isEmpty((Collection)jiraCriteria.getIssueKeys()) && CollectionUtils.isEmpty((Collection)jiraCriteria.getProjectKeys())) {
            return 0L;
        }
        Session session = this.getSessionFactory().getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Long.class);
        Root entity = q.from(entityClass);
        Join join = entity.join("jiraIssues");
        List<Predicate> predicates = this.getPredicatesFromResultSearchCriteria(criteria, cb, (From<?, ? extends T>)entity, (Class<? extends T>)entityClass);
        this.addJiraIssueCriteria(jiraCriteria, cb, join, predicates);
        q.select((Selection)cb.count((Expression)entity)).where(predicates.toArray(new Predicate[0])).distinct(true);
        return (Long)session.createQuery(q).getSingleResult();
    }

    private <T extends ResultsSummary> void addJiraIssueCriteria(@NotNull ByJiraIssueResultSearchCriteria jiraCriteria, @NotNull CriteriaBuilder cb, @NotNull Join<LinkedJiraIssueImpl, ? extends T> join, @NotNull List<Predicate> predicates) {
        if (!CollectionUtils.isEmpty((Collection)jiraCriteria.getProjectKeys())) {
            predicates.add(cb.or((Predicate[])jiraCriteria.getProjectKeys().stream().map(projectKey -> cb.like((Expression)join.get(ISSUE_KEY), projectKey + "-%")).toArray(Predicate[]::new)));
        }
        if (!CollectionUtils.isEmpty((Collection)jiraCriteria.getIssueKeys())) {
            if (CollectionUtils.size((Object)jiraCriteria.getIssueKeys()) == 1) {
                predicates.add(cb.equal((Expression)join.get(ISSUE_KEY), Iterables.getOnlyElement((Iterable)jiraCriteria.getIssueKeys())));
            } else {
                predicates.add(join.get(ISSUE_KEY).in((Collection)jiraCriteria.getIssueKeys()));
            }
        }
    }

    @NotNull
    public <T extends ResultsSummary> List<T> findByCriteria(final @NotNull ResultSummarySearchCriteria criteria, @NotNull Class<T> resultClass, @NotNull ResultDataRead dataRead) {
        final Class<T> entityClass = this.getEntityClassForResultType(resultClass);
        JpaUtils.CriteriaQuery query = new JpaUtils.CriteriaQuery<T, T>(this.getSessionFactory(), entityClass, resultClass){

            @Override
            public void apply() {
                List<Predicate> predicates = BuildResultsSummaryHibernateDao.this.getPredicatesFromResultSearchCriteria(criteria, this.cb, this.entity, entityClass);
                this.q.select((Selection)this.entity).where(predicates.toArray(new Predicate[0]));
                if (criteria.isOrderedByDate()) {
                    this.q.orderBy(new Order[]{this.cb.desc((Expression)this.entity.get("buildDate"))});
                }
            }
        };
        List results = criteria.getMaxCount() > 0 ? query.getResultList(0, criteria.getMaxCount()) : query.getResultList();
        results.forEach(o -> this.initializeLazyProperties((ResultsSummary)o, dataRead));
        return results;
    }

    private <T extends ResultsSummary> List<Predicate> getPredicatesFromResultSearchCriteria(@NotNull ResultSummarySearchCriteria criteria, @NotNull CriteriaBuilder cb, @NotNull From<?, ? extends T> entity, @NotNull Class<? extends T> entityClass) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!CollectionUtils.isEmpty((Collection)criteria.getLifeCycleStates())) {
            if (criteria.getLifeCycleStates().size() == 1) {
                predicates.add(cb.equal((Expression)entity.get(LIFE_CYCLE_STATE), Iterables.getOnlyElement((Iterable)criteria.getLifeCycleStates())));
            } else {
                predicates.add(entity.get(LIFE_CYCLE_STATE).in((Collection)criteria.getLifeCycleStates()));
            }
        }
        if (entityClass.isAssignableFrom(ChainResultsSummaryImpl.class) && criteria.getSpecsResultsFlag().isPresent()) {
            predicates.add(cb.equal((Expression)entity.get("specsResult"), criteria.getSpecsResultsFlag().get()));
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getAgentIds())) {
            if (criteria.getAgentIds().size() > 1000) {
                log.warn("Agent id list truncated to {} from {}", (Object)1000, (Object)criteria.getAgentIds().size());
            }
            predicates.add(entity.get(BUILD_AGENT_ID).in(this.limitInArgumentList(criteria.getAgentIds())));
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getPlanKeys())) {
            if (criteria.getPlanKeys().size() == 1) {
                predicates.add(cb.equal((Expression)entity.get(PLAN_KEY), Iterables.getOnlyElement((Iterable)criteria.getPlanKeys())));
            } else {
                if (criteria.getPlanKeys().size() > 1000) {
                    log.warn("Plan key list truncated to {} from {}", (Object)1000, (Object)criteria.getPlanKeys().size());
                }
                predicates.add(entity.get(PLAN_KEY).in(this.limitInArgumentList(criteria.getPlanKeys())));
            }
        }
        if (criteria.getDateFrom() != null && criteria.getDateTo() != null) {
            predicates.add(cb.between((Expression)entity.get("buildDate"), (Comparable)criteria.getDateFrom(), (Comparable)criteria.getDateTo()));
        } else if (criteria.getDateFrom() != null) {
            predicates.add(cb.greaterThanOrEqualTo((Expression)entity.get("buildDate"), (Comparable)criteria.getDateFrom()));
        } else if (criteria.getDateTo() != null) {
            predicates.add(cb.lessThanOrEqualTo((Expression)entity.get("buildDate"), (Comparable)criteria.getDateTo()));
        }
        if (criteria.getCompletedAfter() != null && criteria.getCompletedBefore() != null) {
            predicates.add(cb.between((Expression)entity.get(BUILD_COMPLETED_DATE), (Comparable)criteria.getCompletedAfter(), (Comparable)criteria.getCompletedBefore()));
        } else if (criteria.getCompletedAfter() != null) {
            predicates.add(cb.greaterThanOrEqualTo((Expression)entity.get(BUILD_COMPLETED_DATE), (Comparable)criteria.getCompletedAfter()));
        } else if (criteria.getCompletedBefore() != null) {
            predicates.add(cb.lessThanOrEqualTo((Expression)entity.get(BUILD_COMPLETED_DATE), (Comparable)criteria.getCompletedBefore()));
        }
        predicates.add(cb.equal((Expression)entity.get(MARKED_FOR_DELETION), (Object)false));
        return predicates;
    }

    private <T> List<T> limitInArgumentList(@NotNull List<T> list) {
        return list.size() > 1000 ? list.subList(0, 1000) : list;
    }

    @NotNull
    public <T extends ResultsSummary> List<T> findResultsSummaries(@NotNull ResultsSummaryCriteria criteria) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> this.createCriteria(session, criteria).setCacheable(false).list());
    }

    public <T extends ResultsSummary> List<T> findByAuthors(Collection<ExtendedAuthor> authors, Class<T> resultClass, int maxResults) {
        if (CollectionUtils.isEmpty(authors)) {
            return Collections.emptyList();
        }
        if (resultClass.isAssignableFrom(ChainResultsSummary.class) && resultClass.isAssignableFrom(BuildResultsSummary.class)) {
            throw new IllegalArgumentException("you can search for plan results or job results but not both");
        }
        List authorIds = authors.stream().map(BambooIdProvider::getId).distinct().collect(Collectors.toList());
        Class<T> entityClass = this.getEntityClassForResultType(resultClass);
        Session session = this.getSessionFactory().getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(resultClass);
        Root entity = q.from(entityClass);
        Join join = BuildResultsSummary.class.isAssignableFrom(entityClass) ? entity.join("relevantChangesets") : entity.join("repositoryChangesets");
        Join commitJoin = join.join("commits");
        Join authorJoin = commitJoin.join("author");
        q.select((Selection)entity).where(new Predicate[]{entity.get(LIFE_CYCLE_STATE).in((Collection)LifeCycleState.FINAL_STATES), cb.equal((Expression)entity.get("specsResult"), (Object)false), authorJoin.get("id").in(this.limitInArgumentList(authorIds))}).orderBy(new Order[]{cb.desc((Expression)entity.get("buildDate"))}).distinct(true);
        Query query = session.createQuery(q);
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
        return query.list();
    }

    public int moveResultSummaries(@NotNull PlanKey oldPlanKey, @NotNull PlanKey newPlanKey) {
        return (Integer)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("moveResultSummaries").setParameter("oldPlanKey", (Object)oldPlanKey.getKey()).setParameter("newPlanKey", (Object)newPlanKey.getKey()).executeUpdate());
    }

    public long countResultSummaries(@NotNull ResultsSummaryCriteria criteria) {
        ResultsSummaryCriteria criteriaWithoutSort = criteria.clone();
        criteriaWithoutSort.setSorted(false);
        return (Long)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria hibernateCriteria = session.createCriteria(this.resultsSummaryDiscriminatorRegistry.getConcreteType(criteriaWithoutSort.getResultSummaryClass())).add(Restrictions.in((String)DISCRIMINATOR, this.resultsSummaryDiscriminatorRegistry.getDiscriminatorsForType(criteriaWithoutSort.getResultSummaryClass())));
            return (Long)ResultsSummaryCriteriaConverter.convert(hibernateCriteria, criteriaWithoutSort).setProjection((Projection)Projections.countDistinct((String)"id")).uniqueResult();
        });
    }

    @NotNull
    public <T extends ResultsSummary> List<T> findResultSummariesForExpiry(final @NotNull ExpiryCriteria expiryCriteria) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                Class<? extends AbstractResultsSummary> resultClass = BuildResultsSummaryHibernateDao.this.resultsSummaryDiscriminatorRegistry.getConcreteType(expiryCriteria.getResultsSummaryClass());
                HashMap<String, Object> params = new HashMap<String, Object>();
                StringBuilder whereQueryBuilder = new StringBuilder(" where brs.planKey = :planKey ").append(" and brs.lifeCycleState in (:lifeCycleStates) ");
                params.put(BuildResultsSummaryHibernateDao.PLAN_KEY, expiryCriteria.getPlanKey().getKey());
                params.put("lifeCycleStates", LifeCycleState.lifeCycleStatesToStringCollection((Collection)LifeCycleState.FINAL_STATES));
                if (expiryCriteria.getMaxBuildNumber() != null) {
                    whereQueryBuilder.append(" and brs.buildNumber <= :buildNumber ");
                    params.put(BuildResultsSummaryHibernateDao.BUILD_NUMBER, expiryCriteria.getMaxBuildNumber());
                }
                if (expiryCriteria.getMaxBuildCompletedDate() != null) {
                    if (expiryCriteria.getMinBuildNumberToKeep() != null) {
                        whereQueryBuilder.append(" and (brs.buildNumber < :minBuildNumber or brs.buildCompletedDate is null or brs.buildCompletedDate <= :buildCompletedDate) ");
                        params.put("minBuildNumber", expiryCriteria.getMinBuildNumberToKeep());
                    } else {
                        whereQueryBuilder.append(" and (brs.buildCompletedDate is null or brs.buildCompletedDate <= :buildCompletedDate) ");
                    }
                    params.put(BuildResultsSummaryHibernateDao.BUILD_COMPLETED_DATE, expiryCriteria.getMaxBuildCompletedDate());
                } else if (expiryCriteria.getMinBuildNumberToKeep() != null) {
                    whereQueryBuilder.append(" and brs.buildNumber < :minBuildNumber ");
                    params.put("minBuildNumber", expiryCriteria.getMinBuildNumberToKeep());
                }
                if (!expiryCriteria.getLabelsToExclude().isEmpty()) {
                    String labelsQuery = " and not exists (from %s labelling  join labelling.label label  where label.name in (:labelNames) and labelling.buildResultsSummary.id = brs.id) ";
                    whereQueryBuilder.append(String.format(" and not exists (from %s labelling  join labelling.label label  where label.name in (:labelNames) and labelling.buildResultsSummary.id = brs.id) ", LabellingImpl.class.getCanonicalName()));
                    params.put("labelNames", expiryCriteria.getLabelsToExclude());
                    if (ResultSummaryClassHelper.isChainResultClass(resultClass)) {
                        String subResultsLabelsQuery = " and not exists (from %s labelling  join labelling.label label  where label.name in (:labelNames)  and labelling.buildResultsSummary.id in (select jobResult1.id  from brs.stageResults stageResult  join stageResult.buildResults jobResult1)) ";
                        whereQueryBuilder.append(String.format(" and not exists (from %s labelling  join labelling.label label  where label.name in (:labelNames)  and labelling.buildResultsSummary.id in (select jobResult1.id  from brs.stageResults stageResult  join stageResult.buildResults jobResult1)) ", LabellingImpl.class.getCanonicalName()));
                    }
                }
                String requireArtifactLinkJoin = "";
                String distinct = "";
                if (expiryCriteria.getMaxIgnoredLogSize() != null || expiryCriteria.isRequireArtifactLinks()) {
                    ArrayList<Object> disjunction = new ArrayList<Object>();
                    if (expiryCriteria.getMaxIgnoredLogSize() != null) {
                        disjunction.add(" brs.logSize is null ");
                        disjunction.add(" brs.logSize > :maxIgnoredLogSize ");
                        params.put("maxIgnoredLogSize", expiryCriteria.getMaxIgnoredLogSize());
                    }
                    if (expiryCriteria.isRequireArtifactLinks()) {
                        String artlink = DefaultArtifactLink.class.getCanonicalName();
                        disjunction.add(" exists (from " + artlink + " al where al.buildResultsSummary.id = brs.id) ");
                        if (ResultSummaryClassHelper.isChainResultClass(resultClass)) {
                            requireArtifactLinkJoin = "left join brs.stageResults stageResult left join stageResult.buildResults jobResult2 left join jobResult2.artifactLinks artlink ";
                            disjunction.add("artlink.buildResultsSummary.id is not null");
                            distinct = "distinct";
                        }
                    }
                    whereQueryBuilder.append(" and (").append(Joiner.on((String)" or ").join(disjunction)).append(") ");
                }
                String queryString = "select " + distinct + " brs from " + resultClass.getCanonicalName() + " as brs " + requireArtifactLinkJoin + whereQueryBuilder;
                log.trace("Executing Hibernate query: {}", (Object)queryString);
                Query query = session.createQuery(queryString);
                HibernateDaoUtils.bindQueryParameters(query, params);
                query.setMaxResults(expiryCriteria.getMaxResults());
                Stopwatch stopwatch = Stopwatch.createStarted();
                List list = query.list();
                BambooLog4j2Utils.logOperationTime((Logger)log, (Stopwatch)stopwatch, (int)10, (int)20, (int)30, () -> String.format("Execution of [%s]", queryString));
                return list;
            }
        });
    }

    @NotNull
    public List<PlanKey> findJobKeysFromExistingChainResults(@NotNull PlanKey chainKey) {
        if (PlanKeys.isJobKey((PlanKey)chainKey)) {
            return Collections.emptyList();
        }
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("findAllJobKeysFromChainResults").setParameter("chainKey", (Object)chainKey.getKey()).list());
    }

    public int removeResultsSummariesForPlan(@NotNull PlanKey planKey, @NotNull List<PlanKey> affectedJobKeys) {
        for (PlanKey jobKey : affectedJobKeys) {
            log.debug("Deleting results with jobKey {}", (Object)jobKey);
            this.removeResultsSummaries(new PlanKeyResultDeletionSQLAdapter(jobKey));
        }
        return this.removeResultsSummaries(new PlanKeyResultDeletionSQLAdapter(planKey));
    }

    public int removeResultsSummariesForPlan(@NotNull PlanKey planKey) {
        List<PlanKey> keysOfJobsFromResults = this.findJobKeysFromExistingChainResults(planKey);
        return this.removeResultsSummariesForPlan(planKey, keysOfJobsFromResults);
    }

    private int deleteUserCommitsForResultSummaries(DeletionSQLAdapter deletionSQLAdapter) {
        int deletedEntities = 0;
        String resultSummaryWhereCondition = deletionSQLAdapter.getResultSummaryDeleteWhenCondition();
        String resultSummaryInCondition = deletionSQLAdapter.getResultSummaryInCondition();
        String SQL_DELETE_COMMIT_FILES = "delete from COMMIT_FILES  where COMMIT_ID in   (select COMMIT_ID from USER_COMMIT where REPOSITORY_CHANGESET_ID in     (select REPOSITORY_CHANGESET_ID from REPOSITORY_CHANGESET where BUILDRESULTSUMMARY_ID in       (" + resultSummaryInCondition + ")     )   )";
        String MYSQL_DELETE_COMMIT_FILES = "delete from COMMIT_FILES       using COMMIT_FILES  inner join USER_COMMIT on USER_COMMIT.COMMIT_ID = COMMIT_FILES.COMMIT_ID  inner join REPOSITORY_CHANGESET on REPOSITORY_CHANGESET.REPOSITORY_CHANGESET_ID = USER_COMMIT.REPOSITORY_CHANGESET_ID  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = REPOSITORY_CHANGESET.BUILDRESULTSUMMARY_ID       where " + resultSummaryWhereCondition;
        String SQL_DELETE_USER_COMMITS = "delete from USER_COMMIT  where REPOSITORY_CHANGESET_ID in   (select REPOSITORY_CHANGESET_ID from REPOSITORY_CHANGESET where BUILDRESULTSUMMARY_ID in     (" + resultSummaryInCondition + ")   )";
        String MYSQL_DELETE_USER_COMMITS = "delete from USER_COMMIT       using USER_COMMIT  inner join REPOSITORY_CHANGESET on REPOSITORY_CHANGESET.REPOSITORY_CHANGESET_ID = USER_COMMIT.REPOSITORY_CHANGESET_ID  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = REPOSITORY_CHANGESET.BUILDRESULTSUMMARY_ID       where " + resultSummaryWhereCondition;
        if (this.dbmsBeanRef.get().getDatabaseType() == DatabaseType.MYSQL) {
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(MYSQL_DELETE_COMMIT_FILES, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(MYSQL_DELETE_USER_COMMITS, 1, deletionSQLAdapter);
        } else {
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_COMMIT_FILES, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_USER_COMMITS, 1, deletionSQLAdapter);
        }
        return deletedEntities;
    }

    private int deleteArtifactLinksForResultSummaries(DeletionSQLAdapter deletionSQLAdapter) {
        int deletedEntities = 0;
        String resultSummaryWhereCondition = deletionSQLAdapter.getResultSummaryDeleteWhenCondition();
        String resultSummaryInCondition = deletionSQLAdapter.getResultSummaryInCondition();
        String SQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_ART_LINK = "delete from BRS_CONSUMED_SUBSCRIPTION  where ARTIFACT_LINK_ID in   (select ARTIFACT_LINK_ID from BRS_ARTIFACT_LINK     where BUILDRESULTSUMMARY_ID in        (" + resultSummaryInCondition + "))";
        String SQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_PRODUCER = "delete from BRS_CONSUMED_SUBSCRIPTION  where ARTIFACT_LINK_ID in   (select ARTIFACT_LINK_ID from BRS_ARTIFACT_LINK     where PRODUCERJOBRESULT_ID in        (" + resultSummaryInCondition + "))";
        String SQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_CONSUMER = "delete from BRS_CONSUMED_SUBSCRIPTION  where CONSUMER_RESULTSUMMARY_ID in  (" + resultSummaryInCondition + ")";
        String MYSQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_ARTIFACT_LINK_RESULT_SUMMARY = "delete from BRS_CONSUMED_SUBSCRIPTION       using BRS_CONSUMED_SUBSCRIPTION  inner join BRS_ARTIFACT_LINK on BRS_ARTIFACT_LINK.ARTIFACT_LINK_ID = BRS_CONSUMED_SUBSCRIPTION.ARTIFACT_LINK_ID  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = BRS_ARTIFACT_LINK.BUILDRESULTSUMMARY_ID       where " + resultSummaryWhereCondition;
        String MYSQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_ARTIFACT_LINK_PRODUCER_JOB = "delete from BRS_CONSUMED_SUBSCRIPTION       using BRS_CONSUMED_SUBSCRIPTION  inner join BRS_ARTIFACT_LINK on BRS_ARTIFACT_LINK.ARTIFACT_LINK_ID = BRS_CONSUMED_SUBSCRIPTION.ARTIFACT_LINK_ID  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = BRS_ARTIFACT_LINK.PRODUCERJOBRESULT_ID       where " + resultSummaryWhereCondition;
        String MYSQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_CONSUMER = "delete from BRS_CONSUMED_SUBSCRIPTION       using BRS_CONSUMED_SUBSCRIPTION  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = BRS_CONSUMED_SUBSCRIPTION.CONSUMER_RESULTSUMMARY_ID       where " + resultSummaryWhereCondition;
        String SQL_DELETE_ARTIFACT_LINKS_BY_RESULT = "delete from BRS_ARTIFACT_LINK  where BUILDRESULTSUMMARY_ID in   (" + resultSummaryInCondition + ") ";
        String SQL_DELETE_ARTIFACT_LINKS_BY_PRODUCER = "delete from BRS_ARTIFACT_LINK  where PRODUCERJOBRESULT_ID in   (" + resultSummaryInCondition + ") ";
        String MYSQL_DELETE_ARTIFACT_LINKS_1 = "delete from BRS_ARTIFACT_LINK       using BRS_ARTIFACT_LINK  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = BRS_ARTIFACT_LINK.BUILDRESULTSUMMARY_ID       where " + resultSummaryWhereCondition;
        String MYSQL_DELETE_ARTIFACT_LINKS_BY_PRODUCER_JOB = "delete from BRS_ARTIFACT_LINK       using BRS_ARTIFACT_LINK  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = BRS_ARTIFACT_LINK.PRODUCERJOBRESULT_ID       where " + resultSummaryWhereCondition;
        if (this.dbmsBeanRef.get().getDatabaseType() == DatabaseType.MYSQL) {
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(MYSQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_ARTIFACT_LINK_RESULT_SUMMARY, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(MYSQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_ARTIFACT_LINK_PRODUCER_JOB, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(MYSQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_CONSUMER, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(MYSQL_DELETE_ARTIFACT_LINKS_1, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(MYSQL_DELETE_ARTIFACT_LINKS_BY_PRODUCER_JOB, 1, deletionSQLAdapter);
        } else {
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_ART_LINK, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_PRODUCER, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_CONSUMED_SUBSCRIPTIONS_BY_CONSUMER, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_ARTIFACT_LINKS_BY_RESULT, 1, deletionSQLAdapter);
            deletedEntities += this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_ARTIFACT_LINKS_BY_PRODUCER, 1, deletionSQLAdapter);
        }
        return deletedEntities;
    }

    private int deleteFromSimpleRelationToResultSummaries(String tableName, DeletionSQLAdapter deletionSQLAdapter) {
        return this.deleteFromSimpleRelationToResultSummaries(tableName, "BUILDRESULTSUMMARY_ID", deletionSQLAdapter);
    }

    private int deleteFromSimpleRelationToResultSummaries(String tableName, String columnName, DeletionSQLAdapter deletionSQLAdapter) {
        String resultSummaryWhereCondition = deletionSQLAdapter.getResultSummaryDeleteWhenCondition();
        String SQL_DELETE_SIMPLE_RELATION = "delete from %s  where %s in   (select BUILDRESULTSUMMARY_ID from BUILDRESULTSUMMARY where %s ) ";
        String MYSQL_DELETE_SIMPLE_RELATION = "delete from %s       using %s  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = %s.%s       where %s";
        String sqlDeleteSimpleRelation = this.dbmsBeanRef.get().getDatabaseType() == DatabaseType.MYSQL ? String.format("delete from %s       using %s  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = %s.%s       where %s", tableName, tableName, tableName, columnName, resultSummaryWhereCondition) : String.format("delete from %s  where %s in   (select BUILDRESULTSUMMARY_ID from BUILDRESULTSUMMARY where %s ) ", tableName, columnName, resultSummaryWhereCondition);
        return this.removeResultsSummariesForPlanExecuteQuery(sqlDeleteSimpleRelation, 1, deletionSQLAdapter);
    }

    private int deleteStageVariablesForResultSummaries(DeletionSQLAdapter deletionSQLAdapter) {
        String SQL_DELETE_STAGE_VARIABLES = "delete from STAGE_VARIABLE_CONTEXT  where STAGERESULT_ID IN   (select STAGERESULT_ID from CHAIN_STAGE_RESULT where CHAINRESULT_ID in     (" + deletionSQLAdapter.getResultSummaryInCondition() + ")   )";
        String MYSQL_DELETE_STAGE_VARIABLES = "delete from STAGE_VARIABLE_CONTEXT       using STAGE_VARIABLE_CONTEXT  inner join CHAIN_STAGE_RESULT on CHAIN_STAGE_RESULT.STAGERESULT_ID = STAGE_VARIABLE_CONTEXT.STAGERESULT_ID  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = CHAIN_STAGE_RESULT.CHAINRESULT_ID       where " + deletionSQLAdapter.getResultSummaryDeleteWhenCondition();
        if (this.dbmsBeanRef.get().getDatabaseType() == DatabaseType.MYSQL) {
            return this.removeResultsSummariesForPlanExecuteQuery(MYSQL_DELETE_STAGE_VARIABLES, 1, deletionSQLAdapter);
        }
        return this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_STAGE_VARIABLES, 1, deletionSQLAdapter);
    }

    private int removeResultsSummaries(DeletionSQLAdapter deletionSQLAdapter) {
        String resultSummaryWhereCondition = deletionSQLAdapter.getResultSummaryDeleteWhenCondition();
        String[] TABLES_RELATED_BY_BRS_ID = new String[]{"RELEVANT_CHANGESETS", "REPOSITORY_CHANGESET", "BUILDRESULTSUMMARY_LABEL", "BUILDRESULTSUMMARY_CUSTOMDATA", "BRS_LINKEDJIRAISSUES", "VARIABLE_CONTEXT", "VARIABLE_SUBSTITUTION"};
        String SQL_DELETE_BUILD_RESULT_SUMMARIES = "delete from BUILDRESULTSUMMARY where " + resultSummaryWhereCondition + " and BUILD_TYPE <> 'CHAIN'";
        String SQL_DELETE_CHAIN_RESULT_SUMMARIES = "delete from BUILDRESULTSUMMARY where " + resultSummaryWhereCondition + " and BUILD_TYPE = 'CHAIN'";
        this.deleteUserCommitsForResultSummaries(deletionSQLAdapter);
        this.deleteArtifactLinksForResultSummaries(deletionSQLAdapter);
        for (String tableName : TABLES_RELATED_BY_BRS_ID) {
            this.deleteFromSimpleRelationToResultSummaries(tableName, deletionSQLAdapter);
        }
        int deletedBRS = this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_BUILD_RESULT_SUMMARIES, 1, deletionSQLAdapter);
        this.deleteStageVariablesForResultSummaries(deletionSQLAdapter);
        this.deleteFromSimpleRelationToResultSummaries("CHAIN_STAGE_RESULT", "CHAINRESULT_ID", deletionSQLAdapter);
        int deletedCRS = this.removeResultsSummariesForPlanExecuteQuery(SQL_DELETE_CHAIN_RESULT_SUMMARIES, 1, deletionSQLAdapter);
        return deletedBRS + deletedCRS;
    }

    private int removeResultsSummariesForPlanExecuteQuery(final @NotNull String query, final int numberOfParameters, final DeletionSQLAdapter deletionSQLAdapter) {
        final AtomicInteger affectedRows = new AtomicInteger();
        this.bambooTransactionHibernateTemplate.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                affectedRows.set(this.executeQuery(connection));
            }

            private Integer executeQuery(Connection connection) throws SQLException {
                try (PreparedStatement statement = connection.prepareStatement(query);){
                    Integer n;
                    block16: {
                        for (int i = 1; i <= numberOfParameters; ++i) {
                            deletionSQLAdapter.setObjectInStatement(statement, i);
                        }
                        Ticker ignored = Timers.start((String)query);
                        try {
                            n = statement.executeUpdate();
                            if (ignored == null) break block16;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (ignored != null) {
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                String message = "Exception removing " + deletionSQLAdapter.getObjectId() + " running '" + query + "'";
                                log.warn(message, (Throwable)e);
                                throw new RuntimeException(message, e);
                            }
                        }
                        ignored.close();
                    }
                    return n;
                }
            }
        });
        return affectedRows.get();
    }

    public Iterable<PlanKey> findPlanKeysFromAllOrphanedResultSummaries() {
        return (Iterable)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("findPlanKeysFromAllOrphanedResultSummaries").setParameterList("brsTypes", this.resultsSummaryDiscriminatorRegistry.getDiscriminatorsForType(ChainResultsSummary.class)).list());
    }

    public int countBuildResultsSummaries(final @NotNull String planKey) {
        return ((Number)this.getCacheAwareHibernateTemplate().executeWithNativeSession((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("findNumberOfBuildResults").setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey).uniqueResult();
            }
        })).intValue();
    }

    public int countBuildResultsSummaries() {
        return ((Number)this.getCacheAwareHibernateTemplate().executeWithNativeSession((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("countAllBuilds").setParameter(BuildResultsSummaryHibernateDao.MARKED_FOR_DELETION, (Object)false).uniqueResult();
            }
        })).intValue();
    }

    @NotNull
    public List<BuildResultsSummary> findBuildsForImageConfiguration(final String planKey, final ElasticImageConfiguration elasticImage, final @Nullable BuildState buildState, final int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<BuildResultsSummary>>(){

            public List<BuildResultsSummary> doInHibernate(Session session) throws HibernateException {
                Query namedQuery = buildState != null ? session.getNamedQuery("findBuildsForImageConfigurationWithState").setParameter(BuildResultsSummaryHibernateDao.BUILD_STATE, (Object)buildState.toString()) : session.getNamedQuery("findBuildsForImageConfiguration");
                return namedQuery.setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey).setParameter("elasticImageConfig", (Object)elasticImage).setMaxResults(maxResults).list();
            }
        });
    }

    public List<Pair<ArtifactLink, BuildResultsSummary>> findBuildResultsWithArtifacts(final String planKey) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Pair<ArtifactLink, BuildResultsSummary>>>(){

            public List<Pair<ArtifactLink, BuildResultsSummary>> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findBuildResultWithArtifact").setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey).list();
            }
        });
    }

    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetId(final @NotNull String changeSetId, @NotNull Class<T> discriminator) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("selectResultsSummariesByChangesetId").setParameter("changeSetId", Preconditions.checkNotNull((Object)changeSetId)).setParameter(BuildResultsSummaryHibernateDao.MARKED_FOR_DELETION, (Object)false).list();
            }
        });
    }

    public <T extends ResultsSummary> List<T> getResultSummariesByCheckoutChangesetId(final @NotNull String changesetId, final @NotNull Class<T> discriminator) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(discriminator).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.MARKED_FOR_DELETION, (Object)false)).createCriteria("repositoryChangesets").add((Criterion)Restrictions.eq((String)"changesetId", (Object)changesetId)).list();
            }
        });
    }

    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetIdAndRepository(long repositoryId, final @NotNull String changeSetId, @NotNull Class<T> discriminator) {
        List list = (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("selectResultsSummariesByChangesetId").setParameter("changeSetId", Preconditions.checkNotNull((Object)changeSetId)).setParameter(BuildResultsSummaryHibernateDao.MARKED_FOR_DELETION, (Object)false).list();
            }
        });
        return this.filterByRepository(repositoryId, list);
    }

    <T extends ResultsSummary> List<T> filterByRepository(long repositoryId, List<T> list) {
        LinkedHashSet<ResultsSummary> resultSet = new LinkedHashSet<ResultsSummary>();
        for (ResultsSummary summary : list) {
            if (!summary.getRepositoryChangesets().stream().anyMatch(rc -> rc.getRepositoryData().getId() == repositoryId)) continue;
            resultSet.add(summary);
        }
        return new ArrayList(resultSet);
    }

    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetIds(final @NotNull List<String> changeSetIds, @NotNull Class<T> discriminator) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("selectResultsSummariesByChangesetIds").setParameterList("changeSetId", (Collection)changeSetIds).setParameter(BuildResultsSummaryHibernateDao.MARKED_FOR_DELETION, (Object)false).list();
            }
        });
    }

    @NotNull
    public List<ResultsSummary> findBuildResultsSummariesByJiraIssues(@Nullable List<String> issueKeys) {
        if (CollectionUtils.isNotEmpty(issueKeys)) {
            ResultSummarySearchCriteria criteria = new ResultSummarySearchCriteria.Builder().lifeCycleStates(new LifeCycleState[]{LifeCycleState.FINISHED}).build();
            ByJiraIssueResultSearchCriteria jiraCriteria = new ByJiraIssueResultSearchCriteria.Builder().issueKeys(issueKeys).build();
            return this.findByJiraCriteria(jiraCriteria, criteria, ResultsSummary.class, ResultDataRead.LAZY);
        }
        return Collections.emptyList();
    }

    @NotNull
    public List<ResultsSummary> findBuildResultsSummariesByProjectKey(@Nullable String jiraProjectKey) {
        if (jiraProjectKey != null) {
            return this.getCacheAwareHibernateTemplate().findByNamedQueryAndNamedParam("findBuildsForProjectKey", new String[]{"projectKey", MARKED_FOR_DELETION}, new Object[]{jiraProjectKey + "-%", false});
        }
        return Collections.emptyList();
    }

    public void removeResultsSummary(final @NotNull ResultsSummary resultsSummary) {
        if (resultsSummary instanceof ChainResultsSummary) {
            this.deleteAll(new JpaUtils.CriteriaQuery<BuildResultsSummaryImpl, ResultsSummary>(this.getSessionFactory(), BuildResultsSummaryImpl.class, ResultsSummary.class){

                @Override
                public void apply() {
                    this.q.select((Selection)this.entity).where((Expression)this.cb.and((Expression)this.cb.equal((Expression)this.entity.get(BuildResultsSummaryHibernateDao.CHAIN_RESULTS_SUMMARY).get("id"), (Object)resultsSummary.getId()), (Expression)this.cb.isNull((Expression)this.entity.get("stageResultId"))));
                }
            }.getResultList());
        }
        this.delete(resultsSummary);
    }

    public BuildResultsSummary getFirstBuildSummary(final @NotNull PlanKey planKey) {
        return (BuildResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                try {
                    return session.createCriteria(AbstractResultsSummary.class).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey.getKey())).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.LIFE_CYCLE_STATE, (Object)LifeCycleState.FINISHED.getValue())).addOrder(org.hibernate.criterion.Order.asc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(1).uniqueResult();
                }
                catch (HibernateException e) {
                    log.error("Error getting first build result summary for build {}", (Object)planKey.getKey(), (Object)e);
                    return null;
                }
            }
        });
    }

    public <T extends ResultsSummary> T getLastResultSummary(String planKey, Class<T> aClass) {
        return this.getLastResultSummary(planKey, aClass, false);
    }

    public <T extends ResultsSummary> T getLastResultSummary(String planKey, Class<T> aClass, boolean ignoreSpecsResults) {
        return (T)((ResultsSummary)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria firstPartCriteria = this.createCriteria(session, aClass).add((Criterion)Restrictions.eq((String)PLAN_KEY, (Object)planKey)).add(Restrictions.in((String)LIFE_CYCLE_STATE, (Collection)LifeCycleState.FINAL_STATES));
            Object result = (ignoreSpecsResults ? firstPartCriteria.add((Criterion)Restrictions.ne((String)TRIGGER_REASON_KEY, (Object)"com.atlassian.bamboo.plugin.system.triggerReason:RssChangedTriggerReason")) : firstPartCriteria).addOrder(org.hibernate.criterion.Order.desc((String)BUILD_NUMBER)).setMaxResults(1).uniqueResult();
            if (CacheLoadContextSupport.isInCacheLoadContext()) {
                this.initializeForCache((ResultsSummary)result);
            }
            return result;
        }));
    }

    private void initializeForCache(ResultsSummary resultsSummary) throws HibernateException {
        if (resultsSummary == null) {
            return;
        }
        log.trace("CACHE_TRACE initializeForCache");
        Hibernate.initialize((Object)resultsSummary.getCustomBuildData());
        log.trace("CACHE_TRACE changesets");
        for (RepositoryChangeset repositoryChangeset : resultsSummary.getRepositoryChangesets()) {
            Hibernate.initialize((Object)repositoryChangeset.getCommits());
        }
        log.trace("CACHE_TRACE Jira issues");
        Hibernate.initialize((Object)resultsSummary.getJiraIssues());
        log.trace("CACHE_TRACE labellings");
        Hibernate.initialize((Object)resultsSummary.getLabellings());
        log.trace("CACHE_TRACE artifact links");
        Hibernate.initialize((Object)resultsSummary.getArtifactLinks());
        log.trace("CACHE_TRACE subscriptions");
        Hibernate.initialize((Object)resultsSummary.getSubscriptions());
        log.trace("CACHE_TRACE substituted vars");
        Hibernate.initialize((Object)resultsSummary.getSubstitutedVariablesEncrypted());
        log.trace("CACHE_TRACE var context logs");
        Hibernate.initialize((Object)resultsSummary.getVariableContextLogsEncrypted());
        log.trace("CACHE_TRACE /initializeForCache");
    }

    public Integer findFirstBuildNumberAfter(@NotNull String planKey, int buildNumber) {
        return NumberUtils.toInteger((Number)((Number)this.getCacheAwareHibernateTemplate().execute(session -> (Number)session.getNamedQuery("findFirstBuildNumberAfter").setParameter(PLAN_KEY, (Object)planKey).setParameter(BUILD_NUMBER, (Object)buildNumber).setCacheable(true).uniqueResult())));
    }

    public Integer findLastBuildNumberBefore(final @NotNull String planKey, final int buildNumber) {
        return NumberUtils.toInteger((Number)((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("findLastBuildNumberBefore").setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey).setParameter(BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)buildNumber).setCacheable(true).uniqueResult();
            }
        })));
    }

    public long getNumberOfFinishedResults(Plan plan) {
        return this.countBuildResultSummariesInLifeCycleStateForPlan(plan.getPlanKey(), EnumSet.of(LifeCycleState.FINISHED), plan.getClass());
    }

    public long getNumberOfFinalizedResults(@NotNull ImmutablePlan plan) {
        return this.countBuildResultSummariesInLifeCycleStateForPlan(plan.getPlanKey(), LifeCycleState.FINAL_STATES, plan.getClass());
    }

    public long getNumberOfFinalizedResults(@NotNull PlanKey planKey) {
        Class clazz = PlanKeys.isJobKey((PlanKey)planKey) ? ImmutableBuildable.class : ImmutableChain.class;
        return this.countBuildResultSummariesInLifeCycleStateForPlan(planKey, LifeCycleState.FINAL_STATES, clazz);
    }

    @NotNull
    public List<ResultsSummary> getNeighbouringSummaries(Plan plan, int currentBuildNumber) {
        return this.getNeighbouringSummaries((ImmutablePlan)plan, currentBuildNumber, 11);
    }

    @NotNull
    public List<ResultsSummary> getNeighbouringSummaries(final @NotNull ImmutablePlan plan, final int buildNumber, final int maxCount) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                List afterAndCurrentBuild = session.createCriteria(AbstractResultsSummary.class).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)plan.getKey())).add((Criterion)Restrictions.ge((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)buildNumber)).addOrder(org.hibernate.criterion.Order.asc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(Math.max(maxCount - buildNumber + 1, Math.round(maxCount / 2))).list();
                List previousBuilds = session.createCriteria(AbstractResultsSummary.class).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)plan.getKey())).add((Criterion)Restrictions.lt((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)buildNumber)).addOrder(org.hibernate.criterion.Order.desc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(maxCount - afterAndCurrentBuild.size()).list();
                Collections.reverse(previousBuilds);
                return ListUtils.union((List)previousBuilds, (List)afterAndCurrentBuild);
            }
        });
    }

    @NotNull
    public List<ResultsSummary> getBeforeSummaries(final @NotNull ImmutablePlan plan, final int buildNumber, final int maxCount) {
        List results = (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(AbstractResultsSummary.class).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)plan.getKey())).add((Criterion)Restrictions.lt((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)buildNumber)).addOrder(org.hibernate.criterion.Order.desc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(maxCount).list();
            }
        });
        Collections.reverse(results);
        return results;
    }

    @NotNull
    public List<ResultsSummary> getAfterSummaries(final @NotNull ImmutablePlan plan, final int buildNumber, final int maxCount) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(AbstractResultsSummary.class).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)plan.getKey())).add((Criterion)Restrictions.gt((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)buildNumber)).addOrder(org.hibernate.criterion.Order.asc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(maxCount).list();
            }
        });
    }

    @Nullable
    public ResultsSummary getBreakingBuild(final ResultsSummary summary) {
        return (ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(AbstractResultsSummary.class).setCacheable(true).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)summary.getPlanKey().toString())).add((Criterion)Restrictions.le((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)summary.getBuildNumber())).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.LIFE_CYCLE_STATE, (Object)LifeCycleState.FINISHED)).add(Restrictions.in((String)BuildResultsSummaryHibernateDao.DELTA_STATE, EnumSet.of(DeltaState.BROKEN, DeltaState.NONE))).addOrder(org.hibernate.criterion.Order.desc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(1).uniqueResult();
            }
        });
    }

    @Nullable
    public ResultsSummary getFixingBuild(final ResultsSummary summary) {
        return (ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(AbstractResultsSummary.class).setCacheable(true).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)summary.getPlanKey().toString())).add((Criterion)Restrictions.ge((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)summary.getBuildNumber())).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.BUILD_STATE, (Object)BuildState.SUCCESS)).addOrder(org.hibernate.criterion.Order.asc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(1).uniqueResult();
            }
        });
    }

    @NotNull
    public List<LinkedJiraIssue> getJiraIssuesForBuildResults(@NotNull List<ResultsSummary> buildResults) {
        Validate.notEmpty(buildResults, (String)"buildResults list must not be empty", (Object[])new Object[0]);
        return this.getCacheAwareHibernateTemplate().findByNamedQueryAndNamedParam("findJiraIssuesForBuildResults", "buildResults", buildResults);
    }

    @NotNull
    public List<LinkedJiraIssue> getJiraIssuesForPlanKey(@NotNull PlanKey planKey) {
        return this.getCacheAwareHibernateTemplate().findByNamedQueryAndNamedParam("findJiraIssuesForBuild", PLAN_KEY, (Object)planKey.getKey());
    }

    public long scrollVariableSubstitutionForExport(final @NotNull Consumer<VariableSubstitution> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(10, ScrollMode.FORWARD_ONLY){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportVariableSubstitutions");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                VariableSubstitutionImpl variableSubstitution = new VariableSubstitutionImpl();
                variableSubstitution.setId(data.getLong(0).longValue());
                variableSubstitution.setKey(data.getString(1));
                variableSubstitution.setValue(data.getString(2));
                variableSubstitution.setVariableType((VariableType)data.get(3));
                variableSubstitution.setResultSummary((ResultsSummary)HibernateDaoUtils.setId(new BuildResultsSummaryImpl(), data.getLong(4)));
                consumer.accept(variableSubstitution);
                session.evict((Object)variableSubstitution);
            }
        });
    }

    @Nullable
    public <T extends ResultsSummary> T findFirstResultAfter(final @NotNull String planKey, final int buildNumber, final Class<T> aClass) {
        return (T)((ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return BuildResultsSummaryHibernateDao.this.createCriteria(session, aClass).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey)).add((Criterion)Restrictions.gt((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)buildNumber)).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.LIFE_CYCLE_STATE, (Object)LifeCycleState.FINISHED.getValue())).addOrder(org.hibernate.criterion.Order.asc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(1).uniqueResult();
            }
        }));
    }

    @Nullable
    public <T extends ResultsSummary> T findLastResultBefore(final @NotNull String planKey, final int buildNumber, final Class<T> aClass, final boolean includeOnceOffBuilds) {
        return (T)((ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = BuildResultsSummaryHibernateDao.this.createLastResultBeforeCriteria(session, planKey, buildNumber, aClass);
                if (!includeOnceOffBuilds) {
                    criteria.add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.ONCE_OFF, (Object)false));
                }
                return criteria.uniqueResult();
            }
        }));
    }

    public <T extends ResultsSummary> T findLastBuildResultBeforeWithTests(final @NotNull PlanResultKey planResultKey, final @NotNull Class<T> aClass, final boolean includeOnceOffBuilds) {
        return (T)((ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = BuildResultsSummaryHibernateDao.this.createLastResultBeforeCriteria(session, planResultKey.getPlanKey().getKey(), planResultKey.getBuildNumber(), aClass).add((Criterion)Restrictions.gt((String)"testResultsSummary.totalTestCaseCount", (Object)0));
                if (!includeOnceOffBuilds) {
                    criteria.add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.ONCE_OFF, (Object)false));
                }
                return criteria.uniqueResult();
            }
        }));
    }

    public ResultsSummary findFirstBuildResultWithBuildStateAfter(final @NotNull String planKey, final int buildNumber, final @NotNull BuildState buildState) {
        return (ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(AbstractResultsSummary.class).setCacheable(true).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey)).add((Criterion)Restrictions.gt((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)buildNumber)).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.BUILD_STATE, (Object)buildState)).addOrder(org.hibernate.criterion.Order.asc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(1).uniqueResult();
            }
        });
    }

    public ResultsSummary findLastBuildResultWithBuildStateBefore(final @NotNull String planKey, final int buildNumber, final @NotNull BuildState buildState, final boolean includeOnceOffBuilds) {
        return (ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(AbstractResultsSummary.class).setCacheable(true).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey)).add((Criterion)Restrictions.lt((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)buildNumber)).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.BUILD_STATE, (Object)buildState)).addOrder(org.hibernate.criterion.Order.desc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER));
                if (!includeOnceOffBuilds) {
                    criteria.add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.ONCE_OFF, (Object)false));
                }
                return criteria.setMaxResults(1).uniqueResult();
            }
        });
    }

    @Nullable
    public ResultsSummary findFirstBuildResultWithBuildStateBetween(final @NotNull String planKey, final int lowerBuildNumber, final int upperBuildNumber, final @NotNull BuildState buildState) {
        return (ResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(AbstractResultsSummary.class).setCacheable(true).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey)).add(Restrictions.between((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)lowerBuildNumber, (Object)upperBuildNumber)).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.BUILD_STATE, (Object)buildState)).addOrder(org.hibernate.criterion.Order.asc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setMaxResults(1).uniqueResult();
            }
        });
    }

    public long scrollResultSummaries(final @NotNull String buildKey, final @NotNull ResultDataRead dataRead, final @NotNull Consumer<ResultsSummary> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(10, ScrollMode.FORWARD_ONLY){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("scrollBuildResults").setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)buildKey);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                final ResultsSummary summary = (ResultsSummary)data.get(0);
                if (summary != null) {
                    try {
                        if (dataRead == ResultDataRead.EAGER || dataRead == ResultDataRead.FULL) {
                            BuildResultsSummaryHibernateDao.this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

                                public Object doInHibernate(Session session) throws HibernateException {
                                    BuildResultsSummaryHibernateDao.this.initializeLazyProperties(summary);
                                    if (dataRead == ResultDataRead.FULL) {
                                        BuildResultsSummaryHibernateDao.this.initializeCommits(summary);
                                    }
                                    return null;
                                }
                            });
                        }
                        consumer.accept(summary);
                    }
                    finally {
                        BuildResultsSummaryHibernateDao.this.evictResultSummary(session, summary);
                    }
                }
            }
        });
    }

    public ChainStageResult getChainStageResultById(final long id) {
        return (ChainStageResult)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.get(ChainStageResultImpl.class, (Serializable)Long.valueOf(id));
            }
        });
    }

    public <T extends ResultsSummary> List<T> getAllResultSummariesForPlan(@NotNull Plan plan) {
        return this.getResultSummariesForPlan((ImmutablePlan)plan, 0, -1);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlan(final @NotNull ImmutablePlan plan, final int firstResult, final int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(ResultsSummary.class).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)plan.getKey())).addOrder(org.hibernate.criterion.Order.desc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setCacheable(true);
                if (firstResult > 0) {
                    criteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    criteria.setMaxResults(maxResults);
                }
                return criteria.list();
            }
        });
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlanByLifeCycleState(final @NotNull Plan plan, final @NotNull LifeCycleState lifeCycleState, final int firstResult, final int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(ResultsSummary.class).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)plan.getKey())).add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.LIFE_CYCLE_STATE, (Object)lifeCycleState.getValue())).addOrder(org.hibernate.criterion.Order.desc((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER)).setCacheable(true);
                if (firstResult > 0) {
                    criteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    criteria.setMaxResults(maxResults);
                }
                return criteria.list();
            }
        });
    }

    @Nullable
    public ChainResultsSummary getParentResultSummary(final ResultsSummary summary) {
        return (ChainResultsSummary)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findChainResultForResultSummary").setParameter("buildResultsSummary", (Object)summary).setMaxResults(1).uniqueResult();
            }
        });
    }

    @Nullable
    public ChainStageResult getStageForResult(final ResultsSummary summary) {
        return (ChainStageResult)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findStageResultForResultSummary").setParameter("buildResultsSummary", (Object)summary).setMaxResults(1).uniqueResult();
            }
        });
    }

    public List<ResultsSummary> findLatestResultsSummaries() {
        DateTime todaysDate = new DateTime((Object)new Date());
        final DateTime startDate = todaysDate.minusDays(7);
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLatestResultSummaries").setParameterList("planTypes", BuildResultsSummaryHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(TopLevelPlan.class)).setParameter("fromDate", (Object)startDate.toDate()).list();
            }
        });
    }

    public List<ResultsSummary> findLatestFailedResultSummaries() {
        DateTime todaysDate = new DateTime((Object)new Date());
        final DateTime startDate = todaysDate.minusDays(7);
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLatestFailedResultSummaries").setParameterList("planTypes", BuildResultsSummaryHibernateDao.this.planDiscriminatorRegistry.getDiscriminatorsForType(TopLevelPlan.class)).setParameter(BuildResultsSummaryHibernateDao.BUILD_STATE, (Object)BuildState.FAILED.toString()).setParameter("fromDate", (Object)startDate.toDate()).list();
            }
        });
    }

    public List<ChainResultsSummary> findChainResultsWithJobLabelled(final ResultsSummaryCriteria queryCriteria, final List<Label> labels) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(ChainResultsSummaryImpl.class);
                if (queryCriteria.getBuildKey() != null) {
                    criteria.add((Criterion)Restrictions.eq((String)BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)queryCriteria.getBuildKey()));
                }
                if (queryCriteria.getToBuildNumber() > 0) {
                    criteria.add((Criterion)Restrictions.le((String)BuildResultsSummaryHibernateDao.BUILD_NUMBER, (Object)queryCriteria.getToBuildNumber()));
                }
                if (queryCriteria.getToDate() != null) {
                    criteria.add((Criterion)Restrictions.le((String)BuildResultsSummaryHibernateDao.BUILD_COMPLETED_DATE, (Object)queryCriteria.getToDate()));
                }
                criteria.createAlias("stageResults", "sr");
                criteria.createAlias("sr.buildResults", "br");
                criteria.createAlias("br.labellings", "labellings");
                criteria.add(Restrictions.in((String)"labellings.label", (Collection)labels));
                criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
                return criteria.list();
            }
        });
    }

    public <T extends ResultsSummary> T findLastResultSummaryWithState(@NotNull PlanKey planKey, @NotNull BuildState buildState, @NotNull Class<T> aClass) {
        return this.findLastResultSummaryWithState(planKey, buildState, aClass, false);
    }

    @Nullable
    public <T extends ResultsSummary> T findLastResultSummaryWithState(@NotNull PlanKey planKey, @NotNull BuildState buildState, @NotNull Class<T> aClass, boolean ignoreSpecsResults) {
        return (T)((ResultsSummary)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria firstPartCriteria = this.createCriteria(session, aClass).add((Criterion)Restrictions.eq((String)PLAN_KEY, (Object)planKey.getKey())).add((Criterion)Restrictions.eq((String)BUILD_STATE, (Object)buildState.toString()));
            return (ignoreSpecsResults ? firstPartCriteria.add((Criterion)Restrictions.ne((String)TRIGGER_REASON_KEY, (Object)"com.atlassian.bamboo.plugin.system.triggerReason:RssChangedTriggerReason")) : firstPartCriteria).add((Criterion)Restrictions.ne((String)TRIGGER_REASON_KEY, (Object)"com.atlassian.bamboo.plugin.system.triggerReason:RssChangedTriggerReason")).addOrder(org.hibernate.criterion.Order.desc((String)BUILD_NUMBER)).setMaxResults(1).uniqueResult();
        }));
    }

    public int countResultsWithState(final @NotNull PlanKey planKey, final int lowerBuildNumber, final int upperBuildNumber, final @NotNull BuildState buildState) {
        return ((Number)this.getCacheAwareHibernateTemplate().executeWithNativeSession((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("findNumberOfResultsInState").setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey.toString()).setParameter(BuildResultsSummaryHibernateDao.LOWER_BUILD_NUMBER, (Object)lowerBuildNumber).setParameter(BuildResultsSummaryHibernateDao.UPPER_BUILD_NUMBER, (Object)upperBuildNumber).setParameter(BuildResultsSummaryHibernateDao.BUILD_STATE, (Object)buildState.toString()).setCacheable(true).uniqueResult();
            }
        })).intValue();
    }

    public int markResultSummariesForDeletion(final @NotNull PlanKey planKey) {
        final AtomicInteger result = new AtomicInteger();
        this.bambooTransactionHibernateTemplate.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                try (PreparedStatement statement = connection.prepareStatement("update BUILDRESULTSUMMARY set MARKED_FOR_DELETION = ? where BUILD_KEY = ?");){
                    statement.setBoolean(1, true);
                    statement.setString(2, planKey.getKey());
                    int i = statement.executeUpdate();
                    result.set(i);
                }
            }
        });
        return result.get();
    }

    @NotNull
    public List<PlanKey> getPlanKeysSortedByNumberOfFinalizedResultSummaries() {
        List results = (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Object[]>>(){

            public List<Object[]> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("getPlanKeysSortedByNumberOfFinalizedResultSummaries").setParameterList(BuildResultsSummaryHibernateDao.LIFE_CYCLE_STATE, LifeCycleState.lifeCycleStatesToStringCollection((Collection)LifeCycleState.FINAL_STATES)).setCacheable(true).list();
            }
        });
        return results.stream().map(i -> (PlanKey)i[0]).collect(Collectors.toList());
    }

    @Nullable
    public Long calculateQueueDuration(final @NotNull ChainResultsSummary resultsSummary) {
        List results = (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Object[]>>(){

            public List<Object[]> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("getDataForQueueDurationCalculation").setParameter(BuildResultsSummaryHibernateDao.CHAIN_RESULTS_SUMMARY, (Object)resultsSummary).list();
            }
        });
        if (!results.isEmpty()) {
            long maxDuration = 0L;
            for (Object[] result : results) {
                long duration = ((Timestamp)result[0]).getTime() - ((Timestamp)result[1]).getTime();
                maxDuration = Math.max(maxDuration, duration);
            }
            return maxDuration;
        }
        return null;
    }

    @Nullable
    public Long calculateVcsUpdateDuration(final @NotNull ChainResultsSummary resultsSummary) {
        List results = (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Object[]>>(){

            public List<Object[]> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("getDataForVcsUpdateDurationCalculation").setParameter(BuildResultsSummaryHibernateDao.CHAIN_RESULTS_SUMMARY, (Object)resultsSummary).list();
            }
        });
        if (!results.isEmpty()) {
            long maxDuration = 0L;
            for (Object[] result : results) {
                long duration = ((Timestamp)result[0]).getTime() - ((Timestamp)result[1]).getTime();
                maxDuration = Math.max(maxDuration, duration);
            }
            return maxDuration;
        }
        return null;
    }

    private <T extends ResultsSummary> Criteria createCriteria(@NotNull Session session, @NotNull Class<T> aClass) {
        return session.createCriteria(AbstractResultsSummary.class).setCacheable(false).add(Restrictions.in((String)DISCRIMINATOR, this.resultsSummaryDiscriminatorRegistry.getDiscriminatorsForType(aClass)));
    }

    private Criteria createCriteria(@NotNull Session session, @NotNull ResultsSummaryCriteria criteria) {
        Criteria hibernateCriteria = session.createCriteria(this.resultsSummaryDiscriminatorRegistry.getConcreteType(criteria.getResultSummaryClass())).setCacheable(true).add(Restrictions.in((String)DISCRIMINATOR, this.resultsSummaryDiscriminatorRegistry.getDiscriminatorsForType(criteria.getResultSummaryClass())));
        return this.convertCriteria(hibernateCriteria, criteria);
    }

    @NotNull
    Criteria convertCriteria(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        ResultsSummaryCriteriaConverter.convert(hibernateCriteria, criteria);
        return hibernateCriteria;
    }

    private <T extends ResultsSummary> Criteria createLastResultBeforeCriteria(Session session, @NotNull String planKey, int buildNumber, Class<T> aClass) {
        return this.createCriteria(session, aClass).add((Criterion)Restrictions.eq((String)PLAN_KEY, (Object)planKey)).add((Criterion)Restrictions.lt((String)BUILD_NUMBER, (Object)buildNumber)).add((Criterion)Restrictions.eq((String)LIFE_CYCLE_STATE, (Object)LifeCycleState.FINISHED.getValue())).addOrder(org.hibernate.criterion.Order.desc((String)BUILD_NUMBER)).setMaxResults(1).setCacheable(true);
    }

    public void setResultsSummaryDiscriminatorRegistry(ResultsSummaryDiscriminatorRegistry resultsSummaryDiscriminatorRegistry) {
        this.resultsSummaryDiscriminatorRegistry = resultsSummaryDiscriminatorRegistry;
    }

    public void setPlanDiscriminatorRegistry(PlanDiscriminatorRegistry planDiscriminatorRegistry) {
        this.planDiscriminatorRegistry = planDiscriminatorRegistry;
    }

    public List<Integer> findAllBuildResultsNumbers(final PlanKey planKey) {
        return (List)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findAllBuildResultsSummaryNumbersForPlanKey").setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey.getKey()).setCacheable(true).list();
            }
        });
    }

    @NotNull
    public Range<Integer> findBuildResultsNumberRange(final PlanKey planKey) {
        Range result = (Range)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findMinMaxBuildResultsSummaryNumbersForPlanKey").setParameter(BuildResultsSummaryHibernateDao.PLAN_KEY, (Object)planKey.getKey()).uniqueResult();
            }
        });
        if (result.getMinimum() == null) {
            return Range.make((Number)0, (Number)0);
        }
        return result;
    }

    @NotNull
    public List<PlanResultKey> findChainResultsWithFormatVersionLessThan(int formatVersion, int maxResults) {
        return ((List)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("findChainResultsWithFormatVersionLessThan").setParameter("formatVersion", (Object)formatVersion).setMaxResults(maxResults).list())).stream().map(p -> PlanKeys.getPlanResultKey((PlanKey)((PlanKey)p.getFirst()), (int)((Integer)p.getSecond()))).collect(Collectors.toList());
    }

    @NotNull
    public Set<Long> findSpecsStatesIdsReferencedByBuildResultSummaries() {
        return ((List)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("searchCustomDataByKey").setParameter("key", (Object)"specs.source.id").list())).stream().map(Longs::tryParse).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public int findMinimumBuildNumberForNLatest(final @NotNull PlanKey planKey, int n) {
        List buildNumbers = new JpaUtils.CriteriaQuery<ChainResultsSummaryImpl, Integer>(this.getSessionFactory(), ChainResultsSummaryImpl.class, Integer.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity.get(BuildResultsSummaryHibernateDao.BUILD_NUMBER)).where(new Predicate[]{this.cb.equal((Expression)this.entity.get(BuildResultsSummaryHibernateDao.PLAN_KEY), (Object)planKey), this.cb.equal((Expression)this.entity.get("specsResult"), (Object)false)}).orderBy(new Order[]{this.cb.desc((Expression)this.entity.get(BuildResultsSummaryHibernateDao.BUILD_NUMBER))});
            }
        }.getResultList(0, n);
        return (Integer)Iterables.getLast(buildNumbers, (Object)0);
    }

    private <T extends ResultsSummary> Class<? extends T> getEntityClassForResultType(@NotNull Class<T> resultClass) {
        if (ChainResultsSummary.class.isAssignableFrom(resultClass)) {
            return ChainResultsSummaryImpl.class;
        }
        if (BuildResultsSummary.class.isAssignableFrom(resultClass)) {
            return BuildResultsSummaryImpl.class;
        }
        return AbstractResultsSummary.class;
    }
}

