/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.LinkedJiraIssueDao;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class LinkedJiraIssueHibernateDao
extends BambooHibernateObjectDao<LinkedJiraIssue>
implements LinkedJiraIssueDao {
    private static final Logger log = Logger.getLogger(LinkedJiraIssueHibernateDao.class);
    private static final Class<LinkedJiraIssueImpl> PERSISTENT_CLASS = LinkedJiraIssueImpl.class;

    public long scrollJiraIssuesForExport(final @NotNull Consumer<LinkedJiraIssue> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(10, ScrollMode.FORWARD_ONLY){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportJiraIssues");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                LinkedJiraIssueImpl jiraIssue = new LinkedJiraIssueImpl();
                jiraIssue.setId(data.getLong(0).longValue());
                jiraIssue.setIssueKey(data.getString(1));
                jiraIssue.setIssueType((JiraIssueLinkType)data.get(2));
                jiraIssue.setResultsSummary((ResultsSummary)HibernateDaoUtils.setId(new BuildResultsSummaryImpl(), data.getLong(3)));
                consumer.accept(jiraIssue);
                session.evict((Object)jiraIssue);
            }
        });
    }

    public Collection<LinkedJiraIssue> getLinkedJiraIssuesForBuildNumberRange(final @NotNull PlanKey planKey, final int firstBuildNumber, final int lastBuildNumber) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<LinkedJiraIssue>>(){

            @Nullable
            public List<LinkedJiraIssue> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).createAlias("resultsSummary", "resultsSummary").add((Criterion)Restrictions.eq((String)"resultsSummary.planKey", (Object)planKey)).add((Criterion)Restrictions.ge((String)"resultsSummary.buildNumber", (Object)firstBuildNumber)).add((Criterion)Restrictions.le((String)"resultsSummary.buildNumber", (Object)lastBuildNumber)).add((Criterion)Restrictions.eq((String)"resultsSummary.onceOff", (Object)false)).list();
            }
        });
    }
}

