/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.resultsummary.CustomDataRow;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.util.BambooIterablesUtils;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.jetbrains.annotations.NotNull;

public class ResultsSummaryCriteriaConverter {
    private static final Logger log = Logger.getLogger(ResultsSummaryCriteriaConverter.class);
    private static final int RESULTSET_SIZE_HARD_CAP = 10000;

    private ResultsSummaryCriteriaConverter() {
    }

    @NotNull
    public static Criteria convert(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        int maxResults;
        ResultsSummaryCriteriaConverter.modifyHibernateCriteriaForLifeCycleStates(hibernateCriteria, criteria);
        ResultsSummaryCriteriaConverter.modifyHibernateCriteriaForPlanKey(hibernateCriteria, criteria);
        hibernateCriteria.add((Criterion)Restrictions.eq((String)"markedForDeletion", (Object)false));
        if (criteria.getBuildState() != null) {
            hibernateCriteria.add((Criterion)Restrictions.eq((String)"buildState", (Object)criteria.getBuildState()));
        }
        if (criteria.getFromDate() != null) {
            hibernateCriteria.add((Criterion)Restrictions.ge((String)"buildCompletedDate", (Object)criteria.getFromDate()));
        }
        ResultsSummaryCriteriaConverter.modifyHibernateCriteriaForToDate(hibernateCriteria, criteria);
        if (criteria.getFromCreationDate() != null) {
            hibernateCriteria.add((Criterion)Restrictions.ge((String)"creationDate", (Object)criteria.getFromCreationDate()));
        }
        if (criteria.getToCreationDate() != null) {
            hibernateCriteria.add((Criterion)Restrictions.le((String)"creationDate", (Object)criteria.getToCreationDate()));
        }
        if (criteria.getFromBuildNumber() > 0) {
            hibernateCriteria.add((Criterion)Restrictions.ge((String)"buildNumber", (Object)criteria.getFromBuildNumber()));
        }
        if (criteria.getToBuildNumber() > 0) {
            hibernateCriteria.add((Criterion)Restrictions.le((String)"buildNumber", (Object)criteria.getToBuildNumber()));
        }
        if (criteria.getAgentId() != null) {
            hibernateCriteria.add((Criterion)Restrictions.eq((String)"buildAgentId", (Object)criteria.getAgentId()));
        }
        criteria.isContinuable().ifPresent(value -> hibernateCriteria.add((Criterion)Restrictions.eq((String)"continuable", (Object)value)));
        ResultsSummaryCriteriaConverter.modifyHibernateCriteriaForLabels(hibernateCriteria, criteria);
        ResultsSummaryCriteriaConverter.modifyHibernateCriteriaForJiraIssues(hibernateCriteria, criteria);
        ResultsSummaryCriteriaConverter.modifyHibernateCriteriaForBambooSpecs(hibernateCriteria, criteria);
        ResultsSummaryCriteriaConverter.modifyHibernateCriteriaForCustomDataKeys(hibernateCriteria, criteria);
        ResultsSummaryCriteriaConverter.modifyHibernateCriteriaForOnceOff(hibernateCriteria, criteria);
        ResultsSummaryCriteriaConverter.modifyCriteriaForMaxFormatVersion(hibernateCriteria, criteria);
        int n = maxResults = criteria.getMaxRowCount() > 0 ? criteria.getMaxRowCount() : 10000;
        if (maxResults > 10000) {
            log.warn((Object)String.format("Criteria's resultset size limit %d is greater than suggested %d", maxResults, 10000));
        }
        hibernateCriteria.setMaxResults(maxResults);
        hibernateCriteria.setFirstResult(Math.max(criteria.getFirstResult(), 0));
        ResultsSummaryCriteriaConverter.modifyHibernateCriteriaForSort(hibernateCriteria, criteria);
        hibernateCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return hibernateCriteria;
    }

    private static void modifyHibernateCriteriaForPlanKey(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        if (criteria.getBuildKey() != null) {
            hibernateCriteria.add((Criterion)Restrictions.eq((String)"planKey", (Object)criteria.getBuildKey()));
        } else if (BambooIterablesUtils.isNotEmpty((Iterable)criteria.getProjectKeys())) {
            SimpleExpression projectKeyCriterion = null;
            for (String projectKey : criteria.getProjectKeys()) {
                SimpleExpression thisLike = Restrictions.like((String)"planKey", (Object)(projectKey + "-%"));
                if (projectKeyCriterion == null) {
                    projectKeyCriterion = thisLike;
                    continue;
                }
                projectKeyCriterion = Restrictions.or((Criterion)projectKeyCriterion, (Criterion)thisLike);
            }
            hibernateCriteria.add(projectKeyCriterion);
        }
    }

    private static void modifyHibernateCriteriaForToDate(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        Date toDate = criteria.getToDate();
        Boolean toDateIsNull = criteria.getToDateIsNull();
        SimpleExpression toDateCriterion = null;
        if (toDate != null) {
            toDateCriterion = Restrictions.le((String)"buildCompletedDate", (Object)toDate);
        }
        if (toDateIsNull != null) {
            Criterion toDateIsNullCriterion = toDateIsNull != false ? Restrictions.isNull((String)"buildCompletedDate") : Restrictions.isNotNull((String)"buildCompletedDate");
            Object object = toDateCriterion = toDateCriterion != null ? Restrictions.or((Criterion)toDateCriterion, (Criterion)toDateIsNullCriterion) : toDateIsNullCriterion;
        }
        if (toDateCriterion != null) {
            hibernateCriteria.add((Criterion)toDateCriterion);
        }
    }

    private static void modifyHibernateCriteriaForLifeCycleStates(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        if (!CollectionUtils.isEmpty((Collection)criteria.getLifeCycleStates())) {
            if (criteria.getLifeCycleStates().size() == 1) {
                LifeCycleState lifeCycleState = (LifeCycleState)criteria.getLifeCycleStates().iterator().next();
                hibernateCriteria.add((Criterion)Restrictions.eq((String)"lifeCycleState", (Object)lifeCycleState));
            } else {
                hibernateCriteria.add(Restrictions.in((String)"lifeCycleState", (Collection)criteria.getLifeCycleStates()));
            }
        }
    }

    private static void modifyHibernateCriteriaForLabels(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        if (CollectionUtils.isNotEmpty((Collection)criteria.getMatchesLabels())) {
            try {
                hibernateCriteria.createAlias("labellings", "labellings");
                hibernateCriteria.add(Restrictions.in((String)"labellings.label", (Collection)criteria.getMatchesLabels()));
            }
            catch (HibernateException e) {
                log.warn((Object)"Unable to set labellings. Not sure how this could possibly happen.", (Throwable)e);
            }
        }
    }

    private static void modifyHibernateCriteriaForJiraIssues(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        if (CollectionUtils.isNotEmpty((Collection)criteria.getMatchesJiraIssues())) {
            try {
                hibernateCriteria.createAlias("jiraIssues", "jiraIssues");
                hibernateCriteria.add(Restrictions.in((String)"jiraIssues.issueKey", (Collection)criteria.getMatchesJiraIssues()));
            }
            catch (HibernateException e) {
                log.warn((Object)("Unable to set jiraIssues [" + StringUtils.join((Iterable)criteria.getMatchesJiraIssues(), (String)",") + "]. Not sure how this could possibly happen."), (Throwable)e);
            }
        }
    }

    private static void modifyHibernateCriteriaForCustomDataKeys(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        if (CollectionUtils.isNotEmpty((Collection)criteria.getMatchesCustomDataKeys())) {
            try {
                hibernateCriteria.createAlias("customBuildDataRows", "customBuildDataRows");
                hibernateCriteria.add(Restrictions.in((String)"customBuildDataRows.key", (Collection)criteria.getMatchesCustomDataKeys()));
            }
            catch (HibernateException e) {
                log.warn((Object)("Unable to set matchesCustomDataKeys [" + StringUtils.join((Iterable)criteria.getMatchesCustomDataKeys(), (String)",") + "]. Not sure how this could possibly happen."), (Throwable)e);
            }
        }
    }

    private static void modifyHibernateCriteriaForBambooSpecs(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        if (criteria.isSpecsResult().isPresent()) {
            hibernateCriteria.add((Criterion)Restrictions.eq((String)"specsResult", criteria.isSpecsResult().get()));
        }
    }

    private static void modifyHibernateCriteriaForOnceOff(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        if (criteria.isOnceOff().isPresent()) {
            hibernateCriteria.add((Criterion)Restrictions.eq((String)"onceOff", criteria.isOnceOff().get()));
        }
    }

    private static void modifyCriteriaForMaxFormatVersion(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        if (criteria.getMaxFormatVersion().isPresent()) {
            hibernateCriteria.add((Criterion)Restrictions.le((String)"formatVersion", criteria.getMaxFormatVersion().get()));
        }
    }

    private static void modifyHibernateCriteriaForSort(@NotNull Criteria hibernateCriteria, @NotNull ResultsSummaryCriteria criteria) {
        if (criteria.isSorted()) {
            String sortField = StringUtils.defaultString((String)criteria.getSortField(), (String)"buildCompletedDate");
            if (criteria.isSortAscending()) {
                hibernateCriteria.addOrder(Order.asc((String)sortField));
            } else {
                hibernateCriteria.addOrder(Order.desc((String)sortField));
            }
        }
    }

    private static DetachedCriteria customBuildDataCriteria(Collection<String> keys) {
        return DetachedCriteria.forClass(CustomDataRow.class, (String)"customBuildDataRows").add((Criterion)Property.forName((String)"resultsSummary").eqProperty("this.id")).add(Property.forName((String)"key").in(keys)).setProjection((Projection)Projections.property((String)"customBuildDataRows.id"));
    }
}

