/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseDao;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl;
import com.atlassian.bamboo.resultsummary.tests.TestDeltaState;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate5.HibernateCallback;

public class TestCaseHibernateDao
extends BambooHibernateObjectDao<TestCase>
implements TestCaseDao {
    private static final Logger log = Logger.getLogger(TestCaseHibernateDao.class);
    private static final Class<? extends TestCase> PERSISTENT_CLASS = TestCaseImpl.class;
    @Lazy
    @Autowired
    private DbmsBean dbmsBean;

    public TestCase findById(long testCaseId) {
        return this.findById(testCaseId, PERSISTENT_CLASS);
    }

    @NotNull
    public List<TestCase> getLongestRunningTestCasesForPlan(@NotNull ImmutablePlan plan) {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)plan, ImmutableJob.class);
        if (job != null) {
            long masterJobId = this.getMasterJobId(job);
            return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("findLongestRunningTestCasesForPlan").setParameter("planId", (Object)job.getParent().getId()).setParameter("masterJobId", (Object)masterJobId).setMaxResults(10).list());
        }
        return Collections.emptyList();
    }

    @NotNull
    public List<TestCase> getQuarantinedTestCasesForChain(@NotNull ImmutableChain chain) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add(Restrictions.isNotNull((String)"quarantineStatistics.quarantineDate")).createAlias("testClass", "myTestClass").add((Criterion)Restrictions.eq((String)"myTestClass.plan.id", (Object)chain.getId())).list());
    }

    public int countCurrentlyQuarantinedTests(ImmutableChain chain) {
        Number number = (Number)this.getHibernateTemplate().execute(session -> (Number)session.getNamedQuery("countQuarantinedTestCasesForPlan").setParameter("planId", (Object)chain.getId()).setCacheable(true).uniqueResult());
        return number != null ? number.intValue() : 0;
    }

    @NotNull
    public List<TestCase> getQuarantinedTestCasesForJob(@NotNull ImmutableJob job) {
        long masterJobId = this.getMasterJobId(job);
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add(Restrictions.isNotNull((String)"quarantineStatistics.quarantineDate")).createAlias("testClass", "myTestClass").add((Criterion)Restrictions.eq((String)"myTestClass.plan.id", (Object)job.getParent().getId())).add((Criterion)Restrictions.eq((String)"myTestClass.masterJobId", (Object)masterJobId)).list());
    }

    private long getMasterJobId(@NotNull ImmutableJob job) {
        return job.getDatabaseId().orElseGet(() -> (Long)job.getMasterIdIfExists().orElseThrow(() -> new IllegalStateException("job has neither DB or id nor master")));
    }

    @NotNull
    public List<Pair<Long, Long>> getMostFailingTestCasesForPlan(@NotNull ImmutablePlan plan) {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)plan, ImmutableJob.class);
        if (job != null) {
            long masterJobId = this.getMasterJobId(job);
            return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("findMostFailingTestCaseIdsForPlan").setParameter("planId", (Object)job.getParent().getId()).setParameter("masterJobId", (Object)masterJobId).setMaxResults(10).list());
        }
        return Collections.emptyList();
    }

    @NotNull
    public List<Pair<Long, Long>> getMostFailingTestCasesForBuildResults(@NotNull List<BuildResultsSummary> buildResults) {
        Preconditions.checkArgument((!buildResults.isEmpty() ? 1 : 0) != 0, (Object)"buildResults list must not be empty");
        return (List)this.getHibernateTemplate().execute(session -> {
            Query query = session.getNamedQuery("findMostFailingTestCaseIdsForPlanFiltered").setMaxResults(10);
            return HibernateDaoUtils.listQuery(this.dbmsBean, query, "buildResults", buildResults);
        });
    }

    @NotNull
    public List<Pair<Long, Float>> getLongestToFixTestCasesForPlan(@NotNull ImmutablePlan plan) {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)plan, ImmutableJob.class);
        if (job != null) {
            long masterJobId = this.getMasterJobId(job);
            return (List)this.getCacheAwareHibernateTemplate().execute(session -> session.getNamedQuery("findLongestToFixTestCaseIdsForPlan").setParameter("planId", (Object)job.getParent().getId()).setParameter("masterJobId", (Object)masterJobId).setMaxResults(10).list());
        }
        return Collections.emptyList();
    }

    @NotNull
    public List<Pair<Long, Float>> getLongestToFixTestCasesForBuildResults(@NotNull List<BuildResultsSummary> buildResults) {
        Preconditions.checkArgument((!buildResults.isEmpty() ? 1 : 0) != 0, (Object)"buildResults list must not be empty");
        return (List)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findLongestToFixTestCaseIdsForPlanFiltered").setParameterList("buildResults", (Collection)buildResults).setMaxResults(10).list());
    }

    @NotNull
    public List<Pair<Long, Long>> getTopBrokenTests(final @NotNull PlanKey planKey, final BuildResultsFilter filter) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Pair<Long, Long>>>(){

            public List<Pair<Long, Long>> doInHibernate(Session session) throws HibernateException {
                Query query;
                String BASE_QUERY = "SELECT new com.atlassian.bamboo.utils.Pair(tcr.testCase.id, count(*)) \nFROM   TestCaseResultImpl tcr \nJOIN   tcr.testClassResult as classResult \nJOIN   classResult.buildResultsSummary as b \nWHERE  b.planKey LIKE :planKeyPrefix \n%s AND    tcr.deltaState IN (:deltaStates) \nGROUP BY tcr.testCase.id, b.planKey \nORDER BY 2 desc ";
                if (filter.getFromDate() != null) {
                    Date fromDate = filter.getFromDate();
                    query = session.createQuery(String.format("SELECT new com.atlassian.bamboo.utils.Pair(tcr.testCase.id, count(*)) \nFROM   TestCaseResultImpl tcr \nJOIN   tcr.testClassResult as classResult \nJOIN   classResult.buildResultsSummary as b \nWHERE  b.planKey LIKE :planKeyPrefix \n%s AND    tcr.deltaState IN (:deltaStates) \nGROUP BY tcr.testCase.id, b.planKey \nORDER BY 2 desc ", "AND b.buildCompletedDate > :fromDate")).setParameter("fromDate", (Object)fromDate);
                } else if (filter.getFromBuildNumber(planKey) > 0) {
                    int lastNumberOfBuilds = filter.getFromBuildNumber(planKey);
                    query = session.createQuery(String.format("SELECT new com.atlassian.bamboo.utils.Pair(tcr.testCase.id, count(*)) \nFROM   TestCaseResultImpl tcr \nJOIN   tcr.testClassResult as classResult \nJOIN   classResult.buildResultsSummary as b \nWHERE  b.planKey LIKE :planKeyPrefix \n%s AND    tcr.deltaState IN (:deltaStates) \nGROUP BY tcr.testCase.id, b.planKey \nORDER BY 2 desc ", "AND b.buildNumber > :lastNumberOfBuilds")).setParameter("lastNumberOfBuilds", (Object)lastNumberOfBuilds);
                } else {
                    query = session.createQuery(String.format("SELECT new com.atlassian.bamboo.utils.Pair(tcr.testCase.id, count(*)) \nFROM   TestCaseResultImpl tcr \nJOIN   tcr.testClassResult as classResult \nJOIN   classResult.buildResultsSummary as b \nWHERE  b.planKey LIKE :planKeyPrefix \n%s AND    tcr.deltaState IN (:deltaStates) \nGROUP BY tcr.testCase.id, b.planKey \nORDER BY 2 desc ", ""));
                }
                return query.setParameter("planKeyPrefix", (Object)(planKey.getKey() + "-%")).setParameterList("deltaStates", new Object[]{TestDeltaState.BROKEN}).setMaxResults(10).setCacheable(true).list();
            }
        });
    }

    public long countTestCases() {
        return this.executeCountQuery("countTestCases");
    }

    public long scrollTestCasesForExport(final @NotNull Consumer<TestCase> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportTestCases");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                TestCaseImpl testCase = new TestCaseImpl();
                testCase.setId(data.getLong(0).longValue());
                testCase.setTestClass((TestClass)HibernateDaoUtils.setId(new TestClassImpl(), data.getLong(1)));
                testCase.setName(data.getString(2));
                testCase.setNumberOfSuccessRuns(data.getInteger(3).intValue());
                testCase.setNumberOfFailedRuns(data.getInteger(4).intValue());
                testCase.setAverageDuration(data.getLong(5).longValue());
                testCase.setFirstRanBuildNumber(data.getInteger(6).intValue());
                testCase.setLastRanBuildNumber(data.getInteger(7).intValue());
                testCase.setLastRecordedBuildNumber(data.getInteger(8).intValue());
                testCase.setLinkedJiraIssueKey(data.getString(9));
                if (data.getString(10) != null && data.getDate(11) != null) {
                    testCase.setQuarantineStatistics(data.getString(10), data.getDate(11), null);
                }
                consumer.accept(testCase);
            }
        });
    }

    @NotNull
    public List<TestCase> getAllTestCasesWithExpiredQuarantine() {
        return (List)this.getHibernateTemplate().execute(session -> Collections.emptyList());
    }
}

