/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultDao;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestDeltaState;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public class TestCaseResultHibernateDao
extends BambooHibernateObjectDao<TestCaseResult>
implements TestCaseResultDao {
    private static final Class<? extends TestCaseResult> PERSISTENT_CLASS = TestCaseResultImpl.class;

    public TestCaseResult findById(long id) {
        return this.findById(id, PERSISTENT_CLASS);
    }

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultByState(final ResultsSummary summary, final TestState state, final int firstResult, final int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestsForBuildResultByState").setCacheable(true).setParameter("summary", (Object)summary).setParameter("state", (Object)state);
                if (firstResult > 0) {
                    query.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    query.setMaxResults(maxResults);
                }
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultByDeltaState(final ResultsSummary summary, final TestDeltaState deltaState, final int firstResult, final int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestsForBuildResultByDeltaState").setCacheable(true).setParameter("summary", (Object)summary).setParameter("quarantined", (Object)false).setParameter("deltaState", (Object)deltaState);
                if (firstResult > 0) {
                    query.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    query.setMaxResults(maxResults);
                }
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResult> getTestsForChainResultByDeltaStates(final ChainResultsSummary summary, final TestDeltaState[] deltaStates, final int firstResult, final int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestsForChainResultByDeltaStates").setCacheable(true).setParameter("chainResult", (Object)summary).setParameter("quarantined", (Object)false).setParameterList("deltaStates", (Object[])deltaStates);
                if (firstResult > 0) {
                    query.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    query.setMaxResults(maxResults);
                }
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResult> getTestsForChainResultByState(final @NotNull ChainResultsSummary summary, final @NotNull TestState testState, final int firstResult, final int maxResults) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestsForChainResultByState").setCacheable(true).setParameter("chainResult", (Object)summary).setParameter("state", (Object)testState);
                if (firstResult > 0) {
                    query.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    query.setMaxResults(maxResults);
                }
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResult> getQuarantinedTestCasesForChainResult(final @NotNull ChainResultsSummary chainResultsSummary) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findQuarantinedTestsForChainResult").setParameter("chainResult", (Object)chainResultsSummary).setParameter("quarantined", (Object)true);
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultSummary(final BuildResultsSummary summary) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestsForBuildResult").setParameter("summary", (Object)summary);
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResult> getQuarantinedTestCasesForBuildResult(final @NotNull BuildResultsSummary buildResultsSummary) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findQuarantinedTestsForBuildResult").setParameter("buildResult", (Object)buildResultsSummary).setParameter("quarantined", (Object)true);
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResultStatisticsProvider> getResultStatisticsForTestCase(final @NotNull TestCase testCase) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResultStatisticsProvider>>(){

            public List<TestCaseResultStatisticsProvider> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestStatisticsForTestCase").setParameter("testCase", (Object)testCase);
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResultStatisticsProvider> getResultStatisticsForTestCaseAndBuilds(final @NotNull TestCase testCase, final @NotNull List<BuildResultsSummary> buildResults) {
        Preconditions.checkArgument((!buildResults.isEmpty() ? 1 : 0) != 0, (Object)"buildResults list must not be empty");
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResultStatisticsProvider>>(){

            public List<TestCaseResultStatisticsProvider> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestStatisticsForTestCaseInBuildResults").setParameter("testCase", (Object)testCase).setParameterList("buildResults", (Collection)buildResults);
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResult> getTestCaseResultsForTestCase(final @NotNull TestCase testCase) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestsForTestCase").setParameter("testCase", (Object)testCase);
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResult> getTestCaseResultsForTestCaseAndBuilds(final @NotNull TestCase testCase, final @NotNull List<BuildResultsSummary> buildResults) {
        Preconditions.checkArgument((!buildResults.isEmpty() ? 1 : 0) != 0, (Object)"buildResults list must not be empty");
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestsForTestCaseInBuildResults").setParameter("testCase", (Object)testCase).setParameterList("buildResults", (Collection)buildResults);
                return query.list();
            }
        });
    }

    @NotNull
    public List<Pair<TestCaseResult, Integer>> getLastNFailingResultsForTestCase(final @NotNull TestCase testCase, final int number) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Pair<TestCaseResult, Integer>>>(){

            public List<Pair<TestCaseResult, Integer>> doInHibernate(Session session) throws HibernateException {
                Query namedQuery = session.getNamedQuery("findLastFailingResultsForTestCase");
                namedQuery.setParameter("testCase", (Object)testCase);
                namedQuery.setMaxResults(number);
                return namedQuery.list();
            }
        });
    }

    @NotNull
    public List<Pair<TestCaseResult, Integer>> getLastNFailingResultsForTestCaseAndBuildResults(final @NotNull TestCase testCase, final @NotNull List<BuildResultsSummary> buildResults, final int number) {
        Preconditions.checkArgument((!buildResults.isEmpty() ? 1 : 0) != 0, (Object)"buildResults list must not be empty");
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Pair<TestCaseResult, Integer>>>(){

            public List<Pair<TestCaseResult, Integer>> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findLastFailingResultsForTestCaseFiltered").setParameter("testCase", (Object)testCase).setParameterList("buildResults", (Collection)buildResults).setMaxResults(number);
                return query.list();
            }
        });
    }

    @NotNull
    public List<TestCaseResult> getTestCaseResults(final TestCase testCase, final long buildNumber) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TestCaseResult>>(){

            public List<TestCaseResult> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("findTestResultForTestCaseAndBuildNumber").setParameter("testCase", (Object)testCase).setParameter("buildNumber", (Object)((int)buildNumber));
                return query.list();
            }
        });
    }

    public BuildResultsSummary getSucceedingSinceBuildResultSummary(final TestCase testCase) {
        return (BuildResultsSummary)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findBuildsWithTestDeltaState").setParameter("testCase", (Object)testCase).setParameter("deltaState", (Object)TestDeltaState.FIXED).setCacheable(true).setMaxResults(1).uniqueResult();
            }
        });
    }

    public long countTestCaseResults() {
        return this.executeCountQuery("countTestCaseResults");
    }

    public long countTestCaseResultErrors() {
        return this.executeCountQuery("countTestCaseResultErrors");
    }

    public long scrollTestCaseResultsForExport(final @NotNull Consumer<TestCaseResult> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportTestCaseResults");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                TestCaseResultImpl testCaseResult = new TestCaseResultImpl();
                testCaseResult.setId(data.getLong(0).longValue());
                testCaseResult.setTestCase((TestCase)HibernateDaoUtils.setId(new TestCaseImpl(), data.getLong(1)));
                testCaseResult.setTestClassResult((TestClassResult)HibernateDaoUtils.setId(new TestClassResultImpl(), data.getLong(2)));
                testCaseResult.setDuration(data.getLong(3).longValue());
                testCaseResult.setState((TestState)data.get(4));
                testCaseResult.setDeltaState((TestDeltaState)data.get(5));
                testCaseResult.setFailingSince(data.getInteger(6).intValue());
                testCaseResult.setQuarantined(data.getBoolean(7).booleanValue());
                consumer.accept(testCaseResult);
            }
        });
    }

    public long scrollTestCaseResultErrorsForExport(final @NotNull Consumer<TestCaseResultError> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportTestCaseResultErrors");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                TestCaseResultErrorImpl testCaseResultError = new TestCaseResultErrorImpl();
                testCaseResultError.setId(data.getLong(0).longValue());
                testCaseResultError.setTestCaseResult((TestCaseResult)HibernateDaoUtils.setId(new TestCaseResultImpl(), data.getLong(1)));
                testCaseResultError.setContent(data.getString(2));
                consumer.accept(testCaseResultError);
            }
        });
    }
}

