/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeyUserType;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.DeletionSQLAdapter;
import com.atlassian.bamboo.resultsummary.PlanKeyResultDeletionSQLAdapter;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestResultsDao;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public class TestResultsHibernateDao
extends BambooHibernateObjectDao<TestClassResult>
implements TestResultsDao {
    private static final Logger log = Logger.getLogger(TestResultsHibernateDao.class);
    private static final Class<? extends TestClassResult> PERSISTENT_CLASS = TestClassResultImpl.class;
    private static final String SQL_DELETE_TEST_CLASS_RESULT = "DELETE FROM TEST_CLASS_RESULT WHERE BUILDRESULTSUMMARY_ID IN (   SELECT BUILDRESULTSUMMARY_ID     FROM BUILDRESULTSUMMARY    WHERE %s )";
    private static final String MYSQL_DELETE_TEST_CLASS_RESULT = "delete from TEST_CLASS_RESULT       using TEST_CLASS_RESULT  inner join BUILDRESULTSUMMARY on BUILDRESULTSUMMARY.BUILDRESULTSUMMARY_ID = TEST_CLASS_RESULT.BUILDRESULTSUMMARY_ID       where %s";
    private final Supplier<DbmsBean> dbmsBeanRef = ComponentAccessor.DBMS_BEAN;
    private final BambooTransactionHibernateTemplate transactionTemplate;

    public TestResultsHibernateDao(BambooTransactionHibernateTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public TestClassResult findById(long testClassId) {
        return this.findById(testClassId, PERSISTENT_CLASS);
    }

    @NotNull
    public Collection<? extends TestClassResult> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    public long countTestClassResults() {
        return this.executeCountQuery("countTestClassResults");
    }

    public long countTestClassResults(final @NotNull PlanKey planKey) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("countTestClassResultsForPlan").setParameter("planKey", (Object)planKey, PlanKeyUserType.getHibernateType(session)).uniqueResult();
            }
        })).longValue();
    }

    public long scrollTestClassResultsForExport(final @NotNull Consumer<TestClassResult> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportTestClassResults");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                TestClassResultImpl testClassResult = new TestClassResultImpl();
                testClassResult.setId(data.getLong(0).longValue());
                testClassResult.setTestClass((TestClass)HibernateDaoUtils.setId(new TestClassImpl(), data.getLong(1)));
                testClassResult.setBuildResultsSummary((BuildResultsSummary)HibernateDaoUtils.setId(new BuildResultsSummaryImpl(), data.getLong(2)));
                testClassResult.setDuration(data.getLong(3).longValue());
                testClassResult.setFailedTestCount(data.getInteger(4).intValue());
                testClassResult.setSuccessfulTestCount(data.getInteger(5).intValue());
                consumer.accept(testClassResult);
            }
        });
    }

    @NotNull
    public List<TestClassResult> getTestClassResults(@NotNull PlanResultKey planResultKey) {
        return Objects.requireNonNull((List)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findTestClassResultsForBuildResult").setParameter("planKey", (Object)planResultKey.getPlanKey(), PlanKeyUserType.getHibernateType(session)).setParameter("buildNumber", (Object)planResultKey.getBuildNumber()).list()));
    }

    public int removeTestClassResultsByPlan(@NotNull PlanKey planKey) {
        return this.removeTestClassResults(new PlanKeyResultDeletionSQLAdapter(planKey));
    }

    private int removeTestClassResults(final DeletionSQLAdapter deletionSQLAdapter) {
        final String whereCondition = deletionSQLAdapter.getResultSummaryDeleteWhenCondition();
        final AtomicInteger numberOfDeletedTestClassResult = new AtomicInteger();
        this.transactionTemplate.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                String query = TestResultsHibernateDao.this.dbmsBeanRef.get().getDatabaseType() == DatabaseType.MYSQL ? TestResultsHibernateDao.MYSQL_DELETE_TEST_CLASS_RESULT : TestResultsHibernateDao.SQL_DELETE_TEST_CLASS_RESULT;
                try (PreparedStatement statement = connection.prepareStatement(String.format(query, whereCondition));){
                    numberOfDeletedTestClassResult.set(this.executeUpdate(statement));
                }
            }

            private int executeUpdate(PreparedStatement statement) {
                AtomicInteger updateResult = new AtomicInteger();
                TestResultsHibernateDao.this.transactionTemplate.doWork(c -> {
                    deletionSQLAdapter.setObjectInStatement(statement, 1);
                    updateResult.set(statement.executeUpdate());
                });
                return updateResult.get();
            }
        });
        return numberOfDeletedTestClassResult.get();
    }
}

