/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl_;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl_;
import com.atlassian.bamboo.resultsummary.tests.TestsDao;
import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import com.atlassian.bamboo.utils.collection.multimap.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class TestsHibernateDao
extends BambooHibernateObjectDao<TestClass>
implements TestsDao {
    private static final Logger log = Logger.getLogger(TestsHibernateDao.class);
    private static final Class<? extends TestClass> PERSISTENT_CLASS = TestClassImpl.class;
    private static final String PROPERTY_TEST_CLASS_NAME = "name";

    @Nullable
    public TestClass findById(long testClassId) {
        return this.findById(testClassId, PERSISTENT_CLASS);
    }

    @NotNull
    public Collection<? extends TestClass> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    @NotNull
    public Multimap<TestClass, TestCase> getTestClassesMapForPlan(Plan plan, long masterJobId, int cutoffBuildNumber) {
        Session session = this.getCacheAwareHibernateTemplate().getSessionFactory().getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(TestCaseImpl.class);
        Root testCase = q.from(TestCaseImpl.class);
        Join testClassJoin = testCase.join("testClass");
        q.select((Selection)testCase).distinct(true);
        JpaUtils.Accumulator accumulator = JpaUtils.accumulator();
        if (cutoffBuildNumber > 1) {
            accumulator.add(cb.ge((Expression)testCase.get(TestCaseImpl_.lastRanBuildNumber), (Number)cutoffBuildNumber));
        }
        accumulator.add(cb.equal((Expression)testClassJoin.get(TestClassImpl_.masterJobId), (Object)masterJobId));
        accumulator.add(cb.equal((Expression)testClassJoin.get("plan").get("id"), (Object)plan.getId()));
        accumulator.toWhere(q);
        List result = session.createQuery(q).list();
        SetMultimap multimap = SetMultimap.create();
        result.forEach(arg_0 -> TestsHibernateDao.lambda$getTestClassesMapForPlan$0((Multimap)multimap, arg_0));
        return multimap;
    }

    @NotNull
    public ScrollableResults scrollThroughTestClassesForPlan(final Plan plan) {
        return (ScrollableResults)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<ScrollableResults>(){

            public ScrollableResults doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"plan.id", (Object)plan.getId())).setFetchMode("testCases", FetchMode.JOIN).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).setFetchMode("plan", FetchMode.SELECT).addOrder(Order.asc((String)TestsHibernateDao.PROPERTY_TEST_CLASS_NAME)).scroll(ScrollMode.FORWARD_ONLY);
            }
        });
    }

    public long countTestClasses() {
        return this.executeCountQuery("countTestClasses");
    }

    public long scrollTestClassesForExport(final @NotNull Consumer<TestClass> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportTestClasses");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                TestClassImpl testClass = new TestClassImpl();
                testClass.setId(data.getLong(0).longValue());
                DefaultChain plan = new DefaultChain();
                plan.setPlanKey((PlanKey)data.get(1));
                testClass.setPlan((Plan)plan);
                testClass.setName(data.getString(2));
                testClass.setMasterJobId(data.getLong(3).longValue());
                consumer.accept(testClass);
            }
        });
    }

    private static /* synthetic */ void lambda$getTestClassesMapForPlan$0(Multimap multimap, TestCaseImpl tc) {
        multimap.put((Object)tc.getTestClass(), (Object)tc);
    }
}

