/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.vcs;

import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.resultsummary.vcs.RelevantChangeset;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetDao;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.Work;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class RepositoryChangesetHibernateDao
extends BambooHibernateObjectDao<RepositoryChangeset>
implements RepositoryChangesetDao {
    private static final Class<? extends RepositoryChangeset> PERSISTENT_CLASS = RepositoryChangesetImpl.class;
    private static final String RELEVANT_CHANGESETS_TABLE_NAME = "RELEVANT_CHANGESETS";
    private static Ordering<RepositoryChangeset> byBuildNumberDesc = new Ordering<RepositoryChangeset>(){

        public int compare(RepositoryChangeset left, RepositoryChangeset right) {
            return Integer.compare(right.getResultsSummary().getBuildNumber(), left.getResultsSummary().getBuildNumber());
        }
    };

    @Nullable
    public RepositoryChangeset findById(long id) {
        return super.findById(id, PERSISTENT_CLASS);
    }

    public long scrollChangesetsForExport(Consumer<RepositoryChangeset> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute(new NamedQueryScroller<RepositoryChangeset>("exportRepositoryChangesets", consumer));
    }

    public long scrollRelevantChangesetsForExport(final Consumer<RelevantChangeset> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Long>(){

            public Long doInHibernate(Session session) throws HibernateException {
                final AtomicLong result = new AtomicLong();
                session.doWork(new Work(){

                    public void execute(Connection connection) throws SQLException {
                        try (Statement statement = connection.createStatement();
                             ResultSet resultSet = statement.executeQuery("select * from RELEVANT_CHANGESETS");){
                            while (resultSet.next()) {
                                long brsId = resultSet.getLong("BUILDRESULTSUMMARY_ID");
                                long repoChangesetId = resultSet.getLong("REPOSITORY_CHANGESET_ID");
                                consumer.accept(new RelevantChangeset(brsId, repoChangesetId));
                                result.incrementAndGet();
                            }
                        }
                    }
                });
                return result.get();
            }
        });
    }

    public void saveRelevantChangesets(final List<RelevantChangeset> relevantChangesets) {
        if (relevantChangesets.isEmpty()) {
            return;
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public Object doInHibernate(Session session) throws HibernateException {
                String sqlQuery = "insert into RELEVANT_CHANGESETS values(?, ?)";
                session.doWork(new Work(){

                    public void execute(Connection connection) throws SQLException {
                        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into RELEVANT_CHANGESETS values(?, ?)");){
                            for (RelevantChangeset relevantChangeset : relevantChangesets) {
                                preparedStatement.setLong(1, relevantChangeset.brsId);
                                preparedStatement.setLong(2, relevantChangeset.repositoryChangesetId);
                                preparedStatement.addBatch();
                            }
                            preparedStatement.executeBatch();
                        }
                    }
                });
                return null;
            }
        });
    }

    public void removeRepositoryChangesets(final RepositoryDataEntity repositoryDataEntity) {
        this.deleteAll((Collection)this.getHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public Collection<RepositoryChangeset> doInHibernate(Session session) throws HibernateException {
                List repositoryChangesets = session.createCriteria(PERSISTENT_CLASS).createAlias("repositoryData", "rd").add((Criterion)Restrictions.eq((String)"rd.id", (Object)repositoryDataEntity.getId())).list();
                return repositoryChangesets;
            }
        }));
    }

    public List<RepositoryChangeset> getChangesetsForBuildNumberRange(final @NotNull PlanKey planKey, final int firstBuildNumber, final int lastBuildNumber) {
        return byBuildNumberDesc.sortedCopy((Iterable)Sets.newHashSet((Iterable)((List)this.getHibernateTemplate().execute(new HibernateCallback(){

            @Nullable
            public List<RepositoryChangeset> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).createAlias("resultsSummary", "resultsSummary").add((Criterion)Restrictions.eq((String)"resultsSummary.planKey", (Object)planKey)).add((Criterion)Restrictions.ge((String)"resultsSummary.buildNumber", (Object)firstBuildNumber)).add((Criterion)Restrictions.le((String)"resultsSummary.buildNumber", (Object)lastBuildNumber)).add((Criterion)Restrictions.eq((String)"resultsSummary.onceOff", (Object)false)).setFetchMode("commits", FetchMode.JOIN).setFetchMode("repositoryData", FetchMode.JOIN).list();
            }
        }))));
    }

    private static class NamedQueryScroller<T>
    extends ScrollHibernateCallback {
        private final String queryName;
        private final Consumer<T> consumer;

        private NamedQueryScroller(String queryName, Consumer<T> consumer) {
            super(10, ScrollMode.FORWARD_ONLY);
            this.queryName = queryName;
            this.consumer = consumer;
        }

        @Override
        @NotNull
        public Query configureQuery(@NotNull Session session) throws HibernateException {
            return session.getNamedQuery(this.queryName);
        }

        @Override
        public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
            Object commit = data.get(0);
            this.consumer.accept(commit);
            session.evict(commit);
        }
    }
}

