/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.hibernate.callbacks.BulkUpdate;
import com.atlassian.bamboo.security.BambooRememberMeTokenDao;
import com.atlassian.bamboo.security.RememberMeTokenImpl;
import com.atlassian.seraph.service.rememberme.RememberMeToken;
import com.atlassian.seraph.spi.rememberme.RememberMeConfiguration;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class BambooRememberMeTokenDaoImpl
extends HibernateDaoSupport
implements BambooRememberMeTokenDao {
    private final RememberMeConfiguration rememberMeConfiguration;

    public BambooRememberMeTokenDaoImpl(RememberMeConfiguration rememberMeConfiguration) {
        this.rememberMeConfiguration = rememberMeConfiguration;
    }

    @Nullable
    @Contract(value="null -> null")
    public RememberMeToken findById(@Nullable Long tokenId) {
        return tokenId == null ? null : (RememberMeToken)this.getHibernateTemplate().get(RememberMeTokenImpl.class, (Serializable)tokenId);
    }

    public List<RememberMeToken> findForUserName(@Nullable String username) {
        if (username == null) {
            return Collections.emptyList();
        }
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(RememberMeTokenImpl.class).add((Criterion)Property.forName((String)"userName").eq((Object)username)).list());
    }

    public void remove(@Nullable Long tokenId) {
        if (tokenId == null) {
            return;
        }
        this.getHibernateTemplate().execute((HibernateCallback)BulkUpdate.forNamedQuery("deleteRememberMeTokenByTokenId", "tokenId", tokenId));
    }

    public void removeAll() {
        this.getHibernateTemplate().execute((HibernateCallback)BulkUpdate.forNamedQuery("deleteAllRememberMeTokens", new Object[0]));
    }

    public void removeAllForUser(@Nullable String username) {
        if (username != null) {
            this.getHibernateTemplate().execute((HibernateCallback)BulkUpdate.forNamedQuery("deleteRememberMeTokenByUsername", "username", username));
        }
    }

    @Nullable
    public RememberMeToken save(@Nullable RememberMeToken token) {
        if (token == null) {
            return null;
        }
        RememberMeTokenImpl rememberMeToken = new RememberMeTokenImpl(token);
        this.getHibernateTemplate().save((Object)rememberMeToken);
        return rememberMeToken;
    }

    public int removeExpiredTokens() {
        long oldestAcceptableTime = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(this.rememberMeConfiguration.getCookieMaxAgeInSeconds());
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)BulkUpdate.forNamedQuery("deleteExpiredRememberMeTokens", "createdTime", oldestAcceptableTime));
    }
}

