/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence.BambooHibernateObjectDao;
import com.atlassian.bamboo.persistence.BambooSessionFactoryUtils;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.security.acegi.acls.AclDao;
import com.atlassian.bamboo.security.acegi.acls.AclEntriesStatistics;
import com.atlassian.bamboo.security.acegi.acls.AclStatisticsDao;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateAccessControlEntryImpl;
import com.atlassian.bamboo.security.acegi.acls.HibernateAclImpl;
import com.atlassian.bamboo.security.acegi.acls.objectidentity.ObjectIdentityUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Selection;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.OwnershipAcl;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.Sid;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;

public class AclHibernateDao
extends BambooHibernateObjectDao
implements AclDao,
AclStatisticsDao {
    public Class<?> getPersistentClass() {
        return HibernateAclImpl.class;
    }

    public List<ObjectIdentity> findAclObjectWithParent(ObjectIdentity objectIdentity) {
        return (List)this.getHibernateTemplate().execute(session -> {
            Query queryObject = session.getNamedQuery("findAclObjectWithParent").setParameter("identifier", (Object)objectIdentity.getIdentifier()).setParameter("javaType", (Object)objectIdentity.getJavaType().getName()).setCacheable(true);
            BambooSessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)this.getSessionFactory());
            return queryObject.list();
        });
    }

    public Map<ObjectIdentity, MutableAcl> findAcls(ObjectIdentity objectIdentity) {
        ListOrderedMap result = new ListOrderedMap();
        List acls = (List)this.getHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(HibernateAclImpl.class).add((Criterion)Restrictions.eq((String)"objectIdentity", (Object)objectIdentity)).setFetchMode("aces", FetchMode.JOIN).setCacheable(true);
            return criteria.list();
        });
        for (HibernateAclImpl acl : acls) {
            result.put(new AclDao.ObjectIdentityDto(acl.getObjectIdentity()), acl);
        }
        return result;
    }

    public Map<ObjectIdentity, MutableAcl> findAllAcls() {
        HashMap<ObjectIdentity, MutableAcl> result = new HashMap<ObjectIdentity, MutableAcl>();
        new JpaUtils.CriteriaQuery<HibernateAclImpl, MutableAcl>(this.getSessionFactory(), HibernateAclImpl.class, MutableAcl.class){

            @Override
            public void apply() {
                this.entity.fetch("aces", JoinType.LEFT);
                this.q.select((Selection)this.entity);
            }
        }.getResultList().forEach(acl -> result.put(acl.getObjectIdentity(), (MutableAcl)acl));
        return result;
    }

    public MutableAcl findAcl(long objectId) {
        return (MutableAcl)this.getHibernateTemplate().execute(session -> (HibernateAclImpl)session.createCriteria(HibernateAclImpl.class).add((Criterion)Restrictions.eq((String)"objectIdentity.identifier", (Object)objectId)).setFetchMode("aces", FetchMode.JOIN).setCacheable(true).uniqueResult());
    }

    public List<AccessControlEntry> findAcesForSid(Sid sid) {
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(HibernateAccessControlEntryImpl.class).add((Criterion)Restrictions.eq((String)"sid", (Object)sid)).setFetchMode("aces", FetchMode.JOIN).setCacheable(true).list());
    }

    public boolean hasAcesForSid(Sid sid) {
        return (Boolean)this.getHibernateTemplate().execute(session -> session.createCriteria(HibernateAccessControlEntryImpl.class).add((Criterion)Restrictions.eq((String)"sid", (Object)sid)).setFetchMode("aces", FetchMode.JOIN).setMaxResults(1).setCacheable(true).uniqueResult() != null);
    }

    public List<OwnershipAcl> findAclsOwnedBySid(Sid sid) {
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(HibernateAclImpl.class).add((Criterion)Restrictions.eq((String)"owner", (Object)sid)).setFetchMode("aces", FetchMode.JOIN).setCacheable(true).list());
    }

    public void save(Acl acl) {
        this.getHibernateTemplate().saveOrUpdate((Object)acl);
    }

    public void remove(Acl acl) {
        this.getHibernateTemplate().delete((Object)acl);
    }

    public void removeForIdentity(final ObjectIdentity objectIdentity) {
        new JpaUtils.CriteriaDelete<HibernateAclImpl>(this.getSessionFactory(), HibernateAclImpl.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get("objectIdentity"), (Object)objectIdentity));
            }
        }.executeUpdate();
    }

    public AclEntriesStatistics countAclEntriesByJavaType() {
        List countAclEntriesByJavaType = (List)this.getHibernateTemplate().execute(session -> {
            Query queryObject = session.getNamedQuery("countAclEntriesByJavaType").setCacheable(true);
            BambooSessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)this.getSessionFactory());
            return queryObject.list();
        });
        AclEntriesStatistics aclEntriesStatistics = new AclEntriesStatistics();
        for (Object[] result : countAclEntriesByJavaType) {
            String clazz = result[0].toString();
            int index = clazz.lastIndexOf(46) + 1;
            String clazzSimpleName = clazz.length() - index < 0 ? clazz : clazz.substring(index);
            BambooPermission permission = (BambooPermission)result[1];
            Long count = (Long)result[2];
            aclEntriesStatistics.put(clazzSimpleName, permission, count);
        }
        return aclEntriesStatistics;
    }

    public long countNonEmptyProjectsWithProjectPlanPermissions() {
        return ((Optional)this.getHibernateTemplate().execute(session -> {
            Class<ProjectPlanPermissions> aclClass = ObjectIdentityUtils.getAclClassForEntityClass(ProjectPlanPermissions.class).orElse(ProjectPlanPermissions.class);
            Query queryObject = session.getNamedQuery("countNonEmptyProjectsWithAcls").setParameter("javaType", (Object)aclClass.getCanonicalName()).setCacheable(true);
            BambooSessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)this.getSessionFactory());
            return queryObject.uniqueResultOptional();
        })).orElse(0L);
    }
}

