/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.trustedapplications;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.security.trustedapplications.BambooCurrentApplication;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplication;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplicationDao;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplicationImpl;
import com.atlassian.bamboo.security.trustedapplications.KeyUtils;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import java.security.Key;
import java.security.KeyPair;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateCallback;

public class BambooTrustedApplicationsHibernateDao
extends BambooHibernateObjectDao<BambooTrustedApplication>
implements BambooTrustedApplicationDao {
    private static final String APPLICATION_ID = "applicationId";
    private static final String BANDANA_PRIVATE_KEY = "trustedapps.private-key";
    private static final String BANDANA_PUBLIC_KEY = "trustedapps.public-key";
    private static final String BANDANA_APPLICATION_ID = "trustedapps.application-id";
    @Autowired
    private BandanaManager bandanaManager;
    @Autowired
    private EncryptionProvider encryptionProvider;
    private Triple<String, String, String> trustedAppData = null;
    private BambooCurrentApplication bambooCurrentApplication;

    public BambooTrustedApplication findByApplicationId(final String applicationId) {
        return (BambooTrustedApplication)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<BambooTrustedApplication>(){

            public BambooTrustedApplication doInHibernate(Session session) throws HibernateException {
                return (BambooTrustedApplication)session.createCriteria(BambooTrustedApplicationImpl.class).add((Criterion)Restrictions.eq((String)BambooTrustedApplicationsHibernateDao.APPLICATION_ID, (Object)applicationId)).uniqueResult();
            }
        });
    }

    @Override
    public void save(@NotNull BambooCurrentApplication currentApp) {
        this.bandanaPutWithBackup(BANDANA_APPLICATION_ID, currentApp.getApplicationId());
        this.bandanaPutWithBackup(BANDANA_PUBLIC_KEY, KeyUtils.encode((Key)currentApp.getKeyPair().getPublic()));
        this.bandanaPutWithBackup(BANDANA_PRIVATE_KEY, KeyUtils.encode((Key)currentApp.getKeyPair().getPrivate()));
    }

    @Nullable
    public BambooCurrentApplication getCurrentApplication() {
        String bandanaAppId = this.bandanaGet(BANDANA_APPLICATION_ID);
        String bandanaPublicKey = this.bandanaGet(BANDANA_PUBLIC_KEY);
        String bandanaPrivateKey = this.bandanaGet(BANDANA_PRIVATE_KEY);
        if (StringUtils.isBlank((CharSequence)bandanaAppId) || StringUtils.isBlank((CharSequence)bandanaPublicKey) || StringUtils.isBlank((CharSequence)bandanaPrivateKey)) {
            return null;
        }
        return this.getCurrentApplication(bandanaAppId, bandanaPublicKey, bandanaPrivateKey);
    }

    private synchronized BambooCurrentApplication getCurrentApplication(String bandanaAppId, String bandanaPublicKey, String bandanaPrivateKey) {
        if (!(this.trustedAppData != null && ((String)this.trustedAppData.getLeft()).equals(bandanaAppId) && ((String)this.trustedAppData.getMiddle()).equals(bandanaPublicKey) && ((String)this.trustedAppData.getRight()).equals(bandanaPrivateKey))) {
            this.trustedAppData = Triple.of((Object)bandanaAppId, (Object)bandanaPublicKey, (Object)bandanaPrivateKey);
            KeyPair keyPair = KeyUtils.decodeKeyPair((EncryptionProvider)this.encryptionProvider, (String)bandanaPublicKey, (String)bandanaPrivateKey);
            this.bambooCurrentApplication = new BambooCurrentApplication(bandanaAppId, keyPair);
        }
        return this.bambooCurrentApplication;
    }

    private void bandanaPutWithBackup(@NotNull String key, @NotNull String value) {
        String oldValue = this.bandanaGet(key);
        if (oldValue != null) {
            this.bandanaPut(key + "_bak", oldValue);
        }
        this.bandanaPut(key, value);
    }

    private void bandanaPut(@NotNull String key, @NotNull Object value) {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key, value);
    }

    @Nullable
    private String bandanaGet(@NotNull String key) {
        return (String)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
    }
}

