/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl_;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSource;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSourceDto;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSourceDtoImpl;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSourceImpl_;
import com.atlassian.bamboo.specs.BambooSpecsSourceDao;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class BambooSpecsSourceDaoImpl
implements BambooSpecsSourceDao {
    @Autowired
    private SessionFactory sessionFactory;

    public void saveOrUpdate(VcsBambooSpecsSource vcsBambooSpecsSource) {
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)vcsBambooSpecsSource);
    }

    public Optional<VcsBambooSpecsSource> findById(long specsSourceId) {
        return Optional.ofNullable((VcsBambooSpecsSource)this.sessionFactory.getCurrentSession().find(VcsBambooSpecsSourceImpl.class, (Object)specsSourceId));
    }

    public void scrollVcsBambooSpecsSourceForExport(Consumer<VcsBambooSpecsSource> consumer) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaQuery query = session.getCriteriaBuilder().createQuery(VcsBambooSpecsSourceImpl.class);
        Root model = query.from(VcsBambooSpecsSourceImpl.class);
        query.select((Selection)model);
        try (Stream stream = this.sessionFactory.getCurrentSession().createQuery(query).stream();){
            stream.forEach(consumer);
        }
    }

    public void scrollPlanVcsBambooSpecsSourceForExport(Consumer<PlanVcsBambooSpecsSourceDto> consumer) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaQuery query = session.getCriteriaBuilder().createQuery(PlanVcsBambooSpecsSourceDtoImpl.class);
        Root model = query.from(PlanVcsBambooSpecsSourceDtoImpl.class);
        query.select((Selection)model);
        try (Stream stream = this.sessionFactory.getCurrentSession().createQuery(query).stream();){
            stream.forEach(consumer);
        }
    }

    public Optional<VcsBambooSpecsSource> findBambooSpecsSourceForPlan(long planId) {
        return Optional.ofNullable(this.getPlanVcsBambooSpecsSource(planId)).map(PlanVcsBambooSpecsSource::getVcsBambooSpecsSource);
    }

    public Map<Long, VcsBambooSpecsSource> findSpecsSourcesForAllPlans() {
        return new JpaUtils.CriteriaQuery<PlanVcsBambooSpecsSourceImpl, PlanVcsBambooSpecsSourceImpl>(this.sessionFactory, PlanVcsBambooSpecsSourceImpl.class, PlanVcsBambooSpecsSourceImpl.class){

            @Override
            public void apply() {
                Fetch fetchSource = this.entity.fetch(PlanVcsBambooSpecsSourceImpl_.vcsBambooSpecsSource, JoinType.LEFT);
                fetchSource.fetch(VcsBambooSpecsSourceImpl_.vcsLocationBambooSpecsState, JoinType.LEFT);
                this.q.select((Selection)this.entity);
            }
        }.getResultList().stream().collect(Collectors.toMap(PlanVcsBambooSpecsSourceImpl::getPlanId, PlanVcsBambooSpecsSourceImpl::getVcsBambooSpecsSource));
    }

    private PlanVcsBambooSpecsSourceImpl getPlanVcsBambooSpecsSource(final long planId) {
        return (PlanVcsBambooSpecsSourceImpl)new JpaUtils.CriteriaQuery<PlanVcsBambooSpecsSourceImpl, PlanVcsBambooSpecsSourceImpl>(this.sessionFactory, PlanVcsBambooSpecsSourceImpl.class, PlanVcsBambooSpecsSourceImpl.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(PlanVcsBambooSpecsSourceImpl_.id), (Object)planId));
            }
        }.uniqueResult();
    }

    public void detachPlanFromRss(final long planId) {
        new JpaUtils.CriteriaDelete<PlanVcsBambooSpecsSourceImpl>(this.sessionFactory, PlanVcsBambooSpecsSourceImpl.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get(PlanVcsBambooSpecsSourceImpl_.id), (Object)planId));
            }
        }.executeUpdate();
    }

    public void updateBambooSpecsSourceForPlan(@NotNull Chain plan, @NotNull VcsBambooSpecsSource vcsBambooSpecsSource) {
        PlanVcsBambooSpecsSourceImpl planVcsBambooSpecsSource = this.getPlanVcsBambooSpecsSource(plan.getId());
        if (planVcsBambooSpecsSource == null) {
            planVcsBambooSpecsSource = new PlanVcsBambooSpecsSourceImpl(plan, vcsBambooSpecsSource);
        } else {
            planVcsBambooSpecsSource.setVcsBambooSpecsSource(vcsBambooSpecsSource);
        }
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)planVcsBambooSpecsSource);
    }
}

