/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs;

import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.plan.AbstractPlan_;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl_;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsStateImpl;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsStateImpl_;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSourceImpl_;
import com.atlassian.bamboo.specs.BambooSpecsStateDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooSpecsStateDaoImpl
implements BambooSpecsStateDao {
    @Inject
    private SessionFactory sessionFactory;

    public Optional<VcsLocationBambooSpecsState> findById(long specsStateId) {
        return Optional.ofNullable((VcsLocationBambooSpecsState)this.sessionFactory.getCurrentSession().find(VcsLocationBambooSpecsStateImpl.class, (Object)specsStateId));
    }

    public Optional<VcsLocationBambooSpecsState> findLatestState(long rootVcsRepositoryId, String branch) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(VcsLocationBambooSpecsState.class);
        Root model = q.from(VcsLocationBambooSpecsStateImpl.class);
        q.select((Selection)model).where(new Predicate[]{cb.equal((Expression)model.get(VcsLocationBambooSpecsStateImpl_.vcsLocationId), (Object)rootVcsRepositoryId), cb.equal((Expression)model.get(VcsLocationBambooSpecsStateImpl_.branch), (Object)branch)}).orderBy(new Order[]{cb.desc((Expression)model.get(VcsLocationBambooSpecsStateImpl_.id))});
        return session.createQuery(q).setMaxResults(1).uniqueResultOptional();
    }

    public void saveOrUpdate(VcsLocationBambooSpecsState vcsLocationBambooSpecsState) {
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)vcsLocationBambooSpecsState);
    }

    @NotNull
    public Collection<PlanKey> findPlansInOtherStates(@NotNull VcsLocationBambooSpecsState specsState) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(PlanKey.class);
        Root planSpecsSource = q.from(PlanVcsBambooSpecsSourceImpl.class);
        Join planSpecsSourceToChain = planSpecsSource.join(PlanVcsBambooSpecsSourceImpl_.plan);
        Join planSpecsSourceToState = planSpecsSource.join(PlanVcsBambooSpecsSourceImpl_.vcsBambooSpecsSource).join(VcsBambooSpecsSourceImpl_.vcsLocationBambooSpecsState);
        q.select((Selection)planSpecsSourceToChain.get(AbstractPlan_.planKey)).where(new Predicate[]{cb.equal((Expression)planSpecsSourceToState.get(VcsLocationBambooSpecsStateImpl_.vcsLocationId), (Object)specsState.getVcsLocationId()), cb.equal((Expression)planSpecsSourceToState.get(VcsLocationBambooSpecsStateImpl_.branch), (Object)specsState.getBranch()), cb.notEqual((Expression)planSpecsSourceToState.get(VcsLocationBambooSpecsStateImpl_.id), (Object)specsState.getId())});
        return session.createQuery(q).list();
    }

    public long countPlansLinkedToState(VcsLocationBambooSpecsState specsState) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Long.class);
        Root planSpecsSource = q.from(PlanVcsBambooSpecsSourceImpl.class);
        Join chainToStateJoin = planSpecsSource.join(PlanVcsBambooSpecsSourceImpl_.vcsBambooSpecsSource).join(VcsBambooSpecsSourceImpl_.vcsLocationBambooSpecsState);
        q.select((Selection)cb.count((Expression)chainToStateJoin)).where((Expression)cb.equal((Expression)chainToStateJoin.get(VcsLocationBambooSpecsStateImpl_.id), (Object)specsState.getId()));
        return (Long)session.createQuery(q).getSingleResult();
    }

    public void scrollVcsLocationBambooSpecsStateForExport(@NotNull Consumer<VcsLocationBambooSpecsState> consumer) {
        CriteriaQuery query = this.sessionFactory.getCurrentSession().getCriteriaBuilder().createQuery(VcsLocationBambooSpecsStateImpl.class);
        Root model = query.from(VcsLocationBambooSpecsStateImpl.class);
        query.select((Selection)model);
        try (Stream stream = this.sessionFactory.getCurrentSession().createQuery(query).stream();){
            stream.forEach(consumer);
        }
    }

    @NotNull
    public List<VcsLocationBambooSpecsState> findByVcsLocation(long repositoryId, @NotNull String branch) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(VcsLocationBambooSpecsState.class);
        Root model = q.from(VcsLocationBambooSpecsStateImpl.class);
        q.select((Selection)model).where(new Predicate[]{cb.equal((Expression)model.get(VcsLocationBambooSpecsStateImpl_.vcsLocationId), (Object)repositoryId), cb.equal((Expression)model.get("branch"), (Object)branch)});
        List<VcsLocationBambooSpecsState> logs = session.createQuery(q).list();
        return logs != null ? logs : Collections.emptyList();
    }

    @NotNull
    public List<VcsLocationBambooSpecsState> findByVcsLocationIdOrderBySpecsExecutionDate(long repositoryId, @NotNull String branch, int limit) {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(VcsLocationBambooSpecsState.class);
        Root model = q.from(VcsLocationBambooSpecsStateImpl.class);
        q.select((Selection)model).where(new Predicate[]{cb.equal((Expression)model.get(VcsLocationBambooSpecsStateImpl_.vcsLocationId), (Object)repositoryId), cb.equal((Expression)model.get("branch"), (Object)branch), cb.isNotNull((Expression)model.get(VcsLocationBambooSpecsStateImpl_.specsExecutionDate))}).orderBy(new Order[]{cb.desc((Expression)model.get(VcsLocationBambooSpecsStateImpl_.specsExecutionDate))});
        List<VcsLocationBambooSpecsState> logs = session.createQuery(q).setMaxResults(limit).list();
        return logs != null ? logs : Collections.emptyList();
    }

    public void delete(VcsLocationBambooSpecsState specsState) {
        Session session = this.sessionFactory.getCurrentSession();
        session.delete((Object)specsState);
    }

    public long countStatesByRepositoryId(final long repositoryId) {
        return (Long)new JpaUtils.CriteriaQuery<VcsLocationBambooSpecsStateImpl, Long>(this.sessionFactory, VcsLocationBambooSpecsStateImpl.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where((Expression)this.cb.equal((Expression)this.entity.get(VcsLocationBambooSpecsStateImpl_.vcsLocationId), (Object)repositoryId));
            }
        }.getSingleResult();
    }

    @NotNull
    public List<VcsLocationBambooSpecsState> getUnfinishedSpecsScans() {
        return new JpaUtils.CriteriaQuery<VcsLocationBambooSpecsStateImpl, VcsLocationBambooSpecsState>(this.sessionFactory, VcsLocationBambooSpecsStateImpl.class, VcsLocationBambooSpecsState.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.isNull((Expression)this.entity.get("specsImportState")));
            }
        }.getResultList();
    }

    @NotNull
    public List<String> findSpecsBranches(long rootVcsRepositoryId) {
        return this.findSpecsBranchesInternal(rootVcsRepositoryId, null);
    }

    @NotNull
    public List<String> findSpecsBranches(long rootVcsRepositoryId, @NotNull String searchTerm) {
        return this.findSpecsBranchesInternal(rootVcsRepositoryId, searchTerm);
    }

    public boolean otherSuccessfullySpecsImportExistsForRevision(final long rootVcsRepositoryId, final @NotNull String revision, final long specsStateId) {
        Long count = (Long)new JpaUtils.CriteriaQuery<VcsLocationBambooSpecsStateImpl, Long>(this.sessionFactory, VcsLocationBambooSpecsStateImpl.class, Long.class){

            @Override
            public void apply() {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(this.cb.equal((Expression)this.entity.get(VcsLocationBambooSpecsStateImpl_.vcsLocationId), (Object)rootVcsRepositoryId));
                predicates.add(this.cb.equal((Expression)this.entity.get(VcsLocationBambooSpecsStateImpl_.revision), (Object)revision));
                predicates.add(this.cb.equal((Expression)this.entity.get(VcsLocationBambooSpecsStateImpl_.specsImportState), (Object)VcsLocationBambooSpecsState.SpecsImportState.SUCCESS));
                predicates.add(this.cb.notEqual((Expression)this.entity.get(VcsLocationBambooSpecsStateImpl_.id), (Object)specsStateId));
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where(predicates.toArray(new Predicate[0]));
            }
        }.getSingleResult();
        return count > 0L;
    }

    private List<String> findSpecsBranchesInternal(final long rootVcsRepositoryId, final @Nullable String searchTerm) {
        return new JpaUtils.CriteriaQuery<VcsLocationBambooSpecsStateImpl, String>(this.sessionFactory, VcsLocationBambooSpecsStateImpl.class, String.class){

            @Override
            public void apply() {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(this.cb.equal((Expression)this.entity.get("vcsLocationId"), (Object)rootVcsRepositoryId));
                if (searchTerm != null) {
                    predicates.add(this.cb.like((Expression)this.entity.get("branch"), String.format("%%%s%%", searchTerm)));
                }
                this.q.select((Selection)this.entity.get("branch")).where(predicates.toArray(new Predicate[0])).distinct(true);
            }
        }.getResultList();
    }
}

