/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.persistence3.StatelessSessionHibernateDaoSupport;
import com.atlassian.bamboo.specs.RssProjectPermission;
import com.atlassian.bamboo.specs.RssProjectPermissionDao;
import com.atlassian.bamboo.specs.RssProjectPermissionImpl;
import com.atlassian.bamboo.specs.RssProjectPermissionImpl_;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RssProjectPermissionHibernateDaoImpl
extends StatelessSessionHibernateDaoSupport
implements RssProjectPermissionDao {
    private static final Class<RssProjectPermission> PERSISTENT_INTERFACE = RssProjectPermission.class;
    private static final Class<RssProjectPermissionImpl> PERSISTENT_CLASS = RssProjectPermissionImpl.class;

    @Nullable
    public RssProjectPermission findById(long id) {
        return (RssProjectPermission)this.getCacheAwareHibernateTemplate().get(PERSISTENT_CLASS, (Serializable)Long.valueOf(id));
    }

    @NotNull
    public List<RssProjectPermission> findByProjectId(long projectId) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(PERSISTENT_INTERFACE);
            Root root = query.from(PERSISTENT_CLASS);
            query.select((Selection)root).where((Expression)builder.equal((Expression)root.get(RssProjectPermissionImpl_.project), (Object)projectId));
            return session.createQuery(query).getResultList();
        });
    }

    @NotNull
    public List<RssProjectPermission> findByRepositoryId(long repositoryId) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(PERSISTENT_INTERFACE);
            Root root = query.from(PERSISTENT_CLASS);
            query.select((Selection)root).where((Expression)builder.equal((Expression)root.get(RssProjectPermissionImpl_.repository), (Object)repositoryId));
            return session.createQuery(query).getResultList();
        });
    }

    @Nullable
    public RssProjectPermission findByProjectIdAndRepositoryId(long projectId, long repositoryId) {
        return (RssProjectPermission)this.getCacheAwareHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(PERSISTENT_INTERFACE);
            Root root = query.from(PERSISTENT_CLASS);
            query.select((Selection)root).where(new Predicate[]{builder.equal((Expression)root.get(RssProjectPermissionImpl_.project), (Object)projectId), builder.equal((Expression)root.get(RssProjectPermissionImpl_.repository), (Object)repositoryId)});
            return (RssProjectPermission)session.createQuery(query).uniqueResult();
        });
    }

    public List<Long> findRepositoryIdsByProjectId(long projectId) {
        return this.findByProjectId(projectId).stream().map(RssProjectPermission::getRepository).map(BambooIdProvider::getId).collect(Collectors.toList());
    }

    public void save(RssProjectPermission entity) {
        this.getCacheAwareHibernateTemplate().save((Object)entity);
    }

    public void delete(RssProjectPermission entity) {
        this.getCacheAwareHibernateTemplate().delete((Object)entity);
    }
}

