/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.persistence3.StatelessSessionHibernateDaoSupport;
import com.atlassian.bamboo.specs.RssRepositoryPermission;
import com.atlassian.bamboo.specs.RssRepositoryPermissionDao;
import com.atlassian.bamboo.specs.RssRepositoryPermissionImpl;
import com.atlassian.bamboo.specs.RssRepositoryPermissionImpl_;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RssRepositoryPermissionHibernateDaoImpl
extends StatelessSessionHibernateDaoSupport
implements RssRepositoryPermissionDao {
    private static final Class<RssRepositoryPermission> PERSISTENT_INTERFACE = RssRepositoryPermission.class;
    private static final Class<RssRepositoryPermissionImpl> PERSISTENT_CLASS = RssRepositoryPermissionImpl.class;

    @Nullable
    public RssRepositoryPermission findById(long id) {
        return (RssRepositoryPermission)this.getCacheAwareHibernateTemplate().get(PERSISTENT_CLASS, (Serializable)Long.valueOf(id));
    }

    @NotNull
    public List<RssRepositoryPermission> findByTargetRepositoryId(long targetRepositoryId) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(PERSISTENT_INTERFACE);
            Root root = query.from(PERSISTENT_CLASS);
            query.select((Selection)root).where((Expression)builder.equal((Expression)root.get(RssRepositoryPermissionImpl_.targetRepository), (Object)targetRepositoryId));
            return session.createQuery(query).getResultList();
        });
    }

    @NotNull
    public List<RssRepositoryPermission> findByRepositoryId(long repositoryId) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(PERSISTENT_INTERFACE);
            Root root = query.from(PERSISTENT_CLASS);
            query.select((Selection)root).where((Expression)builder.equal((Expression)root.get(RssRepositoryPermissionImpl_.repository), (Object)repositoryId));
            return session.createQuery(query).getResultList();
        });
    }

    @Nullable
    public RssRepositoryPermission findByTargetRepositoryIdAndRepositoryId(long targetRepositoryId, long repositoryId) {
        return (RssRepositoryPermission)this.getCacheAwareHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(PERSISTENT_INTERFACE);
            Root root = query.from(PERSISTENT_CLASS);
            query.select((Selection)root).where(new Predicate[]{builder.equal((Expression)root.get(RssRepositoryPermissionImpl_.targetRepository), (Object)targetRepositoryId), builder.equal((Expression)root.get(RssRepositoryPermissionImpl_.repository), (Object)repositoryId)});
            return (RssRepositoryPermission)session.createQuery(query).uniqueResult();
        });
    }

    public List<Long> findRepositoryIdsByTargetRepositoryId(long projectId) {
        return this.findByTargetRepositoryId(projectId).stream().map(RssRepositoryPermission::getRepository).map(BambooIdProvider::getId).collect(Collectors.toList());
    }

    public void save(RssRepositoryPermission entity) {
        this.getCacheAwareHibernateTemplate().save((Object)entity);
    }

    public void delete(RssRepositoryPermission entity) {
        this.getCacheAwareHibernateTemplate().delete((Object)entity);
    }
}

