/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user;

import bucket.user.DefaultUserAccessor;
import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.accesstoken.AccessTokenDao;
import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.avatar.AvatarService;
import com.atlassian.bamboo.comment.CommentManager;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelDao;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.security.acegi.acls.HibernateAclImpl;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.session.UserSessionInvalidatedEvent;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.DefaultBambooUser;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.bamboo.user.PasswordResetToken;
import com.atlassian.bamboo.user.PasswordResetTokenDao;
import com.atlassian.bamboo.user.PasswordResetTokenImpl;
import com.atlassian.bamboo.user.crowd.filteredgroups.FilteredGroupsProvider;
import com.atlassian.bamboo.user.propertyset.BambooPropertySetDao;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.bamboo.utils.scopedcaches.ThreadScopedCaches;
import com.atlassian.cache.CacheManager;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.crowd.embedded.atlassianuser.MembershipCache;
import com.atlassian.crowd.manager.recovery.RecoveryModeService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.atlassian.user.security.password.Credential;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.domain.AclAuthorizationStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jxmpp.util.XmppStringUtils;

public class BambooUserManagerImpl
extends DefaultUserAccessor
implements BambooUserManager {
    private static final Logger log = LogManager.getLogger(BambooUserManagerImpl.class);
    private static final ObjectIdentity GLOBAL_APPLICATION_SECURE_OBJECT_IDENTITY = new HibernateObjectIdentityImpl(GlobalApplicationSecureObject.INSTANCE);
    private static final String LOCAL_USERNAME_PREFIX = "CWD_";
    private static final String EXTERNAL_USERNAME_PREFIX = "EXT_";
    private static final ThreadScopedCaches.Key<String, User> USERS_BY_NAME = ThreadScopedCaches.makeKey(BambooUserManagerImpl.class);
    @Inject
    private EventPublisher eventPublisher;
    private AuthorDao authorDao;
    private CommentManager commentManager;
    private LabelDao labelDao;
    private HibernateMutableAclService aclService;
    private AclAuthorizationStrategy aclAuthorizationStrategy;
    private PasswordResetTokenDao tokenDao;
    private LoginInformationManager loginInformationManager;
    private RememberMeTokenDao rememberMeTokenDao;
    private FeatureManager featureManager;
    private RecoveryModeService recoveryModeService;
    private BambooPropertySetDao propertySetDao;
    private AccessTokenDao accessTokenDao;
    private AvatarService avatarService;
    private CacheManager cacheManager;
    private static final Set<String> DELETABLE_LABEL_NAMES = ImmutableSet.of((Object)":unmark-favourite", (Object)":favourite");
    private static final String JIRA_ISSUE_DEFAULTS_JSON = "jiraIssueDefaults";
    private FilteredGroupsProvider filteredGroupsProvider;
    private Set<String> filteredGroups;
    private Optional<MembershipCache> membershipCache = Optional.empty();

    @PostConstruct
    public void postConstruct() {
        this.initCache();
        this.membershipCache.ifPresentOrElse(mc -> this.eventPublisher.register(mc), () -> log.error("Membership cache is not initialized"));
    }

    private synchronized void initCache() {
        this.membershipCache = Optional.of(new MembershipCache(this.cacheManager, this::loadUserGroups));
    }

    @Nullable
    public BambooUser getBambooUser(String username) {
        User user = this.getUser(username);
        return this.getBambooUser(user);
    }

    @Nullable
    public BambooUser getBambooUser(@Nullable User user) {
        return user != null ? new DefaultBambooUser(user, this.getAuthoritiesSupplier(user)) : null;
    }

    public BambooUser getBambooUser(@NotNull AccessToken accessToken) {
        User user = this.getUser(accessToken.getUserName());
        return user != null ? new DefaultBambooUser(user, this.getAuthoritiesSupplier(user), accessToken) : null;
    }

    @Nullable
    public User getUser(String name) {
        return (User)ThreadScopedCaches.getValue(USERS_BY_NAME, (Object)name, () -> this.getUserInternal(name));
    }

    @Nullable
    private User getUserInternal(String name) {
        if (name == null) {
            log.debug("Null passed as username in #getUser");
        } else if (name.isEmpty()) {
            log.debug("Empty string passed as username in #getUser");
        }
        User user = super.getUser(name);
        if (user == null) {
            log.debug("User {} not found.", (Object)name);
            log.trace("", new Throwable("Attempted to fetch a non-existing user (" + name + ")"));
        }
        return user;
    }

    public BambooUser addUser(String username, String password, String email, String fullName, String jabberAddress, List<String> groups) {
        return this.addUser(username, password, email, fullName, jabberAddress, groups, Collections.emptyList());
    }

    public BambooUser addUser(String username, String password, String email, String fullName, String jabberAddress, List<String> groups, ExtendedAuthor author) {
        return this.addUser(username, password, email, fullName, jabberAddress, groups, author != null ? Collections.singletonList(author.getId()) : Collections.emptyList());
    }

    public BambooUser addUser(String username, String password, String email, String fullName, String jabberAddress, List<String> groups, @NotNull List<Long> authors) {
        return this.addUser(username, password, true, email, fullName, jabberAddress, groups, authors);
    }

    public BambooUser addUser(String username, String password, boolean enabled, String email, String fullName, String jabberAddress, List<String> groups, @NotNull List<Long> authors) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        String[] groupsArray = BambooUserManagerImpl.stringListToArray(groups);
        User user = groupsArray == null ? this.addUser(username, password, enabled, email, fullName) : this.addUser(username, password, enabled, email, fullName, groupsArray);
        PropertySet propertySet = this.getPropertySet(user);
        if (jabberAddress != null) {
            propertySet.setString("bamboo.user.contact.jabber", jabberAddress);
        }
        propertySet.setString("bamboo.user.contact.preference", "both");
        propertySet.setString("bamboo.user.contact.transportPreference", "multipart");
        this.authorDao.updateLinkedAuthors(user, authors);
        return new DefaultBambooUser(user, this.getAuthoritiesSupplier(user));
    }

    public void renameUser(@NotNull String oldUserName, @NotNull String newUserName) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        User user = this.getUser(oldUserName);
        if (user == null) {
            throw new IllegalArgumentException("Username " + oldUserName + " cannot be found");
        }
        try {
            this.getUserManager().renameUser(user, newUserName);
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
    }

    public void onExternalUserRename(@NotNull String oldUserName, @NotNull String newUserName) {
        try {
            this.getUserManager().onExternalUserRename(oldUserName, newUserName);
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
    }

    public void saveUser(String username, String password, String email, String fullName, String jabberAddress, List<String> selectedGroups) throws IllegalArgumentException {
        this.saveUser(username, password, email, fullName, jabberAddress, selectedGroups, null);
    }

    public void saveUser(String username, String password, String email, String fullName, String jabberAddress, List<String> selectedGroups, ExtendedAuthor author) throws IllegalArgumentException {
        User user = this.getUser(username);
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (String)"Username %s cannot be found", (Object)username);
        this.internalSaveUser(user, username, password, user.isEnabled(), email, fullName, jabberAddress, null, null, selectedGroups, author != null ? Collections.singletonList(author.getId()) : Collections.emptyList());
    }

    public void saveUser(String username, @Nullable String password, boolean enabled, String email, String fullName, String jabberAddress, String notificationPreference, String notificationTransportPreference, List<String> selectedGroups, @NotNull List<Long> authors) throws IllegalArgumentException {
        User user = this.getUser(username);
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (String)"Username %s cannot be found", (Object)username);
        this.internalSaveUser(user, username, password, enabled, email, fullName, jabberAddress, notificationPreference, notificationTransportPreference, selectedGroups, authors);
    }

    private void internalSaveUser(@NotNull User user, String username, @Nullable String password, boolean enabled, String email, String fullName, String jabberAddress, String notificationPreference, String notificationTransportPreference, List<String> selectedGroups, @NotNull List<Long> authors) throws IllegalArgumentException {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        if (!this.isReadOnly(user)) {
            this.saveUser((User)new DefaultUser(user.getName(), fullName, email, enabled));
            if (!enabled) {
                this.eventPublisher.publish((Object)new UserSessionInvalidatedEvent(user));
            }
        }
        this.setUserGroups(user, selectedGroups);
        PropertySet propertySet = this.getPropertySet(user);
        if (jabberAddress != null) {
            propertySet.setString("bamboo.user.contact.jabber", jabberAddress);
        }
        if (notificationPreference != null) {
            propertySet.setString("bamboo.user.contact.preference", notificationPreference);
        }
        if (notificationTransportPreference != null) {
            propertySet.setString("bamboo.user.contact.transportPreference", notificationTransportPreference);
        }
        this.authorDao.updateLinkedAuthors(user, authors);
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            if (this.isReadOnly(user)) {
                this.cannotAlterPassword(username, null);
            } else {
                try {
                    this.alterPassword(user, password);
                }
                catch (EntityException e) {
                    this.cannotAlterPassword(username, e);
                }
            }
        }
    }

    public void alterPassword(User user, String plainTextPassword) throws EntityException {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        this.loginInformationManager.resetFailedLoginAttemptsCount(user.getName());
        super.alterPassword(user, plainTextPassword);
    }

    public void saveNotificationPreferences(String username, String notificationPreference, String notificationTransportPref) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        User user = this.getUser(username);
        if (user == null) {
            throw new IllegalArgumentException("Username " + username + " cannot be found");
        }
        PropertySet propertySet = this.getPropertySet(user);
        if (notificationPreference != null) {
            propertySet.setString("bamboo.user.contact.preference", notificationPreference);
        }
        if (notificationTransportPref != null) {
            propertySet.setString("bamboo.user.contact.transportPreference", notificationTransportPref);
        }
    }

    @Nullable
    private String getCurrentUserName() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        Principal currentUser = (Principal)authentication.getPrincipal();
        if (currentUser == null) {
            return null;
        }
        return currentUser.getName();
    }

    private void cannotAlterPassword(String username, EntityException e) {
        String message = "Could not alter password for user " + username;
        log.error(message, (Throwable)e);
        throw new IllegalArgumentException(message, e);
    }

    private void setUserGroups(User user, List<String> selectedGroups) {
        Collection<String> collection;
        Collection<String> groupsToRemove;
        ArrayList<String> existingGroups = new ArrayList<String>();
        Pager existingGroupPager = this.getGroups(user);
        if (existingGroupPager != null && !existingGroupPager.isEmpty()) {
            for (Group group : existingGroupPager) {
                if (this.isReadOnly(group)) continue;
                existingGroups.add(group.getName());
            }
        }
        ArrayList<String> filteredSelectedGroups = new ArrayList<String>();
        if (selectedGroups != null && !selectedGroups.isEmpty()) {
            for (String string : selectedGroups) {
                Group group = this.getGroup(string);
                if (group == null || this.isReadOnly(group)) continue;
                filteredSelectedGroups.add(string);
            }
        }
        if ((groupsToRemove = BambooUserManagerImpl.subtractNewList(existingGroups, filteredSelectedGroups)) != null && !groupsToRemove.isEmpty()) {
            for (String groupName : groupsToRemove) {
                this.removeMembership(groupName, user.getName());
            }
        }
        if ((collection = BambooUserManagerImpl.subtractNewList(filteredSelectedGroups, existingGroups)) != null && !collection.isEmpty()) {
            for (String groupName : collection) {
                this.addMembership(groupName, user.getName());
            }
        }
    }

    public void removeUser(User user) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        this.cleanupRemovedUserReferences(user.getName());
        super.removeUser(user);
    }

    public void cleanupRemovedUserReferences(@NotNull String username) {
        this.removeFavouriteRelatedLabelsForUser(username);
        this.authorDao.unlinkLinkedAuthors(username);
        this.removePrincipalPermission((Sid)new PrincipalSid(username));
        this.rememberMeTokenDao.removeAllForUser(username);
        this.accessTokenDao.deleteByUserName(username);
        this.avatarService.deleteForUser(username);
        this.commentManager.anonymizeUserComments(username);
        this.anonymizeLabels(username);
    }

    private void anonymizeLabels(@NotNull String username) {
        List labellingsToAnonymize = this.labelDao.findLabellingByUser(username).stream().filter(labelling -> {
            String labelName;
            Label label = labelling.getLabel();
            if (label != null && (labelName = label.getName()) != null) {
                return !DELETABLE_LABEL_NAMES.contains(labelName);
            }
            return false;
        }).collect(Collectors.toList());
        for (Labelling labelling2 : labellingsToAnonymize) {
            labelling2.setUserName("");
            this.labelDao.saveLabelling(labelling2);
        }
    }

    public void removeGroup(Group group) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        this.cleanupRemovedGroupReferences(group.getName());
        super.removeGroup(group);
    }

    public void cleanupRemovedGroupReferences(@NotNull String groupName) {
        this.removePrincipalPermission((Sid)new GroupPrincipalSid(groupName));
    }

    void removeFavouriteRelatedLabelsForUser(String username) {
        List labellings = this.labelDao.findLabellingByUser(username);
        labellings.stream().filter(labelling -> DELETABLE_LABEL_NAMES.contains(labelling.getLabel().getName())).map(labelling -> (EntityObject)labelling).forEach(arg_0 -> ((LabelDao)this.labelDao).remove(arg_0));
        List labels = this.labelDao.findLabelsByNameAndNamespace(Arrays.asList(":unmark-favourite", ":favourite"), username);
        labels.stream().filter(label -> DELETABLE_LABEL_NAMES.contains(label.getName())).map(label -> (EntityObject)label).forEach(arg_0 -> ((LabelDao)this.labelDao).remove(arg_0));
    }

    private void removePrincipalPermission(Sid sid) {
        this.aclService.deleteAcesForSid(sid);
        PrincipalSid newOwner = null;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            newOwner = new PrincipalSid(authentication);
        }
        this.aclService.changeAlcOwnerForSid(sid, (Sid)newOwner);
    }

    public List<String> getGroupNamesAsList(User user) {
        return this.membershipCache.map(c -> c.getGroupNamesAsList(user)).orElseThrow(() -> new IllegalStateException("Membership cache not initialized"));
    }

    public void setMembership(Group group, List<String> members) {
        Collection<String> membersToAdd;
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        List<String> existingUsers = this.getMemberNamesAsList(group);
        Collection<String> membersToRemove = BambooUserManagerImpl.subtractNewList(existingUsers, members);
        if (membersToRemove != null && !membersToRemove.isEmpty()) {
            for (String username : membersToRemove) {
                User user = this.getUser(username);
                if (user == null) {
                    user = new DefaultUser(username);
                }
                this.removeMembership(group, user);
            }
        }
        if ((membersToAdd = BambooUserManagerImpl.subtractNewList(members, existingUsers)) != null && !membersToAdd.isEmpty()) {
            for (String username : membersToAdd) {
                User user = this.getUser(username);
                this.addMembership(group, user);
            }
        }
    }

    @NotNull
    public List<String> getMemberNamesAsList(Group group) {
        List userList;
        Pager users = this.getMemberNames(group);
        if (users != null && (userList = PagerUtils.toList((Pager)users)) != null) {
            return userList;
        }
        return Collections.emptyList();
    }

    public boolean isUserAutocompleteAllowed() {
        return true;
    }

    public static <T> Collection<T> subtractNewList(Collection<T> oldList, Collection<T> newList) {
        if (newList == null) {
            return oldList;
        }
        if (oldList == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.subtract(oldList, newList);
    }

    public static String[] stringListToArray(Collection<String> strings) {
        if (strings != null && !strings.isEmpty()) {
            String[] array = new String[strings.size()];
            int i = 0;
            Iterator<String> iterator = strings.iterator();
            while (iterator.hasNext()) {
                String s;
                array[i] = s = iterator.next();
                ++i;
            }
            return array;
        }
        return null;
    }

    public BambooUser injectUser(@NotNull BambooUser user) {
        try {
            User bambooUser = this.getUserManager().createUser((User)user, Credential.encrypted((String)user.getPassword()));
            PropertySet propertySet = this.getPropertySet(bambooUser);
            String jabberAddress = user.getJabberAddress();
            String notificationPreference = user.getNotificationPreference();
            String notificationTransportPreference = user.getNotificationTransportPreference();
            if (jabberAddress != null) {
                propertySet.setString("bamboo.user.contact.jabber", jabberAddress);
            }
            if (notificationPreference != null) {
                propertySet.setString("bamboo.user.contact.preference", notificationPreference);
            }
            if (notificationTransportPreference != null) {
                propertySet.setString("bamboo.user.contact.transportPreference", notificationTransportPreference);
            }
            return new DefaultBambooUser(bambooUser, this.getAuthoritiesSupplier((User)user));
        }
        catch (EntityException e) {
            throw new InfrastructureException((Throwable)e);
        }
    }

    public boolean isDeletable(User user) {
        return !this.isReadOnly(user);
    }

    public boolean isDeletable(Group group) {
        return !this.isReadOnly(group);
    }

    public boolean isReadOnly(User user) {
        try {
            return this.getUserManager().isReadOnly(user);
        }
        catch (EntityException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    public boolean isReadOnly(Group group) {
        try {
            return this.getGroupManager().isReadOnly(group);
        }
        catch (EntityException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    public boolean canCreateUsers() {
        return this.getUserManager().isCreative();
    }

    public boolean canCreateGroups() {
        return this.getGroupManager().isCreative();
    }

    public void setupInitialAdminUser(String username, String password, String email, String fullName) {
        User user = this.addUser(username, password, true, email, fullName, new String[]{"bamboo-admin"});
        DefaultBambooUser bambooUser = new DefaultBambooUser(user, this.getAuthoritiesSupplier(user));
        PrincipalAcegiUserToken auth = new PrincipalAcegiUserToken("USER_TOKEN_KEY", username, password, new GrantedAuthority[]{Authority.ADMIN}, (Object)bambooUser);
        ImpersonationHelper.runWith((Authentication)auth, (BambooRunnables.ThrowingX)((BambooRunnables.NotThrowing)() -> {
            GroupPrincipalSid creator = new GroupPrincipalSid("bamboo-admin");
            HibernateObjectIdentityImpl globalPermissionObjectId = new HibernateObjectIdentityImpl(GlobalApplicationSecureObject.INSTANCE);
            HibernateAclImpl acl = new HibernateAclImpl((ObjectIdentity)globalPermissionObjectId, null, true, (Sid)creator);
            acl.setAclAuthorizationStrategy(this.aclAuthorizationStrategy);
            acl.insertAce(null, (Permission)BambooPermission.ADMINISTRATION, (Sid)creator, true);
            acl.insertAce(null, (Permission)BambooPermission.CREATE, (Sid)creator, true);
            acl.insertAce(null, (Permission)BambooPermission.CREATE_REPOSITORY, (Sid)creator, true);
            acl.insertAce(null, (Permission)BambooPermission.READ, (Sid)creator, true);
            acl.insertAce(null, (Permission)BambooPermission.READ, (Sid)new GrantedAuthoritySid(Authority.USER), true);
            acl.insertAce(null, (Permission)BambooPermission.READ, (Sid)new GrantedAuthoritySid(Authority.ANONYMOUS), true);
            this.aclService.updateAcl((MutableAcl)acl);
        }));
    }

    @NotNull
    public PasswordResetToken createPasswordResetToken(String username) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        PasswordResetToken token = this.getPasswordResetToken(username);
        if (token == null) {
            token = new PasswordResetTokenImpl(username);
        } else {
            token.generate();
        }
        this.tokenDao.save((EntityObject)token);
        return token;
    }

    @Nullable
    public PasswordResetToken getPasswordResetToken(String username) {
        return this.tokenDao.findUserToken(username);
    }

    public void deletePasswordResetToken(String username) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        PasswordResetToken token = this.getPasswordResetToken(username);
        if (token != null) {
            this.tokenDao.remove((EntityObject)token);
        }
    }

    public BambooUser findUserWithJabberAddress(@NotNull String jabberAddress) {
        String bareJabberAddress = XmppStringUtils.parseBareJid((String)jabberAddress);
        List<String> entityNames = this.propertySetDao.getEntityNamesByStringItemValues("bamboo.user.contact.jabber", Lists.newArrayList((Object[])new String[]{bareJabberAddress, jabberAddress}));
        for (String entityName : entityNames) {
            BambooUser bambooUser = this.getBambooUser(this.getUserNameFromPropertySetEntityName(entityName));
            if (bambooUser == null) continue;
            return bambooUser;
        }
        return null;
    }

    private String getUserNameFromPropertySetEntityName(String entityName) {
        if (entityName.startsWith(LOCAL_USERNAME_PREFIX)) {
            return entityName.substring(LOCAL_USERNAME_PREFIX.length());
        }
        if (entityName.startsWith(EXTERNAL_USERNAME_PREFIX)) {
            return entityName.substring(EXTERNAL_USERNAME_PREFIX.length());
        }
        throw new IllegalArgumentException("Unknown user name prefix in " + entityName);
    }

    public BambooUser loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.getUser(username);
        if (user != null) {
            return new DefaultBambooUser(user, this.getAuthoritiesSupplier(user));
        }
        return null;
    }

    public String getJiraIssueDefaults(@NotNull User user) {
        PropertySet propertySet = this.getPropertySet(user);
        return propertySet.getString(JIRA_ISSUE_DEFAULTS_JSON);
    }

    public void saveJiraIssueDefaults(@NotNull User user, @NotNull String jiraIssueDefaults) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        PropertySet propertySet = this.getPropertySet(user);
        propertySet.setString(JIRA_ISSUE_DEFAULTS_JSON, jiraIssueDefaults);
    }

    public boolean removeMembership(Group group, User user) {
        try {
            this.getGroupManager().removeMembership(group, user);
        }
        catch (EntityException e) {
            log.error(e.toString());
            log.debug("", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean addMembershipWithConfirmation(Group group, User user) {
        try {
            this.getGroupManager().addMembership(group, user);
        }
        catch (EntityException e) {
            log.error(e.toString());
            log.debug("", (Throwable)e);
            return false;
        }
        return true;
    }

    public void setAuthorDao(AuthorDao authorDao) {
        this.authorDao = authorDao;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public void setLabelDao(LabelDao labelDao) {
        this.labelDao = labelDao;
    }

    public void setTokenDao(PasswordResetTokenDao tokenDao) {
        this.tokenDao = tokenDao;
    }

    public void setAclService(HibernateMutableAclService aclService) {
        this.aclService = aclService;
    }

    public void setAclAuthorizationStrategy(AclAuthorizationStrategy aclAuthorizationStrategy) {
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
    }

    public void setLoginInformationManager(LoginInformationManager loginInformationManager) {
        this.loginInformationManager = loginInformationManager;
    }

    public void setRememberMeTokenDao(RememberMeTokenDao rememberMeTokenDao) {
        this.rememberMeTokenDao = rememberMeTokenDao;
    }

    public void setPropertySetDao(BambooPropertySetDao propertySetDao) {
        this.propertySetDao = propertySetDao;
    }

    public void setFilteredGroupsProvider(FilteredGroupsProvider filteredGroupsProvider) {
        this.filteredGroupsProvider = filteredGroupsProvider;
    }

    public void setFeatureManager(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public void setRecoveryModeService(RecoveryModeService recoveryModeService) {
        this.recoveryModeService = recoveryModeService;
    }

    public void setAccessTokenDao(AccessTokenDao accessTokenDao) {
        this.accessTokenDao = accessTokenDao;
    }

    public void setAvatarService(AvatarService avatarService) {
        this.avatarService = avatarService;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Pager<Group> getGroups() {
        Set<String> filtered = this.getFilteredGroups();
        if (filtered.isEmpty()) {
            return super.getGroups();
        }
        return new DefaultPager((Collection)BambooIterables.stream((Iterable)super.getGroups()).filter(group -> !filtered.contains(group.getName())).collect(Collectors.toList()));
    }

    private Set<String> getFilteredGroups() {
        if (this.filteredGroups == null) {
            this.filteredGroups = (Set)this.filteredGroupsProvider.getGroups().stream().map(StringUtils::lowerCase).collect(ImmutableSet.toImmutableSet());
        }
        return this.filteredGroups;
    }

    private Supplier<GrantedAuthority[]> getAuthoritiesSupplier(User user) {
        return () -> {
            ArrayList grantedAuthorities = Lists.newArrayList((Object[])new GrantedAuthority[]{Authority.ANONYMOUS, Authority.USER});
            List<String> userGroups = this.getGroupNamesAsList(user);
            List<Sid> userSids = Stream.concat(Stream.concat(Stream.of(user.getName()).map(PrincipalSid::new), userGroups.stream().map(GroupPrincipalSid::new)), Stream.of(Authority.USER).map(GrantedAuthoritySid::new)).collect(Collectors.toList());
            Acl acl = this.aclService.readAclById(GLOBAL_APPLICATION_SECURE_OBJECT_IDENTITY);
            try {
                if (this.isGranted((Permission)BambooPermission.ADMINISTRATION, userSids, acl)) {
                    grantedAuthorities.add(Authority.ADMIN);
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            try {
                if (this.isGranted((Permission)BambooPermission.RESTRICTEDADMINISTRATION, userSids, acl)) {
                    grantedAuthorities.add(Authority.RESTRICTED_ADMIN);
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            try {
                if (this.isGranted((Permission)BambooPermission.SOX_COMPLIANCE, userSids, acl)) {
                    grantedAuthorities.add(Authority.SOX_COMPLIANT_USER);
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (this.isCrowdRecoveryModeAdmin(user.getName())) {
                grantedAuthorities.add(Authority.ADMIN);
            }
            return grantedAuthorities.toArray(new GrantedAuthority[0]);
        };
    }

    private boolean isCrowdRecoveryModeAdmin(@NotNull String username) {
        return this.featureManager.isCrowdRecoveryModeEnabled() && Objects.equals(username, this.recoveryModeService.getRecoveryUsername());
    }

    private boolean isGranted(Permission permission, List<Sid> sids, Acl acl) {
        boolean administrativeMode = false;
        return acl.isGranted(new Permission[]{permission}, sids.toArray(new Sid[0]), false);
    }

    protected List<String> loadUserGroups(User user) {
        log.debug("Calculating groups for user '{}'", (Object)user.getName());
        List groups = Optional.ofNullable(this.getGroups(user)).map(userGroups -> BambooIterables.stream((Iterable)userGroups).map(Entity::getName).collect(Collectors.toList())).orElse(Collections.emptyList());
        log.debug("Found {} groups for user '{}': {}", (Object)groups.size(), (Object)user.getName(), groups);
        return Collections.unmodifiableList(groups);
    }
}

