/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.cleanup;

import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntity;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityDao;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityImpl;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityImpl_;
import com.atlassian.bamboo.utils.BambooClosures;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrowdDeletedEntityHibernateDao
extends BambooHibernateObjectDao<CrowdDeletedEntity>
implements CrowdDeletedEntityDao {
    private static final Class<CrowdDeletedEntityImpl> PERSISTENT_CLASS = CrowdDeletedEntityImpl.class;

    @NotNull
    public Collection<? extends CrowdDeletedEntity> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    public long countAll() {
        return this.countAll(PERSISTENT_CLASS);
    }

    @Nullable
    public CrowdDeletedEntity findByTypeAndName(final @NotNull CrowdDeletedEntity.EntityType entityType, final @NotNull String entityName) {
        return (CrowdDeletedEntity)new JpaUtils.CriteriaQuery<CrowdDeletedEntityImpl, CrowdDeletedEntityImpl>((SessionFactory)Preconditions.checkNotNull((Object)this.getSessionFactory()), PERSISTENT_CLASS, PERSISTENT_CLASS){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where(new Predicate[]{this.cb.equal((Expression)this.entity.get(CrowdDeletedEntityImpl_.entityType), (Object)entityType), this.cb.equal((Expression)this.entity.get(CrowdDeletedEntityImpl_.entityName), (Object)entityName)});
            }
        }.uniqueResult();
    }

    @NotNull
    public Collection<? extends CrowdDeletedEntity> findAllDeletedBefore(final @NotNull Date date, int limit) {
        return new JpaUtils.CriteriaQuery<CrowdDeletedEntityImpl, CrowdDeletedEntityImpl>((SessionFactory)Preconditions.checkNotNull((Object)this.getSessionFactory()), PERSISTENT_CLASS, PERSISTENT_CLASS){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.lessThan((Expression)this.entity.get(CrowdDeletedEntityImpl_.deletionDate), (Comparable)date)).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get(CrowdDeletedEntityImpl_.deletionDate))});
            }
        }.getResultList(0, limit);
    }

    public <E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> void scrollAll(@NotNull BambooClosures.ThrowingX<CrowdDeletedEntity, E1, E2, E3> consumer) throws E1, E2, E3 {
        SessionFactory sessionFactory = (SessionFactory)Preconditions.checkNotNull((Object)this.getSessionFactory());
        Session session = sessionFactory.getCurrentSession();
        CriteriaQuery query = session.getCriteriaBuilder().createQuery(PERSISTENT_CLASS);
        Root model = query.from(PERSISTENT_CLASS);
        query.select((Selection)model);
        try (Stream stream = session.createQuery(query).stream();){
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                consumer.run((Object)((CrowdDeletedEntity)iterator.next()));
            }
        }
    }
}

