/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.crowd.filteredgroups;

import com.atlassian.bamboo.user.crowd.filteredgroups.FilteredGroupsProvider;
import com.atlassian.bamboo.utils.Dom4jUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import com.atlassian.core.util.ClassLoaderUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jetbrains.annotations.NotNull;

public class XmlFilteredGroupsProvider
implements FilteredGroupsProvider {
    private final FilteredGroupsFileReader fileReader;

    public XmlFilteredGroupsProvider() {
        this.fileReader = new ClassPathFilteredGroupsFileReader();
    }

    public XmlFilteredGroupsProvider(FilteredGroupsFileReader fileReader) {
        this.fileReader = fileReader;
    }

    @Override
    public Set<String> getGroups() {
        Document doc;
        InputStream stream = this.fileReader.getStream();
        if (stream == null) {
            return Collections.emptySet();
        }
        SAXReader reader = BambooXmlUtils.newSecureSaxReader();
        try {
            doc = reader.read(stream);
        }
        catch (DocumentException e) {
            throw new IllegalStateException("Cannot read filtered group file. make sure it is well-formed.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return this.parse(doc);
    }

    @NotNull
    private Set<String> parse(Document doc) {
        HashSet<String> groups = new HashSet<String>();
        Element root = doc.getRootElement();
        if (!root.getName().equals("filteredgroups")) {
            return groups;
        }
        for (Element elem : Dom4jUtils.elements((Element)root)) {
            if (!elem.getName().equals("filteredgroup")) continue;
            groups.add(elem.getTextTrim());
        }
        return groups;
    }

    static class ClassPathFilteredGroupsFileReader
    implements FilteredGroupsFileReader {
        private static final String FILTERED_GROUPS_FILE = "crowd-filtered-groups.xml";

        ClassPathFilteredGroupsFileReader() {
        }

        private String getFilename() {
            return new SystemProperty(false, new String[]{"crowd.service.filteredgroups.file"}).getValue(FILTERED_GROUPS_FILE);
        }

        @Override
        public InputStream getStream() {
            return ClassLoaderUtils.getResourceAsStream((String)this.getFilename(), this.getClass());
        }
    }

    static interface FilteredGroupsFileReader {
        public InputStream getStream();
    }
}

