/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.rename;

import com.atlassian.bamboo.utils.db.DbmsBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class UserRenameHelper {
    private static final Logger log = Logger.getLogger(UserRenameHelper.class);
    private static final String LOCAL_USER_PREFIX = "CWD_";
    private static final String EXTERNAL_USER_ENTITY_TYPE = "EXT";
    private static final String EXTERNAL_USER_PREFIX = "EXT_";
    private static final String ACL_TYPE_USER = "PRINCIPAL";

    UserRenameHelper() {
    }

    private void updateUserInTable(Connection connection, String oldUserName, String newUserName, String tableName, String columnName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, tableName, columnName, "", false, dbmsBean);
    }

    private void updateUserInTable(Connection connection, String oldUserName, String newUserName, String tableName, String columnName, String andClause, boolean isClob, DbmsBean dbmsBean) throws SQLException {
        log.info((Object)("Performing user rename in " + tableName));
        Object columnEqualsValueClause = isClob ? dbmsBean.clobEquals(columnName) : columnName + " = ?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(String.format("update %s set %s = ? where %s %s", tableName, columnName, columnEqualsValueClause, andClause));){
            preparedStatement.setString(1, newUserName);
            preparedStatement.setString(2, oldUserName);
            preparedStatement.executeUpdate();
        }
        log.debug((Object)("END: user rename in " + tableName));
    }

    protected void renameUserInAcl(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, "ACL_ENTRY", "SID", "and TYPE = 'PRINCIPAL'", false, dbmsBean);
        this.updateUserInTable(connection, oldUserName, newUserName, "ACL_OBJECT_IDENTITY", "OWNER_SID", "and OWNER_TYPE = 'PRINCIPAL'", false, dbmsBean);
    }

    protected void renameUserInComments(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, "USER_COMMENT", "USER_NAME", dbmsBean);
    }

    protected void renameUserInPasswordResetToken(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, "PASSWORD_RESET_TOKEN", "USERNAME", dbmsBean);
    }

    protected void renameUserInAuthors(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, "AUTHOR", "LINKED_USER_NAME", dbmsBean);
    }

    protected void renameUserInAuthAttemptInfo(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.removeNewUserFromAuthAttemptInfoTable(connection, newUserName);
        this.updateUserInTable(connection, oldUserName, newUserName, "AUTH_ATTEMPT_INFO", "USER_NAME", dbmsBean);
    }

    private void removeNewUserFromAuthAttemptInfoTable(Connection connection, String newUserName) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("delete from AUTH_ATTEMPT_INFO where USER_NAME = ?");){
            preparedStatement.setString(1, newUserName);
            preparedStatement.executeUpdate();
        }
    }

    protected void renameUserInOsPropertySet(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, boolean isLocalUser, DbmsBean dbmsBean) throws SQLException {
        String prefix = isLocalUser ? LOCAL_USER_PREFIX : EXTERNAL_USER_PREFIX;
        this.updateUserInTable(connection, prefix + oldUserName, prefix + newUserName, "OS_PROPERTYENTRY", "ENTITY_NAME", dbmsBean);
    }

    protected void renameUserInRememberMeToken(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, "REMEMBERME_TOKEN", "USERNAME", dbmsBean);
    }

    public void renameUserInAuditLog(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, "AUDIT_LOG", "USER_NAME", dbmsBean);
    }

    public void renameUserInLabellings(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, "BUILDRESULTSUMMARY_LABEL", "USER_NAME", dbmsBean);
    }

    public void renameUserInManualTriggerHistory(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, "BUILDRESULTSUMMARY_CUSTOMDATA", "CUSTOM_INFO_VALUE", "and CUSTOM_INFO_KEY = 'ManualBuildTriggerReason.userName'", true, dbmsBean);
        this.updateUserInTable(connection, oldUserName, newUserName, "DEPLOYMENT_RESULT_CUSTOMDATA", "CUSTOM_INFO_VALUE", "and CUSTOM_INFO_KEY = 'ManualBuildTriggerReason.userName'", true, dbmsBean);
    }

    public void renameUserInAccessTokens(Connection connection, @NotNull String oldUserName, @NotNull String newUserName, DbmsBean dbmsBean) throws SQLException {
        this.updateUserInTable(connection, oldUserName, newUserName, "ACCESS_TOKEN", "USER_NAME", dbmsBean);
    }
}

