/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.rename;

import com.atlassian.bamboo.avatar.AvatarService;
import com.atlassian.bamboo.cluster.CrossNodesRemoteBroadcasterImpl;
import com.atlassian.bamboo.cluster.event.CrossNodesEvent;
import com.atlassian.bamboo.cluster.event.bamboo.plan.InvalidateAllLatestResultSummariesEvent;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plugin.descriptor.UserRenameHandlerModuleDescriptor;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.rename.InvalidUserNameException;
import com.atlassian.bamboo.user.rename.UserNotFoundException;
import com.atlassian.bamboo.user.rename.UserRenameEvent;
import com.atlassian.bamboo.user.rename.UserRenameException;
import com.atlassian.bamboo.user.rename.UserRenameHandler;
import com.atlassian.bamboo.user.rename.UserRenameHelper;
import com.atlassian.bamboo.user.rename.UserRenameService;
import com.atlassian.bamboo.utils.BambooThrowables;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class UserRenameServiceImpl
implements UserRenameService {
    private static final Logger log = Logger.getLogger(UserRenameServiceImpl.class);
    private static final int MAX_USERNAME_LENGTH = 255;
    private final BambooUserManager bambooUserManager;
    private final TransactionTemplate transactionTemplate;
    private final HibernateTemplate hibernateTemplate;
    private final UserRenameHelper userRenameHelper;
    private final PluginAccessor pluginAccessor;
    private final ScopedExclusionService scopedExclusionService;
    private final EventPublisher eventPublisher;
    private final HibernateMutableAclService hibernateMutableAclService;
    @Inject
    private CrowdService crowdService;
    @Inject
    private CrowdDirectoryService crowdDirectoryService;
    @Inject
    private ImmutablePlanCacheService immutablePlanCacheService;
    @Inject
    private AvatarService avatarService;
    @Lazy
    @Inject
    private DbmsBean dbmsBean;

    public UserRenameServiceImpl(@NotNull BambooUserManager bambooUserManager, @NotNull TransactionTemplate transactionTemplate, @NotNull HibernateTemplate hibernateTemplate, @NotNull PluginAccessor pluginAccessor, @NotNull EventPublisher eventPublisher, @NotNull ScopedExclusionService scopedExclusionService, @NotNull HibernateMutableAclService hibernateMutableAclService) {
        this.bambooUserManager = bambooUserManager;
        this.pluginAccessor = pluginAccessor;
        this.scopedExclusionService = scopedExclusionService;
        this.eventPublisher = eventPublisher;
        this.hibernateTemplate = hibernateTemplate;
        this.transactionTemplate = transactionTemplate;
        this.hibernateMutableAclService = hibernateMutableAclService;
        this.userRenameHelper = new UserRenameHelper();
    }

    @PostConstruct
    private void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    private void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public void renameUser(@NotNull String oldUserName, @NotNull String newUserName, boolean isExternalRename) throws UserRenameException {
        this.renameUser(oldUserName, newUserName, isExternalRename ? RenameMode.ALREADY_DONE_EXTERNALLY : RenameMode.TO_BE_DONE_BY_US);
    }

    public void renameUser(final @NotNull String oldUserName, @NotNull String newUserName, final RenameMode renameMode) throws UserRenameException {
        if (StringUtils.isBlank((CharSequence)newUserName)) {
            throw new InvalidUserNameException("New user name must not be empty");
        }
        boolean isLocalUser = this.isLocalUser(oldUserName, newUserName, renameMode);
        this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.USER_CREATION, (Object)newUserName.intern(), newUserNameLocal -> {
            Preconditions.checkNotNull((Object)newUserNameLocal);
            if (renameMode == RenameMode.TO_BE_DONE_BY_US) {
                if (StringUtils.isEmpty((CharSequence)newUserNameLocal) || IdentifierUtils.hasLeadingOrTrailingWhitespace((String)newUserNameLocal) || newUserNameLocal.length() > 255) {
                    throw new InvalidUserNameException("Invalid username. It must''t be blank, have trailing or leading spaces or be longer than 255 characters.");
                }
                if (this.bambooUserManager.getBambooUser(newUserNameLocal) != null) {
                    throw new InvalidUserNameException("User " + newUserNameLocal + " already exists");
                }
            }
            try {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult((String)newUserNameLocal, isLocalUser){
                    final /* synthetic */ String val$newUserNameLocal;
                    final /* synthetic */ boolean val$isLocalUser;
                    {
                        this.val$newUserNameLocal = string2;
                        this.val$isLocalUser = bl;
                    }

                    protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                        UserRenameServiceImpl.this.hibernateTemplate.execute(session -> {
                            session.doWork(connection -> {
                                if (renameMode == RenameMode.TO_BE_DONE_BY_US) {
                                    UserRenameServiceImpl.this.bambooUserManager.renameUser(oldUserName, this.val$newUserNameLocal);
                                } else {
                                    UserRenameServiceImpl.this.bambooUserManager.onExternalUserRename(oldUserName, this.val$newUserNameLocal);
                                    UserRenameServiceImpl.this.doRenameUser(connection, oldUserName, this.val$newUserNameLocal, this.val$isLocalUser);
                                }
                            });
                            return null;
                        });
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)"error while renaming user", (Throwable)e);
                throw new UserRenameException("Error while renaming user", (Throwable)e);
            }
            return null;
        });
        this.immutablePlanCacheService.invalidateAllLatestResultSummaries();
        CrossNodesRemoteBroadcasterImpl.getComponentAccessor().ifPresentOrElse(c -> c.send((CrossNodesEvent)InvalidateAllLatestResultSummariesEvent.create()), () -> log.debug((Object)"Cross-node broadcaster not defined. Event cannot be sent to other nodes"));
    }

    private boolean isLocalUser(@NotNull String oldUserName, @NotNull String newUserName, RenameMode renameMode) throws UserNotFoundException {
        if (renameMode == RenameMode.ALREADY_DONE_EXTERNALLY) {
            return false;
        }
        String userNameToCheck = renameMode == RenameMode.ALREADY_DONE_IN_CROWD ? newUserName : oldUserName;
        User user = this.crowdService.getUser(userNameToCheck);
        if (user == null) {
            throw new UserNotFoundException("User " + oldUserName + " does not exist");
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        return directory.getImplementationClass().equals(InternalDirectory.class.getCanonicalName());
    }

    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent userRenamedEvent) {
        try {
            this.renameUser(userRenamedEvent.getOldUsername(), userRenamedEvent.getUser().getName(), RenameMode.ALREADY_DONE_IN_CROWD);
        }
        catch (UserRenameException e) {
            throw BambooThrowables.propagate((Throwable)e);
        }
    }

    private void doRenameUser(Connection connection, @Nullable String oldUserName, @Nullable String newUserName, boolean isLocalUser) throws SQLException {
        this.userRenameHelper.renameUserInAcl(connection, oldUserName, newUserName, this.dbmsBean);
        this.hibernateMutableAclService.invalidateCache();
        this.userRenameHelper.renameUserInOsPropertySet(connection, oldUserName, newUserName, isLocalUser, this.dbmsBean);
        this.userRenameHelper.renameUserInRememberMeToken(connection, oldUserName, newUserName, this.dbmsBean);
        this.userRenameHelper.renameUserInAuthAttemptInfo(connection, oldUserName, newUserName, this.dbmsBean);
        this.userRenameHelper.renameUserInAuthors(connection, oldUserName, newUserName, this.dbmsBean);
        this.userRenameHelper.renameUserInPasswordResetToken(connection, oldUserName, newUserName, this.dbmsBean);
        this.userRenameHelper.renameUserInLabellings(connection, oldUserName, newUserName, this.dbmsBean);
        this.userRenameHelper.renameUserInAccessTokens(connection, oldUserName, newUserName, this.dbmsBean);
        this.avatarService.moveForUser(oldUserName, newUserName);
        if (SystemProperty.RENAME_USER_IN_HISTORICAL_DATA.getTypedValue()) {
            this.userRenameHelper.renameUserInComments(connection, oldUserName, newUserName, this.dbmsBean);
            this.userRenameHelper.renameUserInAuditLog(connection, oldUserName, newUserName, this.dbmsBean);
            this.userRenameHelper.renameUserInManualTriggerHistory(connection, oldUserName, newUserName, this.dbmsBean);
        } else {
            log.info((Object)"Not performing user rename in USER_COMMENT, AUDIT_LOG, BUILDRESULTSUMMARY_CUSTOMDATA and DEPLOYMENT_RESULT_CUSTOMDATA");
        }
        for (UserRenameHandlerModuleDescriptor moduleDescriptor : this.pluginAccessor.getEnabledModuleDescriptorsByClass(UserRenameHandlerModuleDescriptor.class)) {
            UserRenameHandler renameHandler = (UserRenameHandler)moduleDescriptor.getModule();
            if (renameHandler == null) continue;
            try {
                renameHandler.onRenameUser(oldUserName, newUserName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.eventPublisher.publish((Object)new UserRenameEvent(oldUserName, newUserName));
    }

    private static enum RenameMode {
        TO_BE_DONE_BY_US,
        ALREADY_DONE_EXTERNALLY,
        ALREADY_DONE_IN_CROWD;

    }
}

