/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDbmsBean
implements DbmsBean {
    private static final Logger log = Logger.getLogger(AbstractDbmsBean.class);
    public static final int LARGE_STRING_TYPE = 123450000;
    private final AtomicReference<Optional<String>> cachedSchema = new AtomicReference();

    public boolean isColumnPresent(@NotNull Connection connection, @NotNull String tableName, @NotNull String columnName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            boolean bl = this.isColumnPresent(statement, tableName, columnName);
            return bl;
        }
    }

    public boolean isColumnPresent(@NotNull Statement statement, @NotNull String tableName, @NotNull String columnName) throws SQLException {
        return this.isColumnPresent(statement, tableName, columnName::equalsIgnoreCase);
    }

    protected boolean isColumnPresent(Statement statement, String tableName, Predicate<String> columnNamePredicate) throws SQLException {
        if (this.isTablePresent(statement.getConnection(), tableName)) {
            try (ResultSet testQueryResultSet = statement.executeQuery("SELECT * FROM " + tableName + " WHERE 0 = 1");){
                ResultSetMetaData rsmd = testQueryResultSet.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    if (!columnNamePredicate.test(rsmd.getColumnName(i))) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public void changeColumnType(Connection c, String table, String column, int type, @Nullable Integer columnSize, boolean isNullable) throws SQLException {
        String sqlType = this.getSqlTypeName(type);
        this.changeColumnDefinition(c, table, column, sqlType, isNullable);
    }

    @NotNull
    protected String getSqlTypeName(int type) {
        return switch (type) {
            case 2 -> "numeric";
            case -5 -> "bigint";
            case 4 -> "integer";
            default -> throw new IllegalArgumentException("Unknown type " + type);
        };
    }

    protected DbmsBean.ConstraintDefinition.ConstraintType getConstraintType(String typeName) {
        return switch (typeName) {
            case "FOREIGN KEY" -> DbmsBean.ConstraintDefinition.ConstraintType.FOREIGN_KEY;
            case "PRIMARY KEY" -> DbmsBean.ConstraintDefinition.ConstraintType.PRIMARY_KEY;
            case "UNIQUE" -> DbmsBean.ConstraintDefinition.ConstraintType.UNIQUE;
            case "CHECK" -> DbmsBean.ConstraintDefinition.ConstraintType.CHECK;
            default -> throw new IllegalArgumentException("Unknown constraint type " + typeName);
        };
    }

    protected List<DbmsBean.ConstraintDefinition> getConstraintDefinitions(Connection connection, String query, @Nullable String column, @Nullable Function<String, String> nullableNameProcessor) throws SQLException {
        Function<Object, Object> nameProcessor = nullableNameProcessor == null ? Function.identity() : nullableNameProcessor;
        HashMultimap constraints = HashMultimap.create();
        Function<ResultSet, Void> collectConstraintData = resultSet -> {
            String name = (String)nameProcessor.apply(JdbcUtils.getString(resultSet, 1));
            String constraintColumn = (String)nameProcessor.apply(JdbcUtils.getString(resultSet, 2));
            String typeName = JdbcUtils.getString(resultSet, 3);
            DbmsBean.ConstraintDefinition.ConstraintType type = this.getConstraintType(typeName);
            constraints.put((Object)Pair.of((Object)name, (Object)type), (Object)constraintColumn);
            return null;
        };
        JdbcUtils.executeQuery(connection, collectConstraintData, query, new String[0]);
        return constraints.asMap().entrySet().stream().filter(entry -> {
            if (column == null) return true;
            if (!((Collection)entry.getValue()).stream().anyMatch(column::equalsIgnoreCase)) return false;
            return true;
        }).map(entry -> {
            Pair nameAndType = (Pair)entry.getKey();
            String name = nameProcessor != null ? (String)nameProcessor.apply((String)nameAndType.getLeft()) : (String)nameAndType.getLeft();
            return new DbmsBean.ConstraintDefinition(name, (DbmsBean.ConstraintDefinition.ConstraintType)nameAndType.getRight(), (Collection)entry.getValue());
        }).collect(Collectors.toList());
    }

    protected void changeColumnDefinition(Connection c, String table, String column, String sqlType, boolean isNullable) throws SQLException {
        JdbcUtils.execute(c, "alter table %s alter column %s %s %s", table, column, sqlType, isNullable ? "" : "not null");
    }

    public void migrateColumnType(Connection c, String table, String column, int columnType, @Nullable Integer columnSize) throws SQLException {
        String tmpColumn = column + "__";
        if (!this.isColumnPresent(c, table, tmpColumn)) {
            this.renameColumn(c, table, column, tmpColumn);
        } else {
            log.warn((Object)("Column " + tmpColumn + " detected in " + table + ", assuming rename already happened."));
        }
        if (!this.isColumnPresent(c, table, column)) {
            this.addColumn(c, table, column, columnType, columnSize);
        } else {
            log.warn((Object)("Column " + column + " detected in " + table + ", assuming column addition already happened."));
        }
        JdbcUtils.execute(c, "update %s set %s=%s", table, column, tmpColumn);
        c.commit();
        this.dropColumn(c, table, tmpColumn);
    }

    public boolean dropColumn(@NotNull Connection connection, @NotNull String tableName, @NotNull String columnName) throws SQLException {
        if (!this.isColumnPresent(connection, tableName, columnName)) {
            return false;
        }
        if (this.isMsSqlServer()) {
            for (String indexName : this.getIndexNames(connection, tableName, columnName)) {
                this.dropIndex(connection, tableName, indexName);
            }
        }
        this.dropConstraints(connection, tableName, columnName);
        this.dropColumnInternal(connection, tableName, columnName);
        return true;
    }

    public void createColumn(@NotNull Connection connection, @NotNull String tableName, @NotNull String columnName, @NotNull int columnType) throws SQLException {
        if (!this.isColumnPresent(connection, tableName, columnName)) {
            try (Statement statement = connection.createStatement();){
                String alterTableQueryFormat = this.getAddColumnQuery();
                String alterTableQuery = String.format(alterTableQueryFormat, tableName, columnName, this.getSqlTypeName(columnType));
                statement.execute(alterTableQuery);
            }
        } else {
            DbmsBean.ColumnDefinition columnDefinition = this.getColumnDefinition(connection, tableName, columnName);
            if (columnDefinition != null && columnDefinition.getDataType() != columnType) {
                throw new IllegalStateException(String.format("Can't create column %s in table %s since it's already there with different type: %d", columnName, tableName, columnDefinition.getDataType()));
            }
        }
    }

    @NotNull
    private String getAddColumnQuery() {
        boolean requiresColumnKeyword = !this.isMsSqlServer() && !this.isOracle();
        return requiresColumnKeyword ? "alter table %S add column %s %s" : "alter table %S add %s %s";
    }

    private boolean dropColumnInternal(@NotNull Connection connection, @NotNull String tableName, @NotNull String columnName) throws SQLException {
        if (this.isColumnPresent(connection, tableName, columnName)) {
            try (Statement statement = connection.createStatement();){
                statement.execute(String.format("alter table %s drop column %s", tableName, columnName));
            }
            return true;
        }
        return false;
    }

    protected void dropConstraints(Connection connection, String tableName, String columnName) {
    }

    public void dropIndex(Connection c, String table, String index) throws SQLException {
        JdbcUtils.execute(c, "drop index %s on %s", index, table);
    }

    public boolean dropIndexIfExists(Connection c, String table, @NotNull String indexName) throws SQLException {
        Optional<String> existingIndex = this.getIndexNames(c, table, null).stream().filter(indexName::equalsIgnoreCase).findAny();
        boolean exists = existingIndex.isPresent();
        if (exists) {
            this.dropIndex(c, table, existingIndex.get());
        }
        return exists;
    }

    public void createIndex(Connection c, String index, String table, String column) throws SQLException {
        try {
            JdbcUtils.execute(c, "create index %s on %s (%s)", index, table, column);
            c.commit();
        }
        catch (SQLException e) {
            c.rollback();
            throw e;
        }
    }

    public void createUniqueConstraint(Connection c, String uniqueKey, String table, String ... columns) throws SQLException {
        String list = Joiner.on((String)", ").join((Object[])columns);
        JdbcUtils.execute(c, "alter table %s add constraint %s unique (%s)", table, uniqueKey, list);
    }

    public boolean isTablePresent(@NotNull Connection c, @NotNull String tableName) throws SQLException {
        try (ResultSet tables = c.getMetaData().getTables(this.getCatalog(c), this.getSchema(c), tableName, null);){
            if (tables.next()) {
                List<String> table1 = JdbcUtils.getRowData(tables);
                if (tables.next()) {
                    List<String> table2 = JdbcUtils.getRowData(tables);
                    throw new IllegalStateException("More than one " + tableName + " table found: " + table1 + " and " + table2);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public List<String> getTables(@NotNull Connection c) throws SQLException {
        try (ResultSet tables = c.getMetaData().getTables(this.getCatalog(c), this.getSchema(c), null, null);){
            List<List<String>> allTableData = JdbcUtils.getAllRows(tables, this::isTable);
            List<String> list = allTableData.stream().map(def -> (String)def.get(2)).map(this::quoteIfNeeded).collect(Collectors.toList());
            return list;
        }
    }

    protected boolean isTable(List<String> definitionColumns) {
        return true;
    }

    public void changeTableNameToUpperCase(Connection connection, String oldName) throws SQLException {
    }

    public abstract void renameColumn(Connection var1, String var2, String var3, String var4) throws SQLException;

    public void addColumn(Connection c, String tableName, String columnName, int columnType, Integer columnSize) throws SQLException {
        String columnSpec = this.getColumnDefinitionString(columnType);
        JdbcUtils.execute(c, "alter table %s add %s %s", tableName, columnName, columnSpec);
    }

    public void dropConstraint(Connection c, String tableName, String constraint) throws SQLException {
        JdbcUtils.execute(c, "alter table %s drop constraint %s", tableName, constraint);
    }

    public void dropForeignKeyConstraint(Connection c, String tableName, String foreignKey) throws SQLException {
        this.dropConstraint(c, tableName, foreignKey);
    }

    public void dropTable(Connection c, String tableName) throws SQLException {
        JdbcUtils.execute(c, "drop table %s", tableName);
    }

    public void changeColumnToNotNull(Connection c, String tableName, String columnName) throws SQLException {
        DbmsBean.ColumnDefinition columnDefinition = this.getColumnDefinition(c, tableName, columnName);
        Objects.requireNonNull(columnDefinition, "Column [" + columnName + "] not found in [" + tableName + "]");
        if (columnDefinition.isNullable().orElse(true).booleanValue()) {
            this.actuallyChangeColumnToNotNull(c, tableName, columnName);
        }
    }

    protected void actuallyChangeColumnToNotNull(Connection c, String tableName, String columnName) throws SQLException {
        JdbcUtils.execute(c, "alter table %s alter column %s set not null", tableName, columnName);
        c.commit();
    }

    public String quote(String name) {
        return "\"" + name + "\"";
    }

    @NotNull
    public String clobEquals(@NotNull String columnName) {
        return columnName + " = ?";
    }

    protected String quoteIfNeeded(String name) {
        return name;
    }

    protected String unquoteIfNeeded(String name) {
        return name;
    }

    public Set<String> getIndexNames(@NotNull Connection c, @NotNull String table, @Nullable String column) throws SQLException {
        return this.getIndices(c, table).stream().filter(index -> column == null || AbstractDbmsBean.containsIgnoreCase(index.getColumns(), column)).map(DbmsBean.IndexDefinition::getName).collect(Collectors.toSet());
    }

    public boolean hasIndexOnColumns(Connection c, String tableName, List<String> columns) throws SQLException {
        return this.getIndices(c, tableName).stream().anyMatch(index -> {
            if (index.getColumns().size() != columns.size()) {
                return false;
            }
            return columns.stream().allMatch(column -> this.containsIgnoreCaseAndQuotes(index.getColumns(), (String)column));
        });
    }

    public Collection<DbmsBean.IndexDefinition> getIndices(@NotNull Connection c, @NotNull String table) throws SQLException {
        HashMap<String, ArrayList> indexColumns = new HashMap<String, ArrayList>();
        try (ResultSet indexInfoRs = c.getMetaData().getIndexInfo(this.getCatalog(c), this.getSchema(c), table, false, false);){
            while (indexInfoRs.next()) {
                String indexName = indexInfoRs.getString(6);
                if (indexName == null) continue;
                List columnNames = indexColumns.computeIfAbsent(indexName, k -> new ArrayList());
                columnNames.add(indexInfoRs.getString(9));
            }
        }
        return indexColumns.entrySet().stream().map(entry -> new DbmsBean.IndexDefinition((String)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList());
    }

    public List<DbmsBean.ColumnDefinition> getColumns(Connection c, @NotNull String table, @Nullable String column) throws SQLException {
        String database = this.getCatalog(c);
        String schema = this.getSchema(c);
        ArrayList<DbmsBean.ColumnDefinition> columnDefinitions = new ArrayList<DbmsBean.ColumnDefinition>();
        try (ResultSet rs = c.getMetaData().getColumns(database, schema, table, column);){
            while (rs.next()) {
                List<String> columnData = JdbcUtils.getRowData(rs);
                log.debug(columnData);
                String columnName = rs.getString(4);
                int dataType = rs.getInt(5);
                String dataTypeName = rs.getString(6);
                int columnSizeOrZero = rs.getInt(7);
                OptionalInt columnSize = columnSizeOrZero == 0 ? OptionalInt.empty() : OptionalInt.of(columnSizeOrZero);
                String isNullableString = rs.getString(18);
                Optional<Boolean> isNullable = Optional.ofNullable(BooleanUtils.toBooleanObject((String)isNullableString));
                columnDefinitions.add(this.newColumnDefinition(columnName, dataType, dataTypeName, columnSize, isNullable));
            }
        }
        return columnDefinitions;
    }

    protected void createPrimaryKey(Connection c, String table, String pkName, Collection<String> columns) throws SQLException {
        String columnsString = String.join((CharSequence)",", columns);
        JdbcUtils.execute(c, "alter table %s add constraint %s primary key (%s)", table, pkName, columnsString);
    }

    protected DbmsBean.ColumnDefinition newColumnDefinition(String columnName, int dataType, String dataTypeName, OptionalInt columnSize, Optional<Boolean> isNullable) {
        return new DbmsBean.ColumnDefinition(columnName, dataType, dataTypeName, columnSize, isNullable);
    }

    @Nullable
    protected DbmsBean.ColumnDefinition getColumnDefinition(Connection connection, String tableName, @Nullable String columnName) throws SQLException {
        List<DbmsBean.ColumnDefinition> columns = this.getColumns(connection, tableName, columnName);
        if (columns.isEmpty()) {
            return null;
        }
        if (columns.size() > 1) {
            throw new IllegalStateException(String.format("Found more than one column [%s] in [%s:%s:%s]", columnName, this.getCatalog(connection), this.getSchema(connection), tableName));
        }
        return columns.get(0);
    }

    @Nullable
    public String getSchema(Connection c) throws SQLException {
        if (this.cachedSchema.get() != null) {
            return this.cachedSchema.get().orElse(null);
        }
        String schema = this.getSchemaUncached(c);
        log.info((Object)("Detected schema: " + schema));
        this.cachedSchema.set(Optional.ofNullable(schema));
        return schema;
    }

    @Nullable
    protected String getSchemaUncached(Connection c) throws SQLException {
        return c.getSchema();
    }

    public String getLargeTextTypeName() {
        return this.getColumnDefinitionString(123450000);
    }

    public String getColumnDefinitionString(int columnType) {
        if (columnType == 123450000) {
            return switch (this.getDatabaseType()) {
                case DatabaseType.MSSQL -> "ntext";
                case DatabaseType.MYSQL -> "longtext";
                case DatabaseType.ORACLE -> "clob";
                case DatabaseType.POSTGRESQL -> "text";
                case DatabaseType.H2 -> "varchar";
                default -> throw new IllegalArgumentException("Unknown database type " + this.getDatabaseType());
            };
        }
        if (columnType == 16) {
            return switch (this.getDatabaseType()) {
                case DatabaseType.MSSQL -> "tinyint";
                case DatabaseType.MYSQL -> "boolean";
                case DatabaseType.ORACLE -> "number (1)";
                case DatabaseType.POSTGRESQL -> "boolean";
                case DatabaseType.H2 -> "boolean";
                default -> throw new IllegalArgumentException("Unknown database type: " + this.getDatabaseType());
            };
        }
        if (columnType == 4) {
            return switch (this.getDatabaseType()) {
                case DatabaseType.MSSQL -> "int";
                case DatabaseType.MYSQL, DatabaseType.ORACLE, DatabaseType.POSTGRESQL, DatabaseType.H2 -> "integer";
                default -> throw new IllegalArgumentException("Unknown database type: " + this.getDatabaseType());
            };
        }
        if (columnType == -5) {
            return switch (this.getDatabaseType()) {
                case DatabaseType.POSTGRESQL -> "int8";
                case DatabaseType.ORACLE -> "number(19,0)";
                case DatabaseType.MSSQL, DatabaseType.MYSQL, DatabaseType.H2 -> "bigint";
                default -> throw new IllegalArgumentException("Unknown database type: " + this.getDatabaseType());
            };
        }
        throw new IllegalArgumentException("Unsupported column type " + columnType);
    }

    public String toLowerCase(String columnName) {
        switch (this.getDatabaseType()) {
            case MYSQL: 
            case HSQL: {
                return String.format("LCASE(%s)", columnName);
            }
        }
        return String.format("LOWER(%s)", columnName);
    }

    public boolean isH2() {
        return false;
    }

    public boolean isMsSqlServer() {
        return false;
    }

    public boolean isMySql() {
        return false;
    }

    public boolean isOracle() {
        return false;
    }

    public boolean isPostgreSql() {
        return false;
    }

    private static boolean containsIgnoreCase(Collection<String> strings, @Nullable String string) {
        return strings.stream().anyMatch(s -> s.equalsIgnoreCase(string));
    }

    private boolean containsIgnoreCaseAndQuotes(Collection<String> strings, @Nullable String string) {
        return strings.stream().anyMatch(s -> this.unquoteIfNeeded((String)s).equalsIgnoreCase(this.unquoteIfNeeded(string)));
    }
}

