/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.DbmsBeanFactory;
import com.atlassian.bamboo.utils.db.H2DbmsBean;
import com.atlassian.bamboo.utils.db.MsSqlDbmsBean;
import com.atlassian.bamboo.utils.db.MySqlDbmsBean;
import com.atlassian.bamboo.utils.db.OracleDbmsBean;
import com.atlassian.bamboo.utils.db.PostgreSqlDbmsBean;
import com.atlassian.config.db.HibernateConfig;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DbmsBeanFactoryImpl
implements DbmsBeanFactory {
    private static final Logger log = Logger.getLogger(DbmsBeanFactoryImpl.class);
    private final HibernateConfig hibernateConfig;

    public DbmsBeanFactoryImpl(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    @NotNull
    public DbmsBean createDbmsBean() {
        if (!this.isHibernateSetup()) {
            throw new IllegalStateException("Can't create DbmsBean because Hibernate is not configured");
        }
        String hibernateDialect = this.hibernateConfig.getHibernateProperties().getProperty("hibernate.dialect");
        DatabaseType databaseType = DatabaseType.fromDialect((String)hibernateDialect);
        if (databaseType != null) {
            switch (databaseType) {
                case MYSQL: {
                    return new MySqlDbmsBean();
                }
                case ORACLE: {
                    return new OracleDbmsBean();
                }
                case H2: {
                    return new H2DbmsBean();
                }
                case POSTGRESQL: {
                    return new PostgreSqlDbmsBean();
                }
                case MSSQL: {
                    return new MsSqlDbmsBean();
                }
            }
        }
        throw new IllegalStateException(String.format("Can't create DbmsBean due to unknown Hibernate dialect %s", hibernateDialect));
    }

    private boolean isHibernateSetup() {
        return this.hibernateConfig.isHibernateSetup();
    }
}

