/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.bamboo.utils.db.AbstractDbmsBean;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.atlassian.bamboo.utils.db.SqlQueryProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2DbmsBean
extends AbstractDbmsBean {
    private static final Logger log = Logger.getLogger(H2DbmsBean.class);

    @NotNull
    public String getQuery(@NotNull SqlQueryProvider sqlQueryProvider) {
        return sqlQueryProvider.getH2Query();
    }

    @NotNull
    public String getConcat(String ... values) {
        return Joiner.on((String)" || ").join((Object[])values);
    }

    @NotNull
    public Collection<DbmsBean.ConstraintDefinition> getConstraints(Connection connection, String table, @Nullable String column) throws SQLException {
        String catalog;
        StringBuilder queryBuilder = new StringBuilder().append("select constraint_name, index_columns.column_name, constraint_type from information_schema.table_constraints ").append("join information_schema.index_columns on index_columns.index_name=table_constraints.index_name ").append(String.format("where upper(table_constraints.TABLE_NAME) = '%s' ", table.toUpperCase()));
        String schema = this.getSchema(connection);
        if (schema != null) {
            queryBuilder.append(String.format("and table_constraints.TABLE_SCHEMA = '%s' ", schema));
        }
        if ((catalog = this.getCatalog(connection)) != null) {
            queryBuilder.append(" and constraint_catalog='" + catalog + "' ");
        }
        return this.getConstraintDefinitions(connection, queryBuilder.toString(), column, null);
    }

    @Override
    protected DbmsBean.ConstraintDefinition.ConstraintType getConstraintType(String typeName) {
        return switch (typeName) {
            case "REFERENTIAL", "FOREIGN KEY" -> DbmsBean.ConstraintDefinition.ConstraintType.FOREIGN_KEY;
            case "PRIMARY_KEY", "PRIMARY KEY" -> DbmsBean.ConstraintDefinition.ConstraintType.PRIMARY_KEY;
            case "UNIQUE" -> DbmsBean.ConstraintDefinition.ConstraintType.UNIQUE;
            case "CHECK" -> DbmsBean.ConstraintDefinition.ConstraintType.CHECK;
            default -> throw new IllegalArgumentException("Unknown constraint type " + typeName);
        };
    }

    public void resizeVarcharColumn(@NotNull Connection connection, String tableName, String columnName, int newSize, boolean isNullable, @Nullable String defaultValue) throws SQLException {
        String command = String.format("alter table %s alter column %s varchar(%d);", tableName, columnName, newSize);
        JdbcUtils.execute(connection, command, new String[0]);
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.H2;
    }

    @Override
    public boolean isH2() {
        return true;
    }

    public void dropPrimaryKey(Connection connection, String tableName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("alter table " + tableName + " drop primary key");
        }
        catch (SQLException e) {
            this.handleException(connection, tableName, e, (BambooRunnables.Throwing<SQLException>)((BambooRunnables.Throwing)() -> this.dropPrimaryKey(connection, tableName)));
        }
    }

    @Override
    public void renameColumn(Connection c, String tableName, String oldName, String newName) throws SQLException {
        JdbcUtils.execute(c, "alter table %s alter column %s rename to %s", tableName, oldName, newName);
    }

    @Override
    public void dropIndex(Connection c, String table, String index) throws SQLException {
        try {
            JdbcUtils.execute(c, "drop index %s", index);
        }
        catch (SQLException e) {
            this.handleException(c, table, e, (BambooRunnables.Throwing<SQLException>)((BambooRunnables.Throwing)() -> this.dropIndex(c, table, index)));
        }
    }

    @NotNull
    private String getConstraintSqlByName(Connection connection, String constraintName) throws SQLException {
        String query = "select SQL from information_schema.table_constraints " + String.format("where upper(constraint_name) = '%s' ", constraintName.toUpperCase());
        Function<ResultSet, String> collectConstraintData = resultSet -> JdbcUtils.getString(resultSet, 1);
        return JdbcUtils.executeQuery(connection, collectConstraintData, query, new String[0]).get(0);
    }

    @VisibleForTesting
    protected void handleException(@NotNull Connection connection, @NotNull String table, @NotNull SQLException e, @NotNull BambooRunnables.Throwing<SQLException> command) throws SQLException {
        String exceptionClassName = e.getClass().getSimpleName();
        String errorMessage = e.getMessage();
        log.info((Object)String.format("Attempting to handle exception %s: %s", exceptionClassName, errorMessage));
        Pattern indexBelongsToConstraintPattern = Pattern.compile("index \"([\\w_]+)\" belongs to constraint \"([\\w_]+)\"", 2);
        Matcher matcher = indexBelongsToConstraintPattern.matcher(errorMessage);
        if (matcher.find()) {
            String constraintName = matcher.group(2);
            this.dropAndRecreateConstraint(connection, table, constraintName, command);
            return;
        }
        log.info((Object)String.format("Couldn't handle exception %s: %s", exceptionClassName, errorMessage));
        throw e;
    }

    @VisibleForTesting
    void dropAndRecreateConstraint(@NotNull Connection connection, @NotNull String table, @NotNull String constraintName, @NotNull BambooRunnables.Throwing<SQLException> command) throws SQLException {
        String constraintSql = this.getConstraintSqlByName(connection, constraintName);
        log.info((Object)("dropping constraint " + constraintName + " on table " + table));
        this.dropConstraint(connection, table, constraintName);
        command.run();
        log.info((Object)String.format("recreating constraint %s on table %s (%s)", constraintName, table, constraintSql));
        JdbcUtils.execute(connection, constraintSql, new String[0]);
    }

    @Override
    public Collection<DbmsBean.IndexDefinition> getIndices(@NotNull Connection c, @NotNull String table) throws SQLException {
        return super.getIndices(c, table.toUpperCase());
    }
}

