/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JdbcUtils {
    private static final Logger log = Logger.getLogger(JdbcUtils.class);
    public static final Function<ResultSet, Void> LOG_RESULT = resultSet -> {
        try {
            log.debug(JdbcUtils.getRowData(resultSet));
        }
        catch (SQLException e) {
            log.warn((Object)"", (Throwable)e);
        }
        return null;
    };

    private JdbcUtils() {
    }

    public static boolean executeQuietly(Statement statement, String query) {
        try {
            statement.execute(query);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Connection connection, String queryToFormat, String ... args) throws SQLException {
        String query = String.format(queryToFormat, args);
        log.debug((Object)("Executing: [" + query + "]"));
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (Statement statement = connection.createStatement();){
            statement.execute(query);
        }
        finally {
            log.trace((Object)("Executing: [" + query + "] took " + stopwatch));
        }
    }

    public static String executeSingleValueQuery(Connection connection, String sql, String ... args) throws SQLException {
        return JdbcUtils.getOnlyElement(JdbcUtils.executeQuery(connection, JdbcUtils.getColumnValue(1), sql, args));
    }

    public static <T> List<T> executeQuery(Connection connection, Function<ResultSet, T> function, String queryToFormat, String ... args) throws SQLException {
        ArrayList<T> result = new ArrayList<T>();
        String query = String.format(queryToFormat, args);
        log.debug((Object)("Executing: [" + query + "]"));
        try (Ticker ignored = Timers.start((String)("Executing: [" + query + "]"));){
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(query);){
                while (resultSet.next()) {
                    result.add(function.apply(resultSet));
                }
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
    }

    public static boolean isTablePresent(@NotNull Connection connection, @NotNull String tableName) {
        try {
            JdbcUtils.execute(connection, "select count (*) from " + tableName, new String[0]);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static int runDeleteQuery(@NotNull Connection connection, @NotNull String query, @NotNull String entityName) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(query);){
            int n = JdbcUtils.runDeleteQuery(statement, query, entityName);
            return n;
        }
    }

    public static int runDeleteQuery(@NotNull PreparedStatement statement, @NotNull String query, @NotNull String entityName) {
        int n;
        block8: {
            Ticker ignored = Timers.start((String)query);
            try {
                n = statement.executeUpdate();
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String message = String.format("Exception removing %s running '%s'", entityName, query);
                    log.warn((Object)message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            }
            ignored.close();
        }
        return n;
    }

    public static int runUpdateQuery(@NotNull PreparedStatement statement, @NotNull String query, @NotNull String entityName) throws SQLException {
        int n;
        block8: {
            Ticker ignored = Timers.start((String)query);
            try {
                n = statement.executeUpdate();
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String message = String.format("Exception when handling %s, running [%s]", entityName, query);
                    log.warn((Object)message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            }
            ignored.close();
        }
        return n;
    }

    @NotNull
    public static List<Long> getListOfLong(@NotNull Connection c, @NotNull String query) throws SQLException {
        return JdbcUtils.executeQuery(c, rs -> JdbcUtils.getLong(rs, 1), query, new String[0]);
    }

    public static <T> List<T> map(ResultSet resultSet, Function<ResultSet, T> function) throws SQLException {
        ArrayList<T> list = new ArrayList<T>();
        while (resultSet.next()) {
            list.add(function.apply(resultSet));
        }
        return list;
    }

    public static int runDeleteQuery(@NotNull Connection connection, @NotNull String tableName, @NotNull String idColumn, @NotNull Iterable<? extends BambooIdProvider> objects) throws SQLException {
        if (Iterables.isEmpty(objects)) {
            return 0;
        }
        String uppercaseTableName = tableName.toUpperCase();
        String uppercaseIdColumn = idColumn.toUpperCase();
        String ids = BambooIterables.stream(objects).map(BambooIdProvider::getId).map(Object::toString).collect(Collectors.joining(","));
        return JdbcUtils.runDeleteQuery(connection, String.format("delete from %s where %s in (%s)", uppercaseTableName, uppercaseIdColumn, ids), uppercaseTableName);
    }

    public static Function<ResultSet, String> getColumnValue(int columnIndex) {
        return resultSet -> JdbcUtils.getString(resultSet, columnIndex);
    }

    private static <T> T getOnlyElement(List<T> names) throws SQLException {
        if (names.size() != 1) {
            throw new SQLException("Expected one name, found: " + names);
        }
        return names.get(0);
    }

    public static List<String> getRowData(ResultSet rs) throws SQLException {
        ArrayList<String> columnValues = new ArrayList<String>();
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            columnValues.add(rs.getString(i));
        }
        return columnValues;
    }

    public static List<List<String>> getAllRows(ResultSet rs) {
        return JdbcUtils.getAllRows(rs, t -> true);
    }

    public static List<List<String>> getAllRows(ResultSet rs, Predicate<List<String>> filter) {
        try {
            ArrayList<List<String>> rows = new ArrayList<List<String>>();
            while (rs.next()) {
                List<String> rowData = JdbcUtils.getRowData(rs);
                if (!filter.test(rowData)) continue;
                rows.add(rowData);
            }
            return rows;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getString(ResultSet resultSet, int columnIndex) {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getLong(ResultSet resultSet, int columnIndex) {
        try {
            return resultSet.getLong(columnIndex);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Function<ResultSet, String> getString(int columnIndex) {
        return rs -> {
            try {
                return rs.getString(columnIndex);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

