/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import com.atlassian.bamboo.utils.db.AbstractDbmsBean;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.atlassian.bamboo.utils.db.SqlQueryProvider;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsSqlDbmsBean
extends AbstractDbmsBean {
    private static final Logger log = Logger.getLogger(MsSqlDbmsBean.class);
    private static final String RENAME_TABLE = "EXEC sp_rename '%s', '%s'";
    private static final String RENAME_COLUMN = "EXECUTE sp_rename '%s.%s', '%s', 'COLUMN'";
    private static final String FIND_DEFAULT_CONSTRAINTS_FOR_TABLE = "select dc.NAME as CONSTRAINT_NAME, c.NAME as COLUMN_NAME, 'CHECK' as CONSTRAINT_TYPE from sys.tables t  inner join sys.default_constraints dc on t.OBJECT_ID = dc.PARENT_OBJECT_ID  inner join sys.columns c on dc.PARENT_OBJECT_ID = c.OBJECT_ID AND c.COLUMN_ID = dc.PARENT_COLUMN_ID   inner join sys.schemas sc on sc.SCHEMA_ID = t.SCHEMA_ID where lower(t.NAME) = '%s' and sc.NAME = '%s'";
    private static final String FIND_FOREIGN_KEY_CONSTRAINTS_FOR_TABLE = "select obj.NAME as CONSTRAINT_NAME, col1.NAME as COLUMN_NAME, 'FOREIGN KEY' as CONSTRAINT_TYPE from sys.foreign_key_columns fkc  inner join sys.objects obj    on obj.OBJECT_ID = fkc.CONSTRAINT_OBJECT_ID  inner join sys.tables t    on t.OBJECT_ID = fkc.PARENT_OBJECT_ID  inner join sys.columns col1    on col1.COLUMN_ID = fkc.PARENT_COLUMN_ID and col1.OBJECT_ID = t.OBJECT_ID   inner join sys.schemas sc on sc.SCHEMA_ID = t.SCHEMA_ID where lower(t.NAME) = '%s' and sc.NAME = '%s'";
    private static final String FIND_PRIMARY_AND_UNIQUE_CONSTRAINTS_FOR_TABLE = "select kc.NAME as CONSTRAINT_NAME, c.NAME AS COLUMN_NAME,(case kc.type_desc when 'PRIMARY_KEY_CONSTRAINT' then 'PRIMARY KEY' when 'UNIQUE_CONSTRAINT' then 'UNIQUE' end) as CONSTRAINT_TYPE from sys.key_constraints kc  inner join sys.tables t    on t.OBJECT_ID = kc.PARENT_OBJECT_ID  inner join sys.index_columns ic    on ic.OBJECT_ID = t.OBJECT_ID and ic.index_id = kc.UNIQUE_INDEX_ID  inner join sys.columns c    on c.OBJECT_ID = t.OBJECT_ID and c.COLUMN_ID = ic.COLUMN_ID   inner join sys.schemas sc on sc.SCHEMA_ID = t.SCHEMA_ID where lower(t.NAME) = '%s' and sc.NAME = '%s'";

    @NotNull
    public String getQuery(@NotNull SqlQueryProvider sqlQueryProvider) {
        return sqlQueryProvider.getMsSqlQuery();
    }

    @NotNull
    public String getConcat(String ... values) {
        return Joiner.on((String)" + ").join((Object[])values);
    }

    public void resizeVarcharColumn(@NotNull Connection connection, String tableName, String columnName, int newSize, boolean isNullable, @Nullable String defaultValue) throws SQLException {
        Set<String> indexNames = this.getIndexNames(connection, tableName, columnName);
        for (String indexName : indexNames) {
            this.dropIndex(connection, tableName, indexName);
        }
        JdbcUtils.execute(connection, "alter table " + tableName + " alter column " + columnName + " nvarchar(" + newSize + ")", new String[0]);
    }

    @Override
    public boolean isMsSqlServer() {
        return true;
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.MSSQL;
    }

    @Override
    public void dropIndex(Connection c, String table, String index) throws SQLException {
        if (index.toUpperCase().startsWith("PK__")) {
            this.dropConstraint(c, table, index);
        } else {
            super.dropIndex(c, table, index);
        }
    }

    @Override
    protected void dropConstraints(Connection connection, String tableName, String columnName) {
        boolean someConstraintsLeft = false;
        try {
            Collection<DbmsBean.ConstraintDefinition> constraintNames = this.getConstraints(connection, tableName, columnName);
            for (DbmsBean.ConstraintDefinition constraint : constraintNames) {
                try {
                    this.dropConstraint(connection, tableName, constraint.getName());
                }
                catch (SQLException e) {
                    someConstraintsLeft = true;
                    log.warn((Object)("Error when dropping " + constraint), (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (someConstraintsLeft) {
            log.warn((Object)"Some of the constraints weren't dropped");
        }
    }

    @Override
    public boolean isColumnPresent(@NotNull Statement statement, @NotNull String tableName, @NotNull String columnName) throws SQLException {
        return this.isColumnPresent(statement, tableName, columnName::equals);
    }

    public void dropPrimaryKey(Connection connection, String tableName) throws SQLException {
        String pkName = MsSqlDbmsBean.getPrimaryKeyName(connection, tableName);
        this.dropConstraint(connection, tableName, pkName);
    }

    @NotNull
    public Collection<DbmsBean.ConstraintDefinition> getConstraints(Connection connection, @NotNull String table, @Nullable String column) throws SQLException {
        String tableNameLowerCase = table.toLowerCase();
        String schema = this.getSchema(connection);
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"Schema was not defined, can't modify constraints without scheme");
        List<DbmsBean.ConstraintDefinition> defaultConstraints = this.getConstraintDefinitions(connection, String.format(FIND_DEFAULT_CONSTRAINTS_FOR_TABLE, tableNameLowerCase, schema), column, null);
        List<DbmsBean.ConstraintDefinition> foreignKeyConstraints = this.getConstraintDefinitions(connection, String.format(FIND_FOREIGN_KEY_CONSTRAINTS_FOR_TABLE, tableNameLowerCase, schema), column, null);
        List<DbmsBean.ConstraintDefinition> primaryAndUniqueKeyConstraints = this.getConstraintDefinitions(connection, String.format(FIND_PRIMARY_AND_UNIQUE_CONSTRAINTS_FOR_TABLE, tableNameLowerCase, schema), column, null);
        ArrayList<DbmsBean.ConstraintDefinition> result = new ArrayList<DbmsBean.ConstraintDefinition>();
        result.addAll(defaultConstraints);
        result.addAll(foreignKeyConstraints);
        result.addAll(primaryAndUniqueKeyConstraints);
        return result;
    }

    @NotNull
    private static String getPrimaryKeyName(Connection connection, String tableName) throws SQLException {
        String sql = "select name from sys.key_constraints where type = 'PK' and OBJECT_NAME(parent_object_id) = N'%s'";
        return JdbcUtils.executeSingleValueQuery(connection, "select name from sys.key_constraints where type = 'PK' and OBJECT_NAME(parent_object_id) = N'%s'", tableName);
    }

    @Override
    public void changeTableNameToUpperCase(Connection connection, String oldName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String newName = oldName.toUpperCase(Locale.ENGLISH);
            String tempName = this.getTemporaryName(newName);
            if (this.isTablePresent(connection, oldName)) {
                statement.execute(String.format(RENAME_TABLE, oldName, tempName));
                connection.commit();
            } else {
                log.info((Object)("Table " + oldName + " not found. Probably migrating from older Bamboo version."));
            }
            if (this.isTablePresent(connection, tempName)) {
                statement.execute(String.format(RENAME_TABLE, tempName, newName));
                connection.commit();
            }
        }
    }

    @Override
    public void renameColumn(Connection c, String tableName, String oldName, String newName) throws SQLException {
        try (Statement statement = c.createStatement();){
            String tempName = this.getTemporaryName(newName);
            if (this.isColumnPresent(statement, tableName, oldName)) {
                statement.execute(String.format(RENAME_COLUMN, tableName, oldName, tempName));
                c.commit();
            }
            if (this.isColumnPresent(statement, tableName, tempName)) {
                statement.execute(String.format(RENAME_COLUMN, tableName, tempName, newName));
                c.commit();
            }
        }
    }

    @Override
    @NotNull
    public String clobEquals(@NotNull String columnName) {
        return String.format("cast(%s as nvarchar(max)) = ?", columnName);
    }

    @Override
    protected DbmsBean.ColumnDefinition newColumnDefinition(String columnName, int dataType, String dataTypeName, OptionalInt columnSize, Optional<Boolean> isNullable) {
        int[] widthlessTypes = new int[]{-5, 4, -6};
        OptionalInt actualColumnSize = ArrayUtils.contains((int[])widthlessTypes, (int)dataType) ? OptionalInt.empty() : columnSize;
        return super.newColumnDefinition(columnName, dataType, dataTypeName, actualColumnSize, isNullable);
    }

    @Override
    public void actuallyChangeColumnToNotNull(Connection c, String tableName, String columnName) throws SQLException {
        DbmsBean.ColumnDefinition columnDefinition = this.getColumnDefinition(c, tableName, columnName);
        this.changeColumnDefinition(c, tableName, columnName, columnDefinition.getDataTypeName(), false);
    }

    @Override
    protected void changeColumnDefinition(Connection c, String table, String column, String sqlType, boolean isNullable) throws SQLException {
        Collection<DbmsBean.ConstraintDefinition> droppedConstraints = this.getConstraints(c, table, column);
        for (DbmsBean.ConstraintDefinition constraint : droppedConstraints) {
            this.dropConstraint(c, table, constraint.getName());
        }
        for (String index : this.getIndexNames(c, table, column)) {
            this.dropIndex(c, table, index);
        }
        super.changeColumnDefinition(c, table, column, sqlType, isNullable);
        for (DbmsBean.ConstraintDefinition constraint : droppedConstraints) {
            if (!constraint.isPrimaryKey()) continue;
            this.createPrimaryKey(c, table, constraint.getName(), constraint.getColumns());
        }
    }

    @Override
    @NotNull
    protected String getSqlTypeName(int type) {
        if (93 == type) {
            return "datetime2";
        }
        return super.getSqlTypeName(type);
    }

    @NotNull
    private String getTemporaryName(String name) {
        return name + "_tmp";
    }
}

