/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import com.atlassian.bamboo.utils.db.AbstractDbmsBean;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.atlassian.bamboo.utils.db.SqlQueryProvider;
import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MySqlDbmsBean
extends AbstractDbmsBean {
    private static final Logger log = Logger.getLogger(MySqlDbmsBean.class);
    private static final String RENAME_TABLE = "RENAME TABLE %s TO %s";

    @NotNull
    public String getQuery(@NotNull SqlQueryProvider sqlQueryProvider) {
        return sqlQueryProvider.getMySqlQuery();
    }

    @NotNull
    public Collection<DbmsBean.ConstraintDefinition> getConstraints(Connection connection, @NotNull String table, @Nullable String column) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder().append("select TC.CONSTRAINT_NAME, KCU.COLUMN_NAME, TC.CONSTRAINT_TYPE ").append("  from INFORMATION_SCHEMA.TABLE_CONSTRAINTS TC ").append("  join INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU ").append("       on TC.TABLE_SCHEMA = KCU.TABLE_SCHEMA ").append("       and TC.TABLE_NAME = KCU.TABLE_NAME ").append("       and TC.CONSTRAINT_CATALOG = KCU.CONSTRAINT_CATALOG ").append("       and TC.CONSTRAINT_SCHEMA = KCU.CONSTRAINT_SCHEMA ").append("       and TC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME ").append(String.format("where upper(TC.TABLE_NAME) = '%s' ", table.toUpperCase()));
        String schema = this.getCatalog(connection);
        if (schema != null) {
            queryBuilder.append(String.format("and TC.TABLE_SCHEMA='%s' ", schema));
        }
        return this.getConstraintDefinitions(connection, queryBuilder.toString(), column, null);
    }

    @NotNull
    public String getConcat(String ... values) {
        return "concat(" + Joiner.on((String)", ").join((Object[])values) + ")";
    }

    public void resizeVarcharColumn(@NotNull Connection connection, String tableName, String columnName, int newSize, boolean isNullable, @Nullable String defaultValue) throws SQLException {
        String nullability = isNullable ? "null" : "not null";
        String defaultValueString = StringUtils.defaultString((String)defaultValue, (String)"null");
        JdbcUtils.execute(connection, "alter table " + tableName + " change column `" + columnName + "` `" + columnName + "` varchar(" + newSize + ") " + nullability + " default " + defaultValueString, new String[0]);
    }

    @Override
    public boolean isMySql() {
        return true;
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.MYSQL;
    }

    @Override
    protected void changeColumnDefinition(Connection c, String table, String column, String sqlType, boolean isNullable) throws SQLException {
        JdbcUtils.execute(c, "alter table %s modify column %s %s %s", table, column, sqlType, isNullable ? "" : "not null");
    }

    @Override
    protected void dropConstraints(Connection connection, String tableName, String columnName) {
        log.info((Object)"Using a default constraint names");
        boolean allConstraintsDropped = true;
        try {
            for (DbmsBean.ConstraintDefinition constraint : this.getConstraints(connection, tableName, columnName)) {
                try {
                    JdbcUtils.execute(connection, "ALTER TABLE %s DROP FOREIGN KEY %s", tableName, constraint.getName());
                }
                catch (SQLException e) {
                    allConstraintsDropped = false;
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!allConstraintsDropped) {
            log.info((Object)"Some of the constraints weren't dropped");
        }
    }

    @Override
    public void dropConstraint(Connection c, String tableName, String constraint) throws SQLException {
        JdbcUtils.execute(c, "alter table %s drop key %s", tableName, constraint);
    }

    @Override
    public void dropForeignKeyConstraint(Connection c, String tableName, String foreignKey) throws SQLException {
        JdbcUtils.execute(c, "alter table %s drop foreign key %s", tableName, foreignKey);
        try {
            this.dropIndex(c, tableName, foreignKey);
        }
        catch (SQLException e) {
            log.info((Object)("Not dropped " + foreignKey + " on " + tableName));
        }
    }

    @Override
    public void actuallyChangeColumnToNotNull(Connection c, String tableName, String columnName) throws SQLException {
        DbmsBean.ColumnDefinition columnDefinition = this.getColumnDefinition(c, tableName, columnName);
        JdbcUtils.execute(c, "alter table %s modify column %s %s not null", tableName, columnName, columnDefinition.getSqlType());
    }

    @Override
    public String quote(String name) {
        return "`" + name + "`";
    }

    @Override
    public void changeTableNameToUpperCase(Connection connection, String oldName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String tempName = oldName + "_temp";
            if (this.isTablePresent(connection, oldName)) {
                statement.execute(String.format(RENAME_TABLE, oldName, tempName));
            } else {
                log.info((Object)("Table " + oldName + " not found. Probably migrating from older Bamboo version."));
            }
            if (this.isTablePresent(connection, tempName)) {
                statement.execute(String.format(RENAME_TABLE, tempName, oldName.toUpperCase(Locale.ENGLISH)));
            } else {
                log.info((Object)("Table " + tempName + " not found"));
            }
            connection.commit();
        }
    }

    public void dropPrimaryKey(Connection connection, String tableName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("alter table " + tableName + " drop primary key");
        }
    }

    @Override
    public void renameColumn(Connection c, String tableName, String oldName, String newName) throws SQLException {
        DbmsBean.ColumnDefinition columnSpec = this.getColumnDefinition(c, tableName, oldName);
        Objects.requireNonNull(columnSpec, String.format("Column [%s] not found in [%s:%s:%s]", oldName, this.getCatalog(c), this.getSchema(c), tableName));
        JdbcUtils.execute(c, "alter table %s change %s %s %s", tableName, oldName, newName, columnSpec.getSqlType());
    }

    @Override
    protected DbmsBean.ColumnDefinition newColumnDefinition(String columnName, int dataType, String dataTypeName, OptionalInt columnSize, Optional<Boolean> isNullable) {
        OptionalInt actualColumnSize = dataTypeName.equals("LONGTEXT") ? OptionalInt.empty() : columnSize;
        return super.newColumnDefinition(columnName, dataType, dataTypeName, actualColumnSize, isNullable);
    }
}

