/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import com.atlassian.bamboo.utils.db.AbstractDbmsBean;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.atlassian.bamboo.utils.db.SqlQueryProvider;
import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleDbmsBean
extends AbstractDbmsBean {
    @NotNull
    public Collection<DbmsBean.ConstraintDefinition> getConstraints(Connection connection, @NotNull String table, @Nullable String column) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder().append("select /*+ RULE */ TC.CONSTRAINT_NAME, CCU.COLUMN_NAME, TC.CONSTRAINT_TYPE ").append("  from ALL_CONSTRAINTS TC ").append("  join ALL_CONS_COLUMNS CCU ").append("       on TC.TABLE_NAME = CCU.TABLE_NAME ").append("       and TC.CONSTRAINT_NAME = CCU.CONSTRAINT_NAME ").append(String.format("where upper(TC.TABLE_NAME) = '%s' ", table.toUpperCase()));
        String schema = this.getSchema(connection);
        if (schema != null) {
            queryBuilder.append(String.format("and TC.OWNER = '%s' ", schema));
        }
        return this.getConstraintDefinitions(connection, queryBuilder.toString(), column, null);
    }

    @Override
    protected DbmsBean.ConstraintDefinition.ConstraintType getConstraintType(String typeName) {
        return switch (typeName) {
            case "R" -> DbmsBean.ConstraintDefinition.ConstraintType.FOREIGN_KEY;
            case "P" -> DbmsBean.ConstraintDefinition.ConstraintType.PRIMARY_KEY;
            case "U" -> DbmsBean.ConstraintDefinition.ConstraintType.UNIQUE;
            case "C" -> DbmsBean.ConstraintDefinition.ConstraintType.CHECK;
            case "F", "V", "O", "H", "S" -> DbmsBean.ConstraintDefinition.ConstraintType.UNDEFINED;
            default -> throw new IllegalArgumentException("Unknown constraint type " + typeName);
        };
    }

    @Override
    public void dropIndex(Connection c, String table, String index) throws SQLException {
        JdbcUtils.execute(c, "drop index %s", index);
    }

    @NotNull
    public String getQuery(@NotNull SqlQueryProvider sqlQueryProvider) {
        return sqlQueryProvider.getOracleQuery();
    }

    @NotNull
    public String getConcat(String ... values) {
        return Joiner.on((String)" || ").join((Object[])values);
    }

    public void resizeVarcharColumn(@NotNull Connection connection, String tableName, String columnName, int newSize, boolean isNullable, @Nullable String defaultValue) throws SQLException {
        JdbcUtils.execute(connection, "alter table " + tableName + " modify (" + columnName + " VARCHAR2(" + newSize + "))", new String[0]);
    }

    @Override
    public boolean isOracle() {
        return true;
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.ORACLE;
    }

    public void dropPrimaryKey(Connection connection, String tableName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("alter table " + tableName + " drop primary key");
        }
    }

    @Override
    public void renameColumn(Connection c, String tableName, String oldName, String newName) throws SQLException {
        JdbcUtils.execute(c, "alter table %s rename column %s to %s", tableName, oldName, newName);
    }

    @Override
    public void actuallyChangeColumnToNotNull(Connection c, String tableName, String columnName) throws SQLException {
        JdbcUtils.execute(c, "alter table %s modify (%s not null)", tableName, columnName);
    }

    @Override
    public Collection<DbmsBean.IndexDefinition> getIndices(@NotNull Connection c, @NotNull String table) throws SQLException {
        return super.getIndices(c, table.toUpperCase());
    }

    @Override
    @NotNull
    public String clobEquals(@NotNull String columnName) {
        return String.format("dbms_lob.compare(%s, ?) = 0", columnName);
    }
}

