/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import com.atlassian.bamboo.utils.db.AbstractDbmsBean;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.atlassian.bamboo.utils.db.SqlQueryProvider;
import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgreSqlDbmsBean
extends AbstractDbmsBean {
    @NotNull
    public String getQuery(@NotNull SqlQueryProvider sqlQueryProvider) {
        return sqlQueryProvider.getPostgreSqlQuery();
    }

    @NotNull
    public String getConcat(String ... values) {
        return Joiner.on((String)" || ").join((Object[])values);
    }

    @NotNull
    public Collection<DbmsBean.ConstraintDefinition> getConstraints(Connection connection, @NotNull String table, @Nullable String column) throws SQLException {
        String schema;
        table = PostgreSqlDbmsBean.unquote(table);
        StringBuilder queryBuilder = new StringBuilder().append("select TC.CONSTRAINT_NAME, KCU.COLUMN_NAME, TC.CONSTRAINT_TYPE ").append("  from INFORMATION_SCHEMA.TABLE_CONSTRAINTS TC ").append("  join INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU ").append("       on TC.TABLE_CATALOG = KCU.TABLE_CATALOG ").append("       and TC.TABLE_SCHEMA = KCU.TABLE_SCHEMA ").append("       and TC.TABLE_NAME = KCU.TABLE_NAME ").append("       and TC.CONSTRAINT_CATALOG = KCU.CONSTRAINT_CATALOG ").append("       and TC.CONSTRAINT_SCHEMA = KCU.CONSTRAINT_SCHEMA ").append("       and TC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME ").append(String.format("where lower(TC.TABLE_NAME) = '%s' ", table.toLowerCase()));
        String catalog = this.getCatalog(connection);
        if (catalog != null) {
            queryBuilder.append(String.format("and TC.TABLE_CATALOG='%s' ", catalog));
        }
        if ((schema = this.getSchema(connection)) != null) {
            queryBuilder.append(String.format("and TC.TABLE_SCHEMA='%s' ", schema));
        }
        return this.getConstraintDefinitions(connection, queryBuilder.toString(), column, this::quoteIfNeeded);
    }

    public void resizeVarcharColumn(@NotNull Connection connection, String tableName, String columnName, int newSize, boolean isNullable, @Nullable String defaultValue) throws SQLException {
        JdbcUtils.execute(connection, "alter table " + tableName + " alter " + columnName + " type character varying(" + newSize + ")", new String[0]);
    }

    @Override
    public boolean isPostgreSql() {
        return true;
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.POSTGRESQL;
    }

    public void dropPrimaryKey(Connection c, String tableName) throws SQLException {
        String pkName = PostgreSqlDbmsBean.getPrimaryKeyName(c, tableName);
        JdbcUtils.execute(c, "alter table %s drop constraint %s", tableName, pkName);
    }

    @NotNull
    private static String getPrimaryKeyName(Connection c, String table) throws SQLException {
        table = PostgreSqlDbmsBean.unquote(table);
        String sql = "select constraint_name from information_schema.table_constraints where lower(table_name) = '%s' and constraint_type='PRIMARY KEY'";
        return JdbcUtils.executeSingleValueQuery(c, "select constraint_name from information_schema.table_constraints where lower(table_name) = '%s' and constraint_type='PRIMARY KEY'", table.toLowerCase());
    }

    @Override
    protected void changeColumnDefinition(Connection c, String table, String column, String sqlType, boolean isNullable) throws SQLException {
        JdbcUtils.execute(c, "alter table %s alter column %s set data type %s, alter column %s %s not null", table, column, sqlType, column, isNullable ? "drop" : "set");
    }

    @Override
    public void dropIndex(Connection c, String table, String index) throws SQLException {
        JdbcUtils.execute(c, "drop index %s", index);
    }

    @Override
    public void renameColumn(Connection c, String tableName, String oldName, String newName) throws SQLException {
        JdbcUtils.execute(c, "alter table %s rename column %s to %s", tableName, oldName, newName);
    }

    @Override
    protected String quoteIfNeeded(String name) {
        return name.toLowerCase().equals(name) ? name : this.quote(name);
    }

    @Override
    protected String unquoteIfNeeded(String name) {
        return PostgreSqlDbmsBean.unquote(name);
    }

    private static String unquote(@Nullable String table) {
        return StringUtils.strip((String)table, (String)"\"");
    }

    private static String unquoteOrLower(@NotNull String table) {
        if (table.startsWith("\"")) {
            return StringUtils.strip((String)table, (String)"\"");
        }
        return table.toLowerCase();
    }

    @Override
    public Set<String> getIndexNames(@NotNull Connection c, @NotNull String table, @Nullable String column) throws SQLException {
        return super.getIndexNames(c, table, PostgreSqlDbmsBean.unquote(column));
    }

    @Override
    public Collection<DbmsBean.IndexDefinition> getIndices(@NotNull Connection c, @NotNull String table) throws SQLException {
        return super.getIndices(c, PostgreSqlDbmsBean.unquoteOrLower(table));
    }

    @Override
    public boolean isTablePresent(@NotNull Connection c, @NotNull String tableName) throws SQLException {
        return super.isTablePresent(c, tableName.toLowerCase());
    }

    @Override
    protected boolean isTable(List<String> definitionColumns) {
        return !definitionColumns.get(3).equals("INDEX");
    }

    @Override
    public List<DbmsBean.ColumnDefinition> getColumns(Connection c, @NotNull String table, @Nullable String column) throws SQLException {
        return super.getColumns(c, table.toLowerCase(), StringUtils.lowerCase((String)column));
    }
}

