/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable;

import com.atlassian.bamboo.cluster.BambooClusterSettings;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persistence3.BambooHibernateVersionAwareObjectDao;
import com.atlassian.bamboo.persistence3.DeletionSQLAdapter;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionDao;
import com.atlassian.bamboo.variable.VariableDefinitionImpl;
import com.atlassian.bamboo.variable.VariableDefinitionImpl_;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.versioning.PlanVersioningSupplement;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;

public class VariableDefinitionHibernateDao
extends BambooHibernateVersionAwareObjectDao<VariableDefinition, Plan>
implements VariableDefinitionDao {
    private static final Class<? extends VariableDefinition> PERSISTENT_CLASS = VariableDefinitionImpl.class;
    private static final String KEY = "key";
    private static final String PLAN_ID = "plan.id";
    private static final Property ENVIRONMENT_ID = Property.forName((String)"environmentId");
    private static final String DEPLOYMENT_VERSION_ID = "deploymentVersionId";
    private static final Property PROJECT_ID = Property.forName((String)"projectId");
    private final TransactionAndHibernateTemplate transactionTemplate;
    private final VersioningSupplement<Plan> versioningSupplement;

    public VariableDefinitionHibernateDao(TransactionAndHibernateTemplate transactionTemplate, BambooClusterSettings bambooClusterSettings) {
        this.transactionTemplate = transactionTemplate;
        this.versioningSupplement = new PlanVersioningSupplement(bambooClusterSettings);
    }

    @Override
    @NotNull
    protected Optional<VersioningSupplement<Plan>> getRootVersioningSupplement() {
        return Optional.of(this.versioningSupplement);
    }

    public VariableDefinition findById(long id) {
        return super.findById(id, PERSISTENT_CLASS);
    }

    @NotNull
    public List<VariableDefinition> findGlobalVariables() {
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"variableType", (Object)VariableType.GLOBAL)).list());
    }

    @NotNull
    public List<Long> findAllProjectIdsUsingProjectVariables() {
        return new JpaUtils.CriteriaQuery<VariableDefinitionImpl, Long>(this.getSessionFactory(), VariableDefinitionImpl.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity.get(VariableDefinitionImpl_.projectId)).where((Expression)this.cb.equal((Expression)this.entity.get(VariableDefinitionImpl_.variableType), (Object)VariableType.PROJECT)).distinct(true);
            }
        }.getResultList();
    }

    @NotNull
    public Long countAllProjectVariables() {
        return (Long)new JpaUtils.CriteriaQuery<VariableDefinitionImpl, Long>(this.getSessionFactory(), VariableDefinitionImpl.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where((Expression)this.cb.equal((Expression)this.entity.get("variableType"), (Object)VariableType.PROJECT));
            }
        }.getSingleResult();
    }

    @Override
    public void save(@NotNull VariableDefinition variableDefinition) {
        if (variableDefinition.getId() != -1L) {
            this.getCacheAwareHibernateTemplate().merge((Object)variableDefinition);
            this.incrementRootVersion(variableDefinition);
        } else {
            super.save(variableDefinition);
        }
    }

    @NotNull
    public List<VariableDefinition> findVariablesByPlan(@NotNull PlanIdentifier plan) {
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)PLAN_ID, (Object)plan.getId())).list());
    }

    @NotNull
    public List<VariableDefinition> findVariablesByPlan(@NotNull long planId) {
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)PLAN_ID, (Object)planId)).list());
    }

    public int countVariablesByEnvironmentId(long environmentId) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute(session -> (Number)session.createCriteria(PERSISTENT_CLASS).add((Criterion)ENVIRONMENT_ID.eq((Object)environmentId)).setProjection(Projections.rowCount()).uniqueResult())).intValue();
    }

    @NotNull
    public Iterable<VariableDefinition> findVariablesByEnvironmentId(long environmentId) {
        return (Iterable)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)ENVIRONMENT_ID.eq((Object)environmentId)).list());
    }

    @NotNull
    public Iterable<VariableDefinition> findVariablesByVersionId(long deploymentVersionId) {
        return (Iterable)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)DEPLOYMENT_VERSION_ID, (Object)deploymentVersionId)).list());
    }

    @NotNull
    public List<VariableDefinition> findVariablesByProjectId(long projectId) {
        return (List)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)PROJECT_ID.eq((Object)projectId)).list());
    }

    public int deleteByEnvironment(@NotNull DeletionSQLAdapter deletionAdapter) {
        String SQL_DELETE = String.format("delete from VARIABLE_DEFINITION where ENVIRONMENT_ID in (%s)", deletionAdapter.getInClause());
        AtomicInteger result = new AtomicInteger();
        this.transactionTemplate.doWork(connection -> result.set(JdbcUtils.runDeleteQuery(connection, SQL_DELETE, "VariableDefinition")));
        return result.get();
    }

    public int deleteByDeploymentVersion(@NotNull DeletionSQLAdapter deletionAdapter) {
        String SQL_DELETE = String.format("delete from VARIABLE_DEFINITION where DEPLOYMENT_VERSION_ID in (%s)", deletionAdapter.getInClause());
        AtomicInteger result = new AtomicInteger();
        this.transactionTemplate.doWork(connection -> result.set(JdbcUtils.runDeleteQuery(connection, SQL_DELETE, "VariableDefinition")));
        return result.get();
    }

    public int deleteByPlan(final long planId) {
        return new JpaUtils.CriteriaDelete<VariableDefinitionImpl>(this.getSessionFactory(), VariableDefinitionImpl.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get("plan").get("id"), (Object)planId));
            }
        }.executeUpdate();
    }

    public int deleteByProjectId(final long projectId) {
        return new JpaUtils.CriteriaDelete<VariableDefinitionImpl>(this.getSessionFactory(), VariableDefinitionImpl.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get("projectId"), (Object)projectId));
            }
        }.executeUpdate();
    }

    public VariableDefinition findPlanVariableByKey(@NotNull PlanIdentifier plan, @NotNull String key) {
        return (VariableDefinition)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)PLAN_ID, (Object)plan.getId())).add((Criterion)Restrictions.eq((String)KEY, (Object)key)).uniqueResult());
    }

    public VariableDefinition findGlobalVariableByKey(@NotNull String key) {
        return (VariableDefinition)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"variableType", (Object)VariableType.GLOBAL)).add((Criterion)Restrictions.eq((String)KEY, (Object)key)).uniqueResult());
    }

    @NotNull
    public Collection<? extends VariableDefinition> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    public long countAll() {
        return this.countAll(PERSISTENT_CLASS);
    }
}

