/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.variable.baseline;

import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.hibernate.callbacks.IteratorHibernateCallback;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.baseline.VariableBaselineItemImpl;
import com.atlassian.bamboo.variable.baseline.VariableContextBaseline;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineImpl;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate5.HibernateCallback;

public class VariableContextBaselineHibernateDao
extends BambooHibernateObjectDao<VariableContextBaseline>
implements VariableContextBaselineDao {
    private static final Logger log = Logger.getLogger(VariableContextBaselineHibernateDao.class);
    private static final Class<VariableContextBaselineImpl> PERSISTENT_CLASS = VariableContextBaselineImpl.class;
    private static final EnumSet<VariableType> BASELINE_TYPES = EnumSet.of(VariableType.ENVIRONMENT, VariableType.GLOBAL, VariableType.PLAN, VariableType.PROJECT);
    private ManagedLock variableModifyLock = ManagedLocks.newManagedLock();
    private final TransactionAndHibernateTemplate transactionTemplate;
    @Lazy
    @Inject
    private DbmsBean dbmsBean;

    public VariableContextBaselineHibernateDao(TransactionAndHibernateTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    @Nullable
    public VariableContextBaseline findById(long id) {
        return (VariableContextBaseline)this.findById(id, PERSISTENT_CLASS);
    }

    @Nullable
    public VariableContextBaseline findByDeploymentResultId(long deploymentResultId) {
        return (VariableContextBaseline)this.getCacheAwareHibernateTemplate().execute(session -> (VariableContextBaseline)session.getNamedQuery("findVariableContextBaselineByDeploymentResultId").setParameter("deploymentResultId", (Object)deploymentResultId).uniqueResult());
    }

    public int deleteOrphans() {
        Supplier<String> template = () -> {
            String deleteFromBaselineTemplate = "delete from param1  where VARIABLE_CONTEXT_BASELINE_ID not in        (select distinct VARIABLE_CONTEXT_BASELINE_ID from DEPLOYMENT_RESULT where VARIABLE_CONTEXT_BASELINE_ID is not null)        AND VARIABLE_CONTEXT_BASELINE_ID not in        (select distinct VARIABLE_CONTEXT_BASELINE_ID from BUILDRESULTSUMMARY where VARIABLE_CONTEXT_BASELINE_ID is not null)        AND VARIABLE_CONTEXT_BASELINE_ID not in        (select distinct VARIABLE_CONTEXT_BASELINE_ID from DEPLOYMENT_VERSION where VARIABLE_CONTEXT_BASELINE_ID is not null)";
            String deleteFromBaselineTemplateMysqlAndPostgres = "delete from param1 where not exists (select 1 from BUILDRESULTSUMMARY where param1.VARIABLE_CONTEXT_BASELINE_ID=BUILDRESULTSUMMARY.VARIABLE_CONTEXT_BASELINE_ID) and not exists (select 1 from DEPLOYMENT_RESULT where param1.VARIABLE_CONTEXT_BASELINE_ID=DEPLOYMENT_RESULT.VARIABLE_CONTEXT_BASELINE_ID) and not exists (select 1 from DEPLOYMENT_VERSION where param1.VARIABLE_CONTEXT_BASELINE_ID=DEPLOYMENT_VERSION.VARIABLE_CONTEXT_BASELINE_ID)";
            return this.dbmsBean.isMySql() || this.dbmsBean.isPostgreSql() ? "delete from param1 where not exists (select 1 from BUILDRESULTSUMMARY where param1.VARIABLE_CONTEXT_BASELINE_ID=BUILDRESULTSUMMARY.VARIABLE_CONTEXT_BASELINE_ID) and not exists (select 1 from DEPLOYMENT_RESULT where param1.VARIABLE_CONTEXT_BASELINE_ID=DEPLOYMENT_RESULT.VARIABLE_CONTEXT_BASELINE_ID) and not exists (select 1 from DEPLOYMENT_VERSION where param1.VARIABLE_CONTEXT_BASELINE_ID=DEPLOYMENT_VERSION.VARIABLE_CONTEXT_BASELINE_ID)" : "delete from param1  where VARIABLE_CONTEXT_BASELINE_ID not in        (select distinct VARIABLE_CONTEXT_BASELINE_ID from DEPLOYMENT_RESULT where VARIABLE_CONTEXT_BASELINE_ID is not null)        AND VARIABLE_CONTEXT_BASELINE_ID not in        (select distinct VARIABLE_CONTEXT_BASELINE_ID from BUILDRESULTSUMMARY where VARIABLE_CONTEXT_BASELINE_ID is not null)        AND VARIABLE_CONTEXT_BASELINE_ID not in        (select distinct VARIABLE_CONTEXT_BASELINE_ID from DEPLOYMENT_VERSION where VARIABLE_CONTEXT_BASELINE_ID is not null)";
        };
        String sqlDeleteBaseline = template.get().replace("param1", "VARIABLE_CONTEXT_BASELINE");
        String sqlDeleteBaselineItem = template.get().replace("param1", "VARIABLE_BASELINE_ITEM");
        try {
            return (Integer)this.variableModifyLock.withLock(() -> {
                AtomicInteger result = new AtomicInteger();
                this.transactionTemplate.doWork(connection -> {
                    JdbcUtils.runDeleteQuery(connection, sqlDeleteBaselineItem, "VariableContextBaselineItem");
                    result.set(JdbcUtils.runDeleteQuery(connection, sqlDeleteBaseline, "VariableContextBaseline"));
                });
                return result.get();
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to delete VariableContextBaseline orphans", e);
        }
    }

    public long iterateVariableContextBaselinesForExport(final @NotNull Consumer<VariableContextBaseline> consumer) {
        return ((Integer)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new IteratorHibernateCallback<VariableContextBaseline>(100){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportVariableContextBaselines");
            }

            @Override
            public void nextResultItem(@NotNull Session session, @NotNull VariableContextBaseline baseline, int count) throws HibernateException {
                consumer.accept(baseline);
                session.evict((Object)baseline);
            }
        })).intValue();
    }

    @Nullable
    public VariableContextBaseline getVariableContextBaseline(long variableContextBaselineId) {
        VariableContextBaseline variableContextBaseline = (VariableContextBaseline)this.getCacheAwareHibernateTemplate().get(PERSISTENT_CLASS, (Serializable)Long.valueOf(variableContextBaselineId));
        if (variableContextBaseline != null && !Hibernate.isInitialized((Object)variableContextBaseline.getVariables())) {
            Hibernate.initialize((Object)variableContextBaseline);
        }
        return variableContextBaseline;
    }

    public VariableContextBaseline resolveVariableContextBaseline(@NotNull VariableContext variableContext) {
        FinalArrayList variables = variableContext.getOriginalVariables().values().stream().filter(input -> BASELINE_TYPES.contains(input.getVariableType()) && !PasswordMaskingUtils.shouldBeMasked((String)input.getKey())).map(contextEntry -> new VariableBaselineItemImpl(contextEntry.getKey(), contextEntry.getValue(), contextEntry.getVariableType(), null)).collect(Collectors.toCollection(FinalArrayList::new));
        if (!variables.isEmpty()) {
            VariableContextBaselineImpl variableContextBaseline = new VariableContextBaselineImpl();
            variableContextBaseline.initVariables(variables);
            try {
                return (VariableContextBaseline)this.variableModifyLock.withLock(() -> {
                    VariableContextBaseline existingVCB = this.findExistingBaseline(variableContextBaseline);
                    if (existingVCB != null) {
                        return existingVCB;
                    }
                    this.save(variableContextBaseline);
                    return variableContextBaseline;
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to resolve VariableContextBaseline", e);
            }
        }
        return null;
    }

    @Nullable
    private VariableContextBaseline findExistingBaseline(@NotNull VariableContextBaselineImpl vcb) {
        List candidates = (List)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).add((Criterion)Restrictions.eq((String)"hash", (Object)vcb.getHash())).addOrder(Order.desc((String)"id")).list());
        return candidates.stream().filter(VariableContextBaselineImpl.sameBaseline((VariableContextBaselineImpl)vcb)).findAny().orElse(null);
    }
}

