/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.versioning;

import com.atlassian.bamboo.cluster.BambooClusterSettings;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;
import org.hibernate.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVersioningSupplement<T, R>
implements VersioningSupplement<T> {
    protected final BambooClusterSettings bambooClusterSettings;
    private final Class<R> type;
    private static final String VERSION_FIELD = "version";

    protected AbstractVersioningSupplement(@NotNull BambooClusterSettings bambooClusterSettings, @NotNull Class<R> type) {
        this.bambooClusterSettings = bambooClusterSettings;
        this.type = type;
    }

    protected void incrementVersion(@Nullable Session session, boolean canExecute, @NotNull TriConsumer<CriteriaBuilder, CriteriaUpdate<R>, Root<R>> where) {
        if (this.bambooClusterSettings.isOptimisticLockingEnabled() && session != null && canExecute) {
            Triple<CriteriaBuilder, CriteriaUpdate<R>, Root<R>> triple = this.commonQuerySetup(session);
            where.accept((Object)((CriteriaBuilder)triple.getLeft()), (Object)((CriteriaUpdate)triple.getMiddle()), (Object)((Root)triple.getRight()));
            session.createQuery((CriteriaUpdate)triple.getMiddle()).executeUpdate();
        }
    }

    @NotNull
    private Triple<CriteriaBuilder, CriteriaUpdate<R>, Root<R>> commonQuerySetup(@NotNull Session session) {
        CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
        CriteriaUpdate criteriaUpdate = criteriaBuilder.createCriteriaUpdate(this.type);
        Root root = criteriaUpdate.from(this.type);
        Path versionPath = root.get(VERSION_FIELD);
        Expression incrementVersion = criteriaBuilder.sum((Number)1L, (Expression)versionPath);
        criteriaUpdate.set(versionPath, incrementVersion);
        return Triple.of((Object)criteriaBuilder, (Object)criteriaUpdate, (Object)root);
    }
}

