/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.versioning;

import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.persistence3.StatelessSessionHibernateDaoSupport;
import com.atlassian.bamboo.plan.dto.IdWithVersionDto;
import com.atlassian.bamboo.plan.dto.IdWithVersionDtoImpl;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.versioning.VersionDao;
import com.atlassian.bamboo.versioning.Versionable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class VersionHibernateDao
extends StatelessSessionHibernateDaoSupport
implements VersionDao {
    private static final Logger log = Logger.getLogger(VersionHibernateDao.class);
    private static final String ID_KEY = "id";
    private static final String VERSION_KEY = "version";
    @Lazy
    @Inject
    private DbmsBean dbmsBean;

    @NotNull
    public <T extends Versionable> List<IdWithVersionDto> getVersions(@NotNull Set<Long> ids, @NotNull Class<? extends T> clazz) {
        int maximumNumberOfValuesForIn = HibernateDaoUtils.getMaximumNumberOfValuesForIn(this.dbmsBean);
        if (ids.size() <= maximumNumberOfValuesForIn) {
            return this.getIdsWithVersionsWithoutLimitCheck(new ArrayList<Long>(ids), clazz);
        }
        log.debug((Object)("Running split queries for list of " + ids.size() + " items"));
        return Lists.partition(new ArrayList<Long>(ids), (int)maximumNumberOfValuesForIn).stream().map(partition -> this.getIdsWithVersionsWithoutLimitCheck((List<Long>)partition, clazz)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @NotNull
    private <T extends Versionable> List<IdWithVersionDto> getIdsWithVersionsWithoutLimitCheck(final @NotNull List<Long> ids, @NotNull Class<? extends T> clazz) {
        return new JpaUtils.CriteriaQuery<T, IdWithVersionDto>(this.getSessionFactory(), clazz, IdWithVersionDto.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.construct(IdWithVersionDtoImpl.class, new Selection[]{this.entity.get(VersionHibernateDao.ID_KEY), this.entity.get(VersionHibernateDao.VERSION_KEY)})).where((Expression)this.entity.get(VersionHibernateDao.ID_KEY).in((Collection)ids));
            }
        }.getResultList();
    }
}

