/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webhook;

import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.webhook.WebhookResponse;
import com.atlassian.bamboo.webhook.WebhookResponseDao;
import com.atlassian.bamboo.webhook.WebhookResponseDetails;
import com.atlassian.bamboo.webhook.WebhookResponseDetailsEntity;
import com.atlassian.bamboo.webhook.WebhookResponseDetailsEntity_;
import com.atlassian.bamboo.webhook.WebhookResponseDto;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Selection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebhookResponseHibernateDao
extends BambooHibernateObjectDao<WebhookResponseDetails>
implements WebhookResponseDao {
    private static final Class<WebhookResponseDetailsEntity> PERSISTENT_CLASS = WebhookResponseDetailsEntity.class;

    @NotNull
    public List<WebhookResponse> findWebhookResponseByDeploymentResultId(final Long deploymentResultId) {
        return new JpaUtils.CriteriaQuery<WebhookResponseDetailsEntity, WebhookResponse>(this.getSessionFactory(), PERSISTENT_CLASS, WebhookResponse.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.construct(WebhookResponseDto.class, new Selection[]{this.entity.get(WebhookResponseDetailsEntity_.id), this.entity.get(WebhookResponseDetailsEntity_.uuid), this.entity.get(WebhookResponseDetailsEntity_.templateName), this.entity.get(WebhookResponseDetailsEntity_.eventName), this.entity.get(WebhookResponseDetailsEntity_.url), this.entity.get(WebhookResponseDetailsEntity_.httpMethod), this.entity.get(WebhookResponseDetailsEntity_.responseStatus), this.entity.get(WebhookResponseDetailsEntity_.statusCode), this.entity.get(WebhookResponseDetailsEntity_.planResultKey), this.entity.get(WebhookResponseDetailsEntity_.deploymentResultId), this.entity.get(WebhookResponseDetailsEntity_.retriesCount), this.entity.get(WebhookResponseDetailsEntity_.sendTime), this.entity.get(WebhookResponseDetailsEntity_.receiveTime)})).where((Expression)this.cb.equal((Expression)this.entity.get(WebhookResponseDetailsEntity_.deploymentResultId), (Object)deploymentResultId)).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get(WebhookResponseDetailsEntity_.uuid))});
            }
        }.getResultList();
    }

    @NotNull
    public List<WebhookResponse> findWebhookResponseByPlanResultKey(final String planResultKey) {
        return new JpaUtils.CriteriaQuery<WebhookResponseDetailsEntity, WebhookResponse>(this.getSessionFactory(), PERSISTENT_CLASS, WebhookResponse.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.construct(WebhookResponseDto.class, new Selection[]{this.entity.get(WebhookResponseDetailsEntity_.id), this.entity.get(WebhookResponseDetailsEntity_.uuid), this.entity.get(WebhookResponseDetailsEntity_.templateName), this.entity.get(WebhookResponseDetailsEntity_.eventName), this.entity.get(WebhookResponseDetailsEntity_.url), this.entity.get(WebhookResponseDetailsEntity_.httpMethod), this.entity.get(WebhookResponseDetailsEntity_.responseStatus), this.entity.get(WebhookResponseDetailsEntity_.statusCode), this.entity.get(WebhookResponseDetailsEntity_.planResultKey), this.entity.get(WebhookResponseDetailsEntity_.deploymentResultId), this.entity.get(WebhookResponseDetailsEntity_.retriesCount), this.entity.get(WebhookResponseDetailsEntity_.sendTime), this.entity.get(WebhookResponseDetailsEntity_.receiveTime)})).where((Expression)this.cb.equal((Expression)this.entity.get(WebhookResponseDetailsEntity_.planResultKey), (Object)planResultKey)).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get(WebhookResponseDetailsEntity_.uuid)), this.cb.asc((Expression)this.entity.get(WebhookResponseDetailsEntity_.retriesCount))});
            }
        }.getResultList();
    }

    @NotNull
    public List<WebhookResponseDetails> findWebhookResponseDetailsByPlanResultKey(final String planResultKey) {
        return new JpaUtils.CriteriaQuery<WebhookResponseDetailsEntity, WebhookResponseDetails>(this.getSessionFactory(), PERSISTENT_CLASS, WebhookResponseDetails.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(WebhookResponseDetailsEntity_.planResultKey), (Object)planResultKey));
            }
        }.getResultList();
    }

    @NotNull
    public List<WebhookResponseDetails> findWebhookResponseDetailsByDeploymentId(final Long deploymentResultId) {
        return new JpaUtils.CriteriaQuery<WebhookResponseDetailsEntity, WebhookResponseDetails>(this.getSessionFactory(), PERSISTENT_CLASS, WebhookResponseDetails.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(WebhookResponseDetailsEntity_.deploymentResultId), (Object)deploymentResultId));
            }
        }.getResultList();
    }

    @Nullable
    public WebhookResponseDetails getWebhookResponseDetails(final Long webhookResponseId) {
        return (WebhookResponseDetails)new JpaUtils.CriteriaQuery<WebhookResponseDetailsEntity, WebhookResponseDetails>(this.getSessionFactory(), PERSISTENT_CLASS, WebhookResponseDetails.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(WebhookResponseDetailsEntity_.id), (Object)webhookResponseId));
            }
        }.getSingleResult();
    }

    @NotNull
    public Long countWebhookResponsesByDeploymentResultId(final Long deploymentResultId) {
        return (Long)new JpaUtils.CriteriaQuery<WebhookResponseDetailsEntity, Long>(this.getSessionFactory(), PERSISTENT_CLASS, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where((Expression)this.cb.equal((Expression)this.entity.get(WebhookResponseDetailsEntity_.deploymentResultId), (Object)deploymentResultId));
            }
        }.getSingleResult();
    }

    @NotNull
    public List<WebhookResponseDetails> findWebhookResponseDetailsByPlanKey(final String planKey) {
        return new JpaUtils.CriteriaQuery<WebhookResponseDetailsEntity, WebhookResponseDetails>(this.getSessionFactory(), PERSISTENT_CLASS, WebhookResponseDetails.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.like((Expression)this.entity.get(WebhookResponseDetailsEntity_.planResultKey), planKey + "-%"));
            }
        }.getResultList();
    }
}

