/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webhook;

import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.webhook.WebhookTemplate;
import com.atlassian.bamboo.webhook.WebhookTemplateDao;
import com.atlassian.bamboo.webhook.WebhookTemplateEntity;
import com.atlassian.bamboo.webhook.WebhookTemplateEntity_;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Selection;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public class WebhookTemplateHibernateDao
extends BambooHibernateObjectDao<WebhookTemplate>
implements WebhookTemplateDao {
    private static final Class<WebhookTemplateEntity> PERSISTENT_CLASS = WebhookTemplateEntity.class;

    public List<WebhookTemplate> findGlobalTemplates() {
        return new JpaUtils.CriteriaQuery<WebhookTemplateEntity, WebhookTemplate>(this.getSessionFactory(), PERSISTENT_CLASS, WebhookTemplate.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get(WebhookTemplateEntity_.name))});
            }
        }.getResultList();
    }

    public void deleteById(final long id) {
        new JpaUtils.CriteriaDelete<WebhookTemplateEntity>(this.getSessionFactory(), PERSISTENT_CLASS){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get(WebhookTemplateEntity_.id), (Object)id));
            }
        }.executeUpdate();
    }

    public boolean exists(String webhookName) {
        return this.countWithRestriction(PERSISTENT_CLASS, (Criterion)Restrictions.eq((String)"name", (Object)webhookName)) > 0L;
    }

    public Optional<UUID> findUuidByName(final String webhookName) {
        List ids = new JpaUtils.CriteriaQuery<WebhookTemplateEntity, UUID>(this.getSessionFactory(), PERSISTENT_CLASS, UUID.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity.get(WebhookTemplateEntity_.uuid)).where((Expression)this.cb.equal((Expression)this.entity.get(WebhookTemplateEntity_.name), (Object)webhookName));
            }
        }.getResultList();
        if (ids.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((UUID)ids.get(0));
    }

    public long scrollTokensForExport(final @NotNull Consumer<WebhookTemplate> consumer) {
        ScrollHibernateCallback callback = new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.createQuery("select t from WebhookTemplateEntity t");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                WebhookTemplateEntity webhookTemplateEntity = (WebhookTemplateEntity)data.get(0);
                consumer.accept(webhookTemplateEntity);
                session.evict((Object)webhookTemplateEntity);
            }
        };
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    public Optional<WebhookTemplate> findByUuid(final UUID uuid) {
        List ids = new JpaUtils.CriteriaQuery<WebhookTemplateEntity, WebhookTemplate>(this.getSessionFactory(), PERSISTENT_CLASS, WebhookTemplate.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(WebhookTemplateEntity_.uuid), (Object)uuid));
            }
        }.getResultList();
        return ids.stream().findFirst();
    }
}

