/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.hibernate.CallbackException;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.type.Type;
import org.springframework.beans.BeanWrapperImpl;

public abstract class ChainedInterceptorSupport
implements Interceptor {
    protected final Logger log = Logger.getLogger(this.getClass());
    private Interceptor nextInterceptor;

    public void setNextInterceptor(Interceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    public Interceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    public Object instantiate(String beanClass, EntityMode entityMode, Serializable id) throws CallbackException {
        return this.nextInterceptor != null ? this.nextInterceptor.instantiate(beanClass, entityMode, id) : null;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (this.nextInterceptor != null) {
            return this.nextInterceptor.onLoad(entity, id, state, propertyNames, types);
        }
        return false;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) throws CallbackException {
        if (this.nextInterceptor != null) {
            return this.nextInterceptor.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
        }
        return false;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (this.nextInterceptor != null) {
            return this.nextInterceptor.onSave(entity, id, state, propertyNames, types);
        }
        return false;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.onDelete(entity, id, state, propertyNames, types);
        }
    }

    public void preFlush(Iterator entities) throws CallbackException {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.preFlush(entities);
        }
    }

    public void postFlush(Iterator entities) throws CallbackException {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.postFlush(entities);
        }
    }

    public Boolean isTransient(Object entity) {
        if (this.nextInterceptor != null) {
            return this.nextInterceptor.isTransient(entity);
        }
        return null;
    }

    public int[] findDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (this.nextInterceptor != null) {
            return this.nextInterceptor.findDirty(entity, id, currentState, previousState, propertyNames, types);
        }
        return null;
    }

    public void afterTransactionCompletion(Transaction transaction) {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.afterTransactionCompletion(transaction);
        }
    }

    public String getEntityName(Object object) throws CallbackException {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.getEntityName(object);
        }
        return null;
    }

    public Object getEntity(String entityName, Serializable serializable) throws CallbackException {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.getEntity(entityName, serializable);
        }
        return null;
    }

    public void afterTransactionBegin(Transaction transaction) {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.afterTransactionBegin(transaction);
        }
    }

    public void beforeTransactionCompletion(Transaction transaction) {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.beforeTransactionCompletion(transaction);
        }
    }

    public void onCollectionRecreate(Object collection, Serializable key) throws CallbackException {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.onCollectionRecreate(collection, key);
        }
    }

    public void onCollectionRemove(Object collection, Serializable key) throws CallbackException {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.onCollectionRemove(collection, key);
        }
    }

    public void onCollectionUpdate(Object collection, Serializable key) throws CallbackException {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.onCollectionUpdate(collection, key);
        }
    }

    public String onPrepareStatement(String sql) {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.onPrepareStatement(sql);
        }
        return sql;
    }

    protected static void setIdOnNewEntity(SessionFactory sessionFactory, Class<?> persistentClass, Serializable id, Object newEntity) throws CallbackException {
        try {
            BeanWrapperImpl wrapper = new BeanWrapperImpl(newEntity);
            MetamodelImplementor metamodel = ((SessionFactoryImplementor)sessionFactory).getMetamodel();
            String identifierPropertyName = metamodel.entityPersister(persistentClass).getIdentifierPropertyName();
            wrapper.setPropertyValue(identifierPropertyName, (Object)id);
        }
        catch (HibernateException ex) {
            throw new CallbackException("Error getting identifier property for class " + persistentClass, (Exception)((Object)ex));
        }
    }
}

